/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.datasource.pooled;

import java.util.ArrayList;
import java.util.List;
import org.apache.ibatis.datasource.pooled.PooledConnection;
import org.apache.ibatis.datasource.pooled.PooledDataSource;

public class PoolState {
    protected PooledDataSource dataSource;
    protected final List<PooledConnection> idleConnections = new ArrayList<PooledConnection>();
    protected final List<PooledConnection> activeConnections = new ArrayList<PooledConnection>();
    protected long requestCount = 0L;
    protected long accumulatedRequestTime = 0L;
    protected long accumulatedCheckoutTime = 0L;
    protected long claimedOverdueConnectionCount = 0L;
    protected long accumulatedCheckoutTimeOfOverdueConnections = 0L;
    protected long accumulatedWaitTime = 0L;
    protected long hadToWaitCount = 0L;
    protected long badConnectionCount = 0L;

    public PoolState(PooledDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public synchronized long getRequestCount() {
        return this.requestCount;
    }

    public synchronized long getAverageRequestTime() {
        return this.requestCount == 0L ? 0L : this.accumulatedRequestTime / this.requestCount;
    }

    public synchronized long getAverageWaitTime() {
        return this.hadToWaitCount == 0L ? 0L : this.accumulatedWaitTime / this.hadToWaitCount;
    }

    public synchronized long getHadToWaitCount() {
        return this.hadToWaitCount;
    }

    public synchronized long getBadConnectionCount() {
        return this.badConnectionCount;
    }

    public synchronized long getClaimedOverdueConnectionCount() {
        return this.claimedOverdueConnectionCount;
    }

    public synchronized long getAverageOverdueCheckoutTime() {
        return this.claimedOverdueConnectionCount == 0L ? 0L : this.accumulatedCheckoutTimeOfOverdueConnections / this.claimedOverdueConnectionCount;
    }

    public synchronized long getAverageCheckoutTime() {
        return this.requestCount == 0L ? 0L : this.accumulatedCheckoutTime / this.requestCount;
    }

    public synchronized int getIdleConnectionCount() {
        return this.idleConnections.size();
    }

    public synchronized int getActiveConnectionCount() {
        return this.activeConnections.size();
    }

    public synchronized String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\n===CONFINGURATION==============================================");
        buffer.append("\n jdbcDriver                     ").append(this.dataSource.getDriver());
        buffer.append("\n jdbcUrl                        ").append(this.dataSource.getUrl());
        buffer.append("\n jdbcUsername                   ").append(this.dataSource.getUsername());
        buffer.append("\n jdbcPassword                   ").append(this.dataSource.getPassword() == null ? "NULL" : "************");
        buffer.append("\n poolMaxActiveConnections       ").append(this.dataSource.poolMaximumActiveConnections);
        buffer.append("\n poolMaxIdleConnections         ").append(this.dataSource.poolMaximumIdleConnections);
        buffer.append("\n poolMaxCheckoutTime            ").append(this.dataSource.poolMaximumCheckoutTime);
        buffer.append("\n poolTimeToWait                 ").append(this.dataSource.poolTimeToWait);
        buffer.append("\n poolPingEnabled                ").append(this.dataSource.poolPingEnabled);
        buffer.append("\n poolPingQuery                  ").append(this.dataSource.poolPingQuery);
        buffer.append("\n poolPingConnectionsNotUsedFor  ").append(this.dataSource.poolPingConnectionsNotUsedFor);
        buffer.append("\n ---STATUS-----------------------------------------------------");
        buffer.append("\n activeConnections              ").append(this.getActiveConnectionCount());
        buffer.append("\n idleConnections                ").append(this.getIdleConnectionCount());
        buffer.append("\n requestCount                   ").append(this.getRequestCount());
        buffer.append("\n averageRequestTime             ").append(this.getAverageRequestTime());
        buffer.append("\n averageCheckoutTime            ").append(this.getAverageCheckoutTime());
        buffer.append("\n claimedOverdue                 ").append(this.getClaimedOverdueConnectionCount());
        buffer.append("\n averageOverdueCheckoutTime     ").append(this.getAverageOverdueCheckoutTime());
        buffer.append("\n hadToWait                      ").append(this.getHadToWaitCount());
        buffer.append("\n averageWaitTime                ").append(this.getAverageWaitTime());
        buffer.append("\n badConnectionCount             ").append(this.getBadConnectionCount());
        buffer.append("\n===============================================================");
        return buffer.toString();
    }
}

