/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.embedded.tomcat;

import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.core.StandardContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.context.embedded.ServletContextInitializer;
import org.springframework.util.Assert;

public class ServletContextInitializerLifecycleListener
implements LifecycleListener {
    private static Log logger = LogFactory.getLog(ServletContextInitializerLifecycleListener.class);
    private final ServletContextInitializer[] initializers;
    private Exception startUpException;

    public ServletContextInitializerLifecycleListener(ServletContextInitializer ... initializers) {
        this.initializers = initializers;
    }

    public Exception getStartUpException() {
        return this.startUpException;
    }

    public void lifecycleEvent(LifecycleEvent event) {
        if ("configure_start".equals(event.getType())) {
            Assert.isInstanceOf(StandardContext.class, (Object)event.getSource());
            StandardContext standardContext = (StandardContext)event.getSource();
            for (ServletContextInitializer initializer : this.initializers) {
                try {
                    initializer.onStartup(standardContext.getServletContext());
                }
                catch (Exception ex) {
                    this.startUpException = ex;
                    logger.error((Object)("Error starting Tomcat context: " + ex.getClass().getName()));
                    break;
                }
            }
        }
    }
}

