/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.common;

import com.crystaldecisions.reports.common.value.NumberValue;

public class NumberUtil {
    public static final int MaxNSignificantFigures = 15;
    public static final long MaxNormalizedLong = (long)Math.pow(10.0, 15.0) - 1L;
    public static final long MinNormalizedLong = -MaxNormalizedLong;
    public static final long MaxNormalizedUnscaledLong = (long)Math.pow(10.0, 13.0) - 1L;
    public static final long MinNormalizedUnscaledLong = -MaxNormalizedUnscaledLong;
    public static final int MaxInt16u = 65535;
    public static final int MaxInt16s = Short.MAX_VALUE;

    public static int numberToInteger(NumberValue numberValue) {
        double d;
        double d2 = numberValue.getDouble();
        double d3 = d = d2 > 0.0 ? Math.floor(d2) : Math.ceil(d2);
        if (d != d2) {
            throw new IndexOutOfBoundsException();
        }
        return (int)d;
    }

    public static int roundNumberToInteger(NumberValue numberValue) {
        double d = NumberUtil.roundFractional(numberValue.getScaledDouble(), 0);
        return (int)(d /= 100.0);
    }

    public static double roundFractional(double d, int n) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            return d;
        }
        double d2 = NumberUtil.calculateScalingFactor(n);
        d = (d /= d2) > 0.0 ? Math.floor(d + 0.5) : Math.ceil(d - 0.5);
        return d * d2;
    }

    public static double roundUpFractional(double d, int n) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            return d;
        }
        double d2 = NumberUtil.calculateScalingFactor(n);
        d = (d /= d2) >= 0.0 ? Math.ceil(d) : Math.floor(d);
        return d * d2;
    }

    public static double calculateScalingFactor(int n) {
        double d = 1.0;
        if (n < 2) {
            for (int i = 2; i > n; --i) {
                d *= 10.0;
            }
        } else {
            for (int i = 2; i < n; ++i) {
                d /= 10.0;
            }
        }
        return d;
    }

    public static final int magnitude(double d) {
        Double d2 = Math.log10(d);
        int n = d2.intValue();
        if (d2 > 0.0 && d < Math.pow(10.0, n)) {
            --n;
        }
        return n;
    }

    public static boolean isNormalized(long l) {
        return MinNormalizedLong <= l && l <= MaxNormalizedLong;
    }

    public static boolean isNormalizedUnscaledLong(long l) {
        return MinNormalizedUnscaledLong <= l && l <= MaxNormalizedUnscaledLong;
    }

    public static boolean isNormalized(double d) {
        long l = (long)d;
        return (double)l == d && NumberUtil.isNormalized(l);
    }

    public static double normalizeDouble(double d) {
        double d2;
        double d3;
        boolean bl;
        if (d == 0.0) {
            return 0.0;
        }
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            return d;
        }
        boolean bl2 = bl = d < 0.0;
        if (bl) {
            d = -d;
        }
        if (Double.isInfinite(d3 = Math.pow(10.0, 15.0 - (d2 = (double)(NumberUtil.magnitude(d) + 1))))) {
            return 0.0;
        }
        d = Math.floor(d * d3 + 0.5) / d3;
        if (bl) {
            d = -d;
        }
        return d;
    }

    public static double truncateDouble(double d) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            return d;
        }
        return d >= 0.0 ? Math.floor(d) : Math.ceil(d);
    }

    public static double truncateFractional(double d, int n) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            return d;
        }
        double d2 = NumberUtil.calculateScalingFactor(n);
        return NumberUtil.truncateDouble(NumberUtil.normalizeDouble(d /= d2)) * d2;
    }

    public static double getFractionalPart(double d) {
        return d - NumberUtil.truncateDouble(d);
    }
}

