/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.common.filemanagement;

import com.crystaldecisions.reports.common.filemanagement.FilterRandomAccessStorage;
import com.crystaldecisions.reports.common.filemanagement.RandomAccessStorage;
import com.crystaldecisions.reports.common.filemanagement.TempRandomAccessStorage;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CachedRandomAccessStorage
extends FilterRandomAccessStorage {
    private static final int D = 8192;
    private static final int C = 13;
    private Map<Integer, Page> E;
    private int J;
    private long L;
    private long H;
    private long K;
    private TempRandomAccessStorage G;
    private final int I;
    private final int F;
    private final boolean B;

    public CachedRandomAccessStorage(RandomAccessStorage randomAccessStorage, int n, int n2) throws IOException {
        super(randomAccessStorage);
        TempRandomAccessStorage tempRandomAccessStorage;
        if (n2 > n) {
            throw new IllegalArgumentException("keptPages should be smaller than maxPages");
        }
        this.L = -1L;
        this.E = new HashMap<Integer, Page>();
        this.I = n;
        this.F = n2;
        boolean bl = this.B = n == n2;
        if (randomAccessStorage instanceof TempRandomAccessStorage && (tempRandomAccessStorage = (TempRandomAccessStorage)randomAccessStorage).inMemory()) {
            this.G = tempRandomAccessStorage;
        }
        this.K = this.G == null ? randomAccessStorage.length() : -1L;
    }

    private void try() throws IOException {
        if (!this.G.inMemory()) {
            this.G = null;
            this.K = this.ras.length();
            this.H = this.ras.getFilePointer();
        }
    }

    private Page do(Integer n) throws IOException {
        Page page = new Page();
        long l = (long)n.intValue() * 8192L;
        page.buf = new byte[8192];
        long l2 = this.K - l;
        if (l2 > 0L) {
            int n2;
            int n3 = n2 = l2 < 8192L ? (int)l2 : 8192;
            if (this.L != l) {
                this.ras.seek(l);
            }
            int n4 = this.ras.read(page.buf, 0, n2);
            assert (n4 == n2);
            this.L = l + (long)n4;
        }
        page.lastAccess = ++this.J;
        this.E.put(n, page);
        if (this.E.size() > this.I) {
            this.vacuum();
        }
        return page;
    }

    private Page if(Integer n) throws IOException {
        Page page = this.E.get(n);
        if (page == null) {
            page = this.do(n);
        } else {
            page.lastAccess = ++this.J;
        }
        return page;
    }

    private void a(Integer n) throws IOException {
        Page page = this.E.get(n);
        if (page != null && page.dirty) {
            long l = (long)n.intValue() * 8192L;
            if (this.L != l) {
                this.ras.seek(l);
            }
            int n2 = this.K - l < 8192L ? (int)(this.K - l) : 8192;
            this.ras.write(page.buf, 0, n2);
            this.L = l + (long)n2;
            page.dirty = false;
        }
    }

    public void flush() throws IOException {
        for (Integer n : this.E.keySet()) {
            this.a(n);
        }
    }

    public long getFilePointer() throws IOException {
        return this.G == null ? this.H : this.G.getFilePointer();
    }

    public long length() throws IOException {
        return this.G == null ? this.K : this.G.length();
    }

    public int read() throws IOException {
        if (this.G != null) {
            return this.G.read();
        }
        long l = this.H;
        if (l >= this.K) {
            return -1;
        }
        int n = (int)(l >> 13);
        int n2 = (int)l & 0x1FFF;
        byte[] byArray = this.if((Integer)Integer.valueOf((int)n)).buf;
        this.H = l + 1L;
        return byArray[n2] & 0xFF;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.G != null) {
            return this.G.read(byArray, n, n2);
        }
        long l = this.H;
        long l2 = this.K;
        if (l >= l2) {
            return -1;
        }
        int n3 = (int)(l >> 13);
        int n4 = (int)l & 0x1FFF;
        if ((long)n2 > l2 - l) {
            n2 = (int)(l2 - l);
        }
        int n5 = n2;
        while (n5 > 0) {
            byte[] byArray2 = this.if((Integer)Integer.valueOf((int)n3)).buf;
            int n6 = Math.min(n5, 8192 - n4);
            System.arraycopy(byArray2, n4, byArray, n, n6);
            if ((n4 += n6) == 8192) {
                n4 = 0;
                ++n3;
            }
            n5 -= n6;
            n += n6;
        }
        this.H = l + (long)n2;
        return n2;
    }

    public void seek(long l) throws IOException {
        if (this.G != null) {
            this.G.seek(l);
        } else {
            this.H = l;
        }
    }

    public void setLength(long l) throws IOException {
        if (this.G != null) {
            this.G.setLength(l);
            this.try();
        } else {
            this.flush();
            this.ras.setLength(l);
            this.K = this.ras.length();
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.G != null) {
            this.G.write(byArray, n, n2);
            this.try();
            return;
        }
        long l = this.H;
        int n3 = (int)(l >> 13);
        int n4 = (int)l & 0x1FFF;
        int n5 = n2;
        while (n5 > 0) {
            Page page = this.if(n3);
            byte[] byArray2 = page.buf;
            int n6 = Math.min(n5, 8192 - n4);
            System.arraycopy(byArray, n, byArray2, n4, n6);
            page.dirty = true;
            if ((n4 += n6) == 8192) {
                n4 = 0;
                ++n3;
            }
            n5 -= n6;
            n += n6;
            if ((l += (long)n6) <= this.K) continue;
            this.K = l;
        }
        this.H = l;
    }

    public void write(int n) throws IOException {
        if (this.G != null) {
            this.G.write(n);
            this.try();
            return;
        }
        long l = this.H;
        int n2 = (int)(l >> 13);
        int n3 = (int)l & 0x1FFF;
        Page page = this.if(n2);
        page.buf[n3] = (byte)n;
        page.dirty = true;
        this.H = l + 1L;
        if (l > this.K) {
            this.K = l;
        }
    }

    private void char(int n) {
        for (Page page : this.E.values()) {
            page.lastAccess -= n;
        }
        this.J -= n;
    }

    private void new() throws IOException {
        Integer n = null;
        int n2 = Integer.MAX_VALUE;
        for (Map.Entry<Integer, Page> entry : this.E.entrySet()) {
            Page page = entry.getValue();
            int n3 = page.lastAccess;
            if (n3 >= n2) continue;
            n2 = n3;
            n = entry.getKey();
        }
        if (n != null) {
            this.a(n);
            this.E.remove(n);
            if (this.J > 2000000000) {
                this.char(n2);
            }
        }
    }

    public void vacuum() throws IOException {
        if (this.B) {
            this.new();
            return;
        }
        int n = this.E.size();
        if (n == 0) {
            return;
        }
        int[] nArray = new int[n];
        int n2 = 0;
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>(n);
        for (Map.Entry<Integer, Page> entry : this.E.entrySet()) {
            Page page = entry.getValue();
            int n3 = page.lastAccess;
            nArray[n2++] = n3;
            hashMap.put(n3, entry.getKey());
        }
        Arrays.sort(nArray);
        int n4 = nArray[n - this.F - 1];
        int n5 = n - this.F;
        for (n2 = 0; n2 < n5; ++n2) {
            int n6 = nArray[n2];
            Integer n7 = (Integer)hashMap.get(n6);
            this.a(n7);
            this.E.remove(n7);
        }
        if (this.J > 2000000000) {
            this.char(n4);
        }
    }

    public String toString() {
        return "cras[p=" + this.H + ",s=" + this.K + "](" + this.ras + ')';
    }

    private static final class Page {
        byte[] buf;
        int lastAccess;
        boolean dirty;

        private Page() {
        }
    }
}

