/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.common.filemanagement;

import com.crystaldecisions.reports.common.filemanagement.InMemoryRandomAccessStorage;
import com.crystaldecisions.reports.common.filemanagement.InsufficientCapacityException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class MemoryRandomAccessStorage
implements InMemoryRandomAccessStorage {
    private static final int A = 13;
    public static final int SEGMENT_SIZE = 8192;
    private static final int z = 8191;
    private byte[][] x;
    private long v;
    private long y;
    private final long w;

    private static void case(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("MemoryRandomAccessStorage: A minimum of 1 in-memory block is needed.");
        }
    }

    public MemoryRandomAccessStorage(int n) {
        MemoryRandomAccessStorage.case(n);
        this.x = new byte[n][];
        this.w = (long)this.x.length << 13;
    }

    public boolean fits(int n) {
        return this.v + (long)n <= this.w;
    }

    public long getFilePointer() throws IOException {
        long l = this.v;
        if (l < 0L) {
            throw new IOException("MemoryRandomAccessStorage closed");
        }
        return l;
    }

    public long length() throws IOException {
        long l = this.y;
        if (l < 0L) {
            throw new IOException("MemoryRandomAccessStorage closed");
        }
        return l;
    }

    public long limit() {
        return this.w;
    }

    public void seek(long l) throws IOException {
        if (this.x == null) {
            throw new IOException("MemoryRandomAccessStorage closed");
        }
        if (l < 0L) {
            throw new IOException("Cannot seek to negative offset");
        }
        if (this.w < l) {
            throw new IOException("Cannot seek beyond limit");
        }
        this.v = l;
    }

    public void setLength(long l, boolean bl) throws IOException {
        if (this.x == null) {
            throw new IOException("MemoryRandomAccessStorage closed");
        }
        if (l < 0L) {
            throw new IllegalArgumentException("Negative length not allowed");
        }
        if (l > this.w) {
            throw new InsufficientCapacityException();
        }
        this.y = l;
        if (this.v > l) {
            this.v = l;
        }
        if (bl) {
            int n = this.x.length - 1;
            while ((long)(n * 8192) >= l) {
                this.x[n] = null;
                --n;
            }
        }
    }

    public void setLength(long l) throws IOException {
        this.setLength(l, true);
    }

    public void write(int n) throws IOException {
        long l = this.v;
        if (l < 0L) {
            throw new IOException("MemoryRandomAccessStorage closed");
        }
        if (l >= this.w) {
            throw new InsufficientCapacityException();
        }
        int n2 = (int)l & 0x1FFF;
        int n3 = (int)(l >>> 13);
        byte[] byArray = this.x[n3];
        if (byArray == null) {
            byArray = new byte[8192];
            this.x[n3] = byArray;
        }
        byArray[n2] = (byte)n;
        this.v = ++l;
        if (this.y < l) {
            this.y = l;
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (n2 <= 0) {
            return;
        }
        long l = this.v;
        if (l < 0L) {
            throw new IOException("MemoryRandomAccessStorage closed");
        }
        if (l + (long)n2 > this.w) {
            throw new InsufficientCapacityException();
        }
        int n3 = (int)l & 0x1FFF;
        int n4 = (int)(l >>> 13);
        int n5 = n2;
        while (true) {
            int n6;
            int n7 = (n6 = 8192 - n3) < n5 ? n6 : n5;
            byte[] byArray2 = this.x[n4];
            if (byArray2 == null) {
                byArray2 = new byte[8192];
                this.x[n4] = byArray2;
            }
            System.arraycopy(byArray, n, byArray2, n3, n7);
            if ((n5 -= n7) == 0) break;
            n += n7;
            if ((n3 += n7) != 8192) continue;
            n3 = 0;
            ++n4;
        }
        this.v = l += (long)n2;
        if (this.y < l) {
            this.y = l;
        }
    }

    public int read() throws IOException {
        long l = this.v;
        if (l < 0L) {
            throw new IOException("MemoryRandomAccessStorage closed");
        }
        if (l >= this.y) {
            return -1;
        }
        int n = (int)l & 0x1FFF;
        int n2 = (int)(l >>> 13);
        this.v = l + 1L;
        byte[] byArray = this.x[n2];
        if (byArray == null) {
            return 0;
        }
        return byArray[n] & 0xFF;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        long l = this.v;
        if (l < 0L) {
            throw new IOException("MemoryRandomAccessStorage closed");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("len cannot be negative");
        }
        if (n2 == 0) {
            return 0;
        }
        long l2 = this.y;
        if (l + (long)n2 > l2) {
            n2 = (int)(l2 - l);
        }
        if (n2 <= 0) {
            return -1;
        }
        int n3 = (int)l & 0x1FFF;
        int n4 = (int)(l >>> 13);
        int n5 = n2;
        while (true) {
            int n6;
            int n7 = (n6 = 8192 - n3) < n5 ? n6 : n5;
            byte[] byArray2 = this.x[n4];
            if (byArray2 == null) {
                Arrays.fill(byArray, n, n + n7, (byte)0);
            } else {
                System.arraycopy(byArray2, n3, byArray, n, n7);
            }
            if ((n5 -= n7) == 0) break;
            n += n7;
            if ((n3 += n7) != 8192) continue;
            n3 = 0;
            ++n4;
        }
        this.v = l + (long)n2;
        return n2;
    }

    public void close() throws IOException {
        this.x = null;
        this.v = -1L;
        this.y = -1L;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        if (this.x == null) {
            throw new IOException("MemoryRandomAccessStorage closed");
        }
        int n = (int)(this.y >> 13);
        int n2 = (int)this.y & 0x1FFF;
        byte[] byArray = null;
        for (int i = 0; i < n; ++i) {
            if (this.x[i] == null) {
                if (byArray == null) {
                    byArray = new byte[8192];
                }
                outputStream.write(byArray, 0, 8192);
                continue;
            }
            outputStream.write(this.x[i], 0, 8192);
        }
        if (n2 > 0) {
            if (this.x[n] == null) {
                outputStream.write(byArray == null ? new byte[n2] : byArray, 0, n2);
            } else {
                outputStream.write(this.x[n], 0, n2);
            }
        }
    }

    public void flush() throws IOException {
    }

    public Object sync() {
        return this;
    }

    public String toString() {
        return "MRAS[p=" + this.v + ",s=" + this.y + ",l=" + this.w + ']';
    }
}

