/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.common.filemanagement;

import java.io.UTFDataFormatException;

public final class UTF8Codec {
    private UTF8Codec() {
    }

    public static int size(String string) {
        int n = 0;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++n;
                continue;
            }
            if (c > '\u07ff') {
                n += 3;
                continue;
            }
            n += 2;
        }
        return n;
    }

    public static int encode(String string, byte[] byArray, int n) {
        int n2 = n;
        int n3 = string.length();
        for (int i = 0; i < n3; ++i) {
            char c = string.charAt(i);
            if ('\u0001' <= c && c <= '\u007f') {
                byArray[n2++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                byArray[n2++] = (byte)(0xE0 | c >> 12 & 0xF);
                byArray[n2++] = (byte)(0x80 | c >> 6 & 0x3F);
                byArray[n2++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            byArray[n2++] = (byte)(0xC0 | c >> 6 & 0x1F);
            byArray[n2++] = (byte)(0x80 | c & 0x3F);
        }
        return n2 - n;
    }

    public static byte[] encode(String string) {
        int n = UTF8Codec.size(string);
        byte[] byArray = new byte[n];
        UTF8Codec.encode(string, byArray, 0);
        return byArray;
    }

    public static int decode(byte[] byArray, int n, int n2, char[] cArray, int n3) throws UTFDataFormatException {
        int n4 = n;
        int n5 = n + n2;
        int n6 = n3;
        block5: while (n4 < n5) {
            int n7 = byArray[n4++] & 0xFF;
            switch (n7 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    cArray[n6++] = (char)n7;
                    continue block5;
                }
                case 12: 
                case 13: {
                    int n8;
                    if (n4 > n5) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    if (((n8 = byArray[n4++] & 0xFF) & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + n4);
                    }
                    cArray[n6++] = (char)((n7 & 0x1F) << 6 | n8 & 0x3F);
                    continue block5;
                }
                case 14: {
                    if (n4 + 1 > n5) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    int n8 = byArray[n4++] & 0xFF;
                    int n9 = byArray[n4++] & 0xFF;
                    if ((n8 & 0xC0) != 128 || (n9 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + n4);
                    }
                    cArray[n6++] = (char)((n7 & 0xF) << 12 | (n8 & 0x3F) << 6 | (n9 & 0x3F) << 0);
                    continue block5;
                }
            }
            throw new UTFDataFormatException("malformed input around byte " + n4);
        }
        return n6 - n3;
    }
}

