/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.common.value;

import com.crystaldecisions.reports.common.archive.ArchiveException;
import com.crystaldecisions.reports.common.archive.IInputArchive;
import com.crystaldecisions.reports.common.archive.IOutputArchive;
import com.crystaldecisions.reports.common.filemanagement.ExtendedDataInput;
import com.crystaldecisions.reports.common.filemanagement.ExtendedDataOutput;
import com.crystaldecisions.reports.common.filemanagement.UTF8Codec;
import com.crystaldecisions.reports.common.value.CrystalValue;
import com.crystaldecisions.reports.common.value.FormulaValue;
import com.crystaldecisions.reports.common.value.ValueType;
import java.io.IOException;
import java.util.Comparator;

public abstract class StringValue
extends FormulaValue {
    public static final StringValue empty = new SimpleStringValue("");

    public static StringValue fromString(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return empty;
        }
        return new SimpleStringValue(string);
    }

    public abstract String getString();

    public int getLength() {
        return this.getString().length();
    }

    public char getCharAt(int n) {
        return this.getString().charAt(n);
    }

    public String getSubstring(int n, int n2) {
        return this.getString().substring(n, n2);
    }

    public final ValueType getValueType() {
        return ValueType.string;
    }

    public FormulaValue coerceToString() {
        return this;
    }

    public boolean equals(Object object, boolean bl) {
        if (bl) {
            return object != null && object.getClass() == this.getClass() && this.getString().toLowerCase().equals(((StringValue)object).getString().toLowerCase());
        }
        return object != null && object.getClass() == this.getClass() && this.getString().equals(((StringValue)object).getString());
    }

    public int compareTo(Object object, Comparator comparator) {
        return comparator.compare(this.getString(), ((StringValue)object).getString());
    }

    public int hashCode(boolean bl) {
        if (bl) {
            return this.getString().toLowerCase().hashCode();
        }
        return this.getString().hashCode();
    }

    public String toString() {
        return "s(" + this.getString() + ')';
    }

    public static StringValue Load(ExtendedDataInput extendedDataInput) throws IOException {
        return StringValue.fromString(extendedDataInput.readString());
    }

    public static StringValue LoadFromArchive(IInputArchive iInputArchive) throws ArchiveException {
        return StringValue.fromString(iInputArchive.loadString());
    }

    public static String getAsString(CrystalValue crystalValue, String string) {
        if (crystalValue == null) {
            return string;
        }
        if (crystalValue instanceof StringValue) {
            return ((StringValue)crystalValue).getString();
        }
        throw new IllegalArgumentException();
    }

    public StringValue truncate() {
        int n;
        int n2;
        String string = this.getString();
        for (n2 = n = string.length(); n2 > 0 && string.charAt(n2 - 1) <= ' '; --n2) {
        }
        return n2 < n ? StringValue.fromString(string.substring(0, n2)) : this;
    }

    private static final class SimpleStringValue
    extends StringValue {
        private final String l;

        private SimpleStringValue(String string) {
            if (string == null) {
                throw new NullPointerException("The string cannot be null.");
            }
            this.l = string;
        }

        public int getEncodedSizeForArchive(ValueType valueType) {
            assert (valueType.isMemo() || valueType == ValueType.string);
            int n = UTF8Codec.size(this.l);
            if (n == 0) {
                return 4;
            }
            return 4 + n + 1;
        }

        public int getEncodedSize(ValueType valueType) {
            assert (valueType.isMemo() || valueType == ValueType.string);
            return 4 + this.l.length() * 2;
        }

        public void store(ValueType valueType, ExtendedDataOutput extendedDataOutput) throws IOException {
            assert (valueType.isMemo() || valueType == ValueType.string);
            extendedDataOutput.writeString(this.l);
        }

        public void storeToArchive(ValueType valueType, IOutputArchive iOutputArchive) throws ArchiveException {
            assert (valueType.isMemo() || valueType == ValueType.string);
            iOutputArchive.storeString(this.l);
        }

        public String getString() {
            return this.l;
        }
    }
}

