/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.db;

import org.hibernate.classic.Session;
import org.jbpm.api.ProcessEngine;
import org.jbpm.api.cmd.Command;
import org.jbpm.api.cmd.Environment;
import org.jbpm.db.DbHelper;
import org.jbpm.db.Upgrade;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.cfg.ConfigurationImpl;
import org.jbpm.pvm.internal.id.PropertyImpl;

public class Create {
    private static final long serialVersionUID = 1L;
    private static final Log log = Log.getLog((String)Create.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length != 1) {
            DbHelper.printSyntax(Upgrade.class);
            return;
        }
        final String database = args[0];
        ProcessEngine processEngine = new ConfigurationImpl().skipDbCheck().buildProcessEngine();
        try {
            processEngine.execute((Command)new Command<Void>(){
                private static final long serialVersionUID = 1L;

                public Void execute(Environment environment) throws Exception {
                    Session session = (Session)environment.get(Session.class);
                    DbHelper.executeSqlResource("create/jbpm." + database + ".create.sql", (org.hibernate.Session)session);
                    PropertyImpl.createProperties((org.hibernate.Session)session);
                    return null;
                }
            });
            log.info("database schema created successfully");
        }
        catch (Exception e) {
            log.error("database schema creation failed", (Throwable)e);
        }
        finally {
            processEngine.close();
        }
    }
}

