/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.db;

import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.jbpm.api.JbpmException;
import org.jbpm.api.ProcessEngine;
import org.jbpm.api.cmd.Command;
import org.jbpm.api.cmd.Environment;
import org.jbpm.api.cmd.VoidCommand;
import org.jbpm.db.DbHelper;
import org.jbpm.db.JbpmVersion;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.cfg.ConfigurationImpl;
import org.jbpm.pvm.internal.id.PropertyImpl;
import org.jbpm.pvm.internal.repository.DeploymentImpl;
import org.jbpm.pvm.internal.repository.DeploymentProperty;
import org.jbpm.pvm.internal.util.CollectionUtil;

public class Upgrade {
    private static final long serialVersionUID = 1L;
    static final Log log = Log.getLog((String)Upgrade.class.getName());

    private Upgrade() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length != 1) {
            DbHelper.printSyntax(Upgrade.class);
            return;
        }
        String database = args[0];
        ProcessEngine processEngine = new ConfigurationImpl().skipDbCheck().buildProcessEngine();
        try {
            boolean propertiesTableExists = (Boolean)processEngine.execute((Command)PropertiesTableExists.INSTANCE);
            JbpmVersion databaseVersion = (JbpmVersion)((Object)processEngine.execute((Command)new FindDatabaseVersion(propertiesTableExists)));
            JbpmVersion libraryVersion = JbpmVersion.getJbpmVersion("4.4-SNAPSHOT");
            if (databaseVersion == libraryVersion) {
                log.info("database schema is already up to date");
            } else {
                processEngine.execute((Command)new RunUpgradeScripts(database, databaseVersion, propertiesTableExists));
                processEngine.execute((Command)new UpdateDatabaseVersion(databaseVersion));
            }
            log.info("database schema upgraded successfully");
        }
        catch (Exception e) {
            log.error("database schema upgrade failed", (Throwable)e);
        }
        finally {
            processEngine.close();
        }
    }

    private static final class UpdateDatabaseVersion
    extends VoidCommand {
        private final JbpmVersion databaseVersion;
        private static final long serialVersionUID = 1L;

        UpdateDatabaseVersion(JbpmVersion databaseVersion) {
            this.databaseVersion = databaseVersion;
        }

        protected void executeVoid(Environment environment) throws Exception {
            Session session = (Session)environment.get(Session.class);
            if (this.databaseVersion.compareTo(JbpmVersion.V_4_2) < 0) {
                List deploymentProperties = session.createCriteria(DeploymentProperty.class).add((Criterion)Restrictions.eq((String)"key", (Object)"pdid")).list();
                for (DeploymentProperty deploymentProperty : CollectionUtil.checkList((List)deploymentProperties, DeploymentProperty.class)) {
                    DeploymentImpl deployment = deploymentProperty.getDeployment();
                    deployment.setProcessLanguageId(deploymentProperty.getObjectName(), "jpdl-4.0");
                }
            }
            PropertyImpl.setDbVersionToLibraryVersion((Session)session);
        }
    }

    private static class RunUpgradeScripts
    extends VoidCommand {
        private final JbpmVersion databaseVersion;
        private final String database;
        private final boolean propertiesTableExists;
        private static final long serialVersionUID = 1L;

        RunUpgradeScripts(String database, JbpmVersion databaseVersion, boolean propertiesTableExists) {
            this.database = database;
            this.databaseVersion = databaseVersion;
            this.propertiesTableExists = propertiesTableExists;
        }

        protected void executeVoid(Environment environment) throws Exception {
            Session session = (Session)environment.get(Session.class);
            log.info("upgrading from " + (Object)((Object)this.databaseVersion) + " to " + "4.4-SNAPSHOT");
            if (this.databaseVersion.compareTo(JbpmVersion.V_4_1) < 0) {
                DbHelper.executeSqlResource("upgrade-4.0-to-4.1/jbpm." + this.database + ".upgrade.sql", session);
            }
            if (this.databaseVersion.compareTo(JbpmVersion.V_4_2) < 0 && !this.propertiesTableExists) {
                DbHelper.executeSqlResource("upgrade-4.1-to-4.2/jbpm." + this.database + ".upgrade.sql", session);
                PropertyImpl.initializeNextDbid((Session)session);
                PropertyImpl.setDbVersionTo41((Session)session);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FindDatabaseVersion
    implements Command<JbpmVersion> {
        private final boolean propertiesTableExists;
        private static final long serialVersionUID = 1L;

        FindDatabaseVersion(boolean propertiesTableExists) {
            this.propertiesTableExists = propertiesTableExists;
        }

        public JbpmVersion execute(Environment environment) throws Exception {
            Session session = (Session)environment.get(Session.class);
            if (!this.propertiesTableExists) {
                try {
                    session.createSQLQuery("select CLASSNAME_ from JBPM4_VARIABLE").list();
                    return JbpmVersion.V_4_1;
                }
                catch (HibernateException e) {
                    return JbpmVersion.V_4_0;
                }
            }
            String dbVersion = PropertyImpl.getDbVersion((Session)session);
            if (dbVersion == null) {
                throw new JbpmException("property table exists, but no db version property is present");
            }
            return JbpmVersion.getJbpmVersion(dbVersion);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PropertiesTableExists
    implements Command<Boolean> {
        private static final long serialVersionUID = 1L;
        static final PropertiesTableExists INSTANCE = new PropertiesTableExists();

        private PropertiesTableExists() {
        }

        public Boolean execute(Environment environment) throws Exception {
            Session session = (Session)environment.get(Session.class);
            return PropertyImpl.propertiesTableExists((Session)session);
        }
    }
}

