/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn.flownodes;

import java.util.ArrayList;
import java.util.List;
import org.jbpm.bpmn.flownodes.BpmnBinding;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.util.XmlUtil;
import org.jbpm.pvm.internal.wire.binding.ObjectBinding;
import org.jbpm.pvm.internal.wire.xml.WireParser;
import org.jbpm.pvm.internal.xml.Parse;
import org.w3c.dom.Element;

public abstract class AbstractGatewayBinding
extends BpmnBinding {
    protected static final Log log = Log.getLog(AbstractGatewayBinding.class.getName());
    protected int incoming;
    protected List<Element> inSequenceFlows;
    protected int outgoing;
    protected List<Element> outSequenceFlows;
    protected String id;
    protected String name;
    protected String gatewayDirection;
    protected boolean valid = true;
    static ObjectBinding objectBinding = new ObjectBinding();
    static WireParser wireParser = WireParser.getInstance();

    public AbstractGatewayBinding(String tagName) {
        super(tagName);
    }

    public void parse(Element element, Parse parse) {
        this.resetMemberFields();
        this.id = element.getAttribute("id");
        this.name = element.getAttribute("name");
        this.gatewayDirection = element.hasAttribute("gatewayDirection") ? element.getAttribute("gatewayDirection") : "unspecified";
        List<Element> allSequenceFlow = XmlUtil.elements((Element)element.getParentNode(), "sequenceFlow");
        for (Element sequenceFlowElement : allSequenceFlow) {
            String sourceRef = sequenceFlowElement.getAttribute("sourceRef");
            if (this.id.equals(sourceRef)) {
                ++this.outgoing;
                this.outSequenceFlows.add(sequenceFlowElement);
                continue;
            }
            if (!sequenceFlowElement.getAttribute("targetRef").equals(this.id)) continue;
            ++this.incoming;
            this.inSequenceFlows.add(sequenceFlowElement);
        }
        this.valid = this.validGatewayDirection(parse, this.name, element);
    }

    private void resetMemberFields() {
        this.incoming = 0;
        this.inSequenceFlows = new ArrayList<Element>();
        this.outgoing = 0;
        this.outSequenceFlows = new ArrayList<Element>();
        this.valid = true;
    }

    protected boolean validGatewayDirection(Parse parse, String elementName, Element element) {
        boolean valid;
        if (log.isDebugEnabled()) {
            log.debug("Defined gatewayDirection: " + this.gatewayDirection + ". Nr of incomming: " + this.incoming + ", nr of outgoing: " + this.outgoing);
        }
        boolean bl = valid = (!"converging".equals(this.gatewayDirection) || this.incoming > 1 && this.outgoing == 1) && (!"diverging".equals(this.gatewayDirection) || this.incoming == 1 && this.outgoing > 1) && (!"mixed".equals(this.gatewayDirection) || this.incoming > 1 && this.outgoing > 1);
        if (!valid) {
            parse.addProblem(this.tagName + " '" + elementName + "' has the wrong number of incomming (" + this.incoming + ") and outgoing (" + this.outgoing + ") transitions for gatewayDirection='" + this.gatewayDirection + "'", element);
        }
        return valid;
    }

    protected void validateConditionOnAllSequenceFlow(Parse parse, Element element) {
        boolean defaultExists = false;
        for (Element outSeqFlow : this.outSequenceFlows) {
            String sourceRef = outSeqFlow.getAttribute("sourceRef");
            Element conditionalExpression = XmlUtil.element(outSeqFlow, "conditionExpression");
            if (!this.id.equals(sourceRef)) continue;
            if (outSeqFlow.getAttribute("id").equals(this.default_)) {
                defaultExists = true;
                continue;
            }
            if (this.default_ == null || conditionalExpression != null) continue;
            parse.addProblem("exclusiveGateway '" + this.name + "' has default sequenceFlow '" + this.default_ + "' but " + outSeqFlow.getAttribute("id") + " does not have a required conditionExpression", element);
            this.valid = false;
        }
        if (this.default_ != null && !defaultExists) {
            parse.addProblem("exclusiveGateway '" + this.name + "' default sequenceFlow '" + this.default_ + "' does not exist or is not related to this node", element);
            this.valid = false;
        }
    }
}

