/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn.flownodes;

import java.util.HashSet;
import java.util.Set;
import org.jbpm.api.activity.ActivityBehaviour;
import org.jbpm.api.model.Activity;
import org.jbpm.api.model.Transition;
import org.jbpm.bpmn.flownodes.BpmnBinding;
import org.jbpm.bpmn.flownodes.BpmnEvent;
import org.jbpm.bpmn.flownodes.NoneStartEventActivity;
import org.jbpm.bpmn.flownodes.SubProcessActivity;
import org.jbpm.bpmn.model.BpmnProcessDefinition;
import org.jbpm.bpmn.parser.BpmnParser;
import org.jbpm.pvm.internal.model.ActivityImpl;
import org.jbpm.pvm.internal.xml.Parse;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubProcessBinding
extends BpmnBinding {
    protected static final String TAG_NAME = "subProcess";

    public SubProcessBinding() {
        super(TAG_NAME);
    }

    @Override
    public Object parse(Element element, Parse parse, BpmnParser bpmnParser) {
        SubProcessActivity subProcessActivity = new SubProcessActivity();
        ActivityImpl activity = parse.contextStackFind(ActivityImpl.class);
        bpmnParser.parseActivities(element, parse, activity);
        bpmnParser.parseSequenceFlow(element, parse, parse.contextStackFind(BpmnProcessDefinition.class));
        this.validateStartActivities(activity, parse);
        this.validateAllSequenceFlow(activity, parse);
        subProcessActivity.setDefault(this.getDefault());
        return subProcessActivity;
    }

    protected void validateStartActivities(ActivityImpl subProcessActivity, Parse parse) {
        for (Activity activity : subProcessActivity.getActivities()) {
            ActivityBehaviour activityBehaviour;
            if (!activity.getIncomingTransitions().isEmpty() || !((activityBehaviour = ((ActivityImpl)activity).getActivityBehaviour()) instanceof BpmnEvent) || activityBehaviour instanceof NoneStartEventActivity) continue;
            parse.addProblem("Only none start events are allowed in an embedded sub process. Event " + activity.getName() + " has no incoming sequence flow.");
        }
    }

    protected void validateAllSequenceFlow(ActivityImpl subProcessActivity, Parse parse) {
        HashSet<String> childActivityIds = new HashSet<String>();
        for (Activity activity : subProcessActivity.getActivities()) {
            childActivityIds.add(activity.getName());
        }
        for (Activity activity : subProcessActivity.getActivities()) {
            for (Transition transition : activity.getIncomingTransitions()) {
                this.validateSequenceFlow(transition, childActivityIds, parse);
            }
            for (Transition transition : subProcessActivity.getOutgoingTransitions()) {
                this.validateSequenceFlow(transition, childActivityIds, parse);
            }
        }
    }

    protected void validateSequenceFlow(Transition transition, Set<String> subProcessActivityIds, Parse parse) {
        if (!subProcessActivityIds.contains(transition.getSource().getName())) {
            parse.addProblem("Invalid sequence flow " + transition.getName() + ": cannot cross sub-process boundaries from " + transition.getSource().getName() + " into the sub process activity.");
        }
        if (!subProcessActivityIds.contains(transition.getDestination().getName())) {
            parse.addProblem("Invalid sequence flow " + transition.getName() + ": cannot cross sub-process boundaries to " + transition.getSource().getName() + " from within the sub process activity.");
        }
    }
}

