/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.enterprise.internal.ejb;

import java.util.Hashtable;
import javax.naming.InitialContext;
import org.jbpm.api.JbpmException;
import org.jbpm.api.cmd.Command;
import org.jbpm.enterprise.internal.ejb.RemoteCommandExecutor;
import org.jbpm.enterprise.internal.ejb.RemoteCommandExecutorHome;
import org.jbpm.pvm.internal.cmd.CommandService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbRemoteCommandService
implements CommandService {
    protected String initialContextFactory;
    protected String providerUrl;
    protected String urlPkgPrefixes;
    protected String jndiName;

    public EjbRemoteCommandService(String initialContextFactory, String providerUrl, String urlPkgPrefixes, String jndiName) {
        this.initialContextFactory = initialContextFactory;
        this.providerUrl = providerUrl;
        this.urlPkgPrefixes = urlPkgPrefixes;
        this.jndiName = jndiName;
    }

    @Override
    public <T> T execute(Command<T> command) {
        try {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", this.initialContextFactory);
            env.put("java.naming.provider.url", this.providerUrl);
            env.put("java.naming.factory.url.pkgs", this.urlPkgPrefixes);
            InitialContext initialContext = new InitialContext(env);
            RemoteCommandExecutorHome remoteCommandExecutorHome = (RemoteCommandExecutorHome)initialContext.lookup(this.jndiName);
            RemoteCommandExecutor remoteCommandExecutor = remoteCommandExecutorHome.create();
            T result = remoteCommandExecutor.execute(command);
            remoteCommandExecutor.remove();
            return result;
        }
        catch (Exception e) {
            throw new JbpmException("couldn't execute remote command: " + e.getMessage(), e);
        }
    }
}

