/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.enterprise.internal.ejb;

import java.util.List;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import org.jbpm.api.Execution;
import org.jbpm.api.JbpmException;
import org.jbpm.api.job.Timer;
import org.jbpm.enterprise.internal.ejb.LocalTimer;
import org.jbpm.enterprise.internal.ejb.LocalTimerHome;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.env.EnvironmentImpl;
import org.jbpm.pvm.internal.job.TimerImpl;
import org.jbpm.pvm.internal.session.DbSession;
import org.jbpm.pvm.internal.session.TimerSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbTimerSession
implements TimerSession {
    private LocalTimerHome timerHome;
    private static final Log log = Log.getLog(EjbTimerSession.class.getName());

    @Override
    public void schedule(Timer timer) {
        log.debug("scheduling " + timer);
        DbSession dbSession = EnvironmentImpl.getCurrent().get(DbSession.class);
        dbSession.save(timer);
        dbSession.flush();
        try {
            LocalTimer timerBean = this.timerHome.findByPrimaryKey(((TimerImpl)timer).getDbid());
            timerBean.schedule();
        }
        catch (FinderException e) {
            throw new JbpmException("could not find bean for timer: " + timer);
        }
    }

    @Override
    public void cancel(Timer timer) {
        try {
            LocalTimer timerBean = this.timerHome.findByPrimaryKey(((TimerImpl)timer).getDbid());
            log.debug("canceling " + timer);
            timerBean.remove();
        }
        catch (FinderException e) {
            log.error("could not find bean for timer " + timer, e);
        }
        catch (RemoveException e) {
            log.error("could not remove bean for timer " + timer, e);
        }
    }

    @Override
    public List<Timer> findTimersByExecution(Execution execution) {
        return null;
    }
}

