/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jpdl.internal.xml;

import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.jbpm.api.JbpmException;
import org.jbpm.api.activity.ActivityBehaviour;
import org.jbpm.api.listener.EventListener;
import org.jbpm.internal.log.Log;
import org.jbpm.jpdl.internal.activity.JpdlBinding;
import org.jbpm.jpdl.internal.activity.MailListener;
import org.jbpm.jpdl.internal.model.JpdlProcessDefinition;
import org.jbpm.jpdl.internal.xml.JpdlBindingsParser;
import org.jbpm.jpdl.internal.xml.MigrationHelper;
import org.jbpm.jpdl.internal.xml.UnresolvedTransition;
import org.jbpm.jpdl.internal.xml.UnresolvedTransitions;
import org.jbpm.pvm.internal.el.Expression;
import org.jbpm.pvm.internal.email.impl.MailProducerImpl;
import org.jbpm.pvm.internal.email.impl.MailTemplate;
import org.jbpm.pvm.internal.email.impl.MailTemplateRegistry;
import org.jbpm.pvm.internal.env.EnvironmentImpl;
import org.jbpm.pvm.internal.model.ActivityCoordinatesImpl;
import org.jbpm.pvm.internal.model.ActivityImpl;
import org.jbpm.pvm.internal.model.CompositeElementImpl;
import org.jbpm.pvm.internal.model.Continuation;
import org.jbpm.pvm.internal.model.EventImpl;
import org.jbpm.pvm.internal.model.EventListenerReference;
import org.jbpm.pvm.internal.model.ObservableElementImpl;
import org.jbpm.pvm.internal.model.ProcessDefinitionImpl;
import org.jbpm.pvm.internal.model.ScopeElementImpl;
import org.jbpm.pvm.internal.model.TimerDefinitionImpl;
import org.jbpm.pvm.internal.model.TransitionImpl;
import org.jbpm.pvm.internal.model.VariableDefinitionImpl;
import org.jbpm.pvm.internal.repository.DeploymentImpl;
import org.jbpm.pvm.internal.task.AssignableDefinitionImpl;
import org.jbpm.pvm.internal.task.SwimlaneDefinitionImpl;
import org.jbpm.pvm.internal.task.TaskDefinitionImpl;
import org.jbpm.pvm.internal.util.XmlUtil;
import org.jbpm.pvm.internal.wire.Descriptor;
import org.jbpm.pvm.internal.wire.binding.MailTemplateBinding;
import org.jbpm.pvm.internal.wire.binding.ObjectBinding;
import org.jbpm.pvm.internal.wire.descriptor.ObjectDescriptor;
import org.jbpm.pvm.internal.wire.descriptor.ProvidedObjectDescriptor;
import org.jbpm.pvm.internal.wire.usercode.UserCodeReference;
import org.jbpm.pvm.internal.wire.xml.WireParser;
import org.jbpm.pvm.internal.xml.Bindings;
import org.jbpm.pvm.internal.xml.Parse;
import org.jbpm.pvm.internal.xml.Parser;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpdlParser
extends Parser {
    private static final Log log = Log.getLog(JpdlParser.class.getName());
    public static final String NAMESPACE_JPDL_40 = "http://jbpm.org/4.0/jpdl";
    public static final String NAMESPACE_JPDL_42 = "http://jbpm.org/4.2/jpdl";
    public static final String NAMESPACE_JPDL_43 = "http://jbpm.org/4.3/jpdl";
    public static final String NAMESPACE_JPDL_44 = "http://jbpm.org/4.4/jpdl";
    public static final String CURRENT_VERSION_JBPM = "4.4";
    public static final String CURRENT_VERSION_NAMESPACE = "http://jbpm.org/4.4/jpdl";
    public static final String CURRENT_VERSION_PROCESS_LANGUAGE_ID = "jpdl-4.4";
    private static final String[] SCHEMA_RESOURCES = new String[]{"jpdl-4.0.xsd", "jpdl-4.2.xsd", "jpdl-4.3.xsd", "jpdl-4.4.xsd"};
    private static final String[] DEFAULT_BINDING_RESOURCES = new String[]{"jbpm.jpdl.bindings.xml", "jbpm.user.bindings.xml"};
    private static JpdlBindingsParser jpdlBindingsParser = new JpdlBindingsParser();
    public static final String CATEGORY_ACTIVITY = "activity";
    public static final String CATEGORY_EVENT_LISTENER = "eventlistener";

    public JpdlParser() {
        this.parseBindings();
        this.setSchemaResources(SCHEMA_RESOURCES);
    }

    protected void parseBindings() {
        this.bindings = new Bindings();
        for (String activityResource : DEFAULT_BINDING_RESOURCES) {
            Enumeration<URL> resourceUrls = this.getResources(activityResource);
            if (resourceUrls.hasMoreElements()) {
                while (resourceUrls.hasMoreElements()) {
                    URL resourceUrl = resourceUrls.nextElement();
                    log.trace("loading jpdl bindings from resource: " + resourceUrl);
                    jpdlBindingsParser.createParse().setUrl(resourceUrl).contextMapPut("bindings", this.bindings).execute().checkErrors("jpdl bindings from " + resourceUrl.toString());
                }
                continue;
            }
            log.trace("skipping unavailable jpdl activities resource: " + activityResource);
        }
    }

    protected Enumeration<URL> getResources(String resourceName) {
        Enumeration<URL> resourceUrls;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            resourceUrls = classLoader.getResources(resourceName);
            if (!resourceUrls.hasMoreElements()) {
                resourceUrls = JpdlParser.class.getClassLoader().getResources(resourceName);
            }
        }
        catch (Exception e) {
            throw new JbpmException("couldn't get resource urls for " + resourceName, e);
        }
        return resourceUrls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object parseDocumentElement(Element documentElement, Parse parse) {
        JpdlProcessDefinition processDefinition = this.instantiateNewJpdlProcessDefinition();
        parse.contextStackPush(processDefinition);
        ArrayList<JpdlProcessDefinition> processDefinitions = new ArrayList<JpdlProcessDefinition>();
        processDefinitions.add(processDefinition);
        try {
            Element descriptionElement;
            String key;
            String name = XmlUtil.attribute(documentElement, "name", parse);
            processDefinition.setName(name);
            DeploymentImpl deployment = (DeploymentImpl)parse.contextMapGet("deployment");
            if (deployment != null) {
                String processLanguageId = deployment.getProcessLanguageId(name);
                if (processLanguageId == null) {
                    String namespaceUri;
                    String jpdlParser = XmlUtil.attribute(documentElement, "jpdlparser");
                    processLanguageId = jpdlParser != null ? "jpdl-" + jpdlParser : ((jpdlParser = System.getProperty("jpdlparser")) != null ? "jpdl-" + jpdlParser : ((namespaceUri = documentElement.getNamespaceURI()) != null ? "jpdl-" + namespaceUri.substring(16, 19) : CURRENT_VERSION_PROCESS_LANGUAGE_ID));
                    deployment.setProcessLanguageId(name, processLanguageId);
                }
                parse.contextMapPut("proclangid", processLanguageId);
            }
            String packageName = XmlUtil.attribute(documentElement, "package");
            processDefinition.setPackageName(packageName);
            Integer version = XmlUtil.attributeInteger(documentElement, "version", parse);
            if (version != null) {
                processDefinition.setVersion(version);
            }
            if ((key = XmlUtil.attribute(documentElement, "key")) != null) {
                processDefinition.setKey(key);
            }
            if ((descriptionElement = XmlUtil.element(documentElement, "description")) != null) {
                String description = XmlUtil.getContentText(descriptionElement);
                processDefinition.setDescription(description);
            }
            UnresolvedTransitions unresolvedTransitions = new UnresolvedTransitions();
            parse.contextStackPush(unresolvedTransitions);
            List<Element> swimlaneElements = XmlUtil.elements(documentElement, "swimlane");
            for (Element swimlaneElement : swimlaneElements) {
                String swimlaneName = XmlUtil.attribute(swimlaneElement, "name", parse);
                if (swimlaneName == null) continue;
                SwimlaneDefinitionImpl swimlaneDefinition = processDefinition.createSwimlaneDefinition(swimlaneName);
                this.parseAssignmentAttributes(swimlaneElement, swimlaneDefinition, parse);
            }
            this.parseVariableDefinitions(documentElement, parse, processDefinition);
            this.parseOnEvents(documentElement, parse, processDefinition);
            this.parseActivities(documentElement, parse, processDefinition);
            this.resolveTransitionDestinations(parse, processDefinition, unresolvedTransitions);
            Element migrationElement = XmlUtil.element(documentElement, "migrate-instances");
            if (migrationElement != null) {
                MigrationHelper.parseMigrationDescriptor(migrationElement, parse, processDefinition);
            }
        }
        finally {
            parse.contextStackPop();
        }
        if (processDefinition.getInitial() == null) {
            parse.addProblem("no start activity in process", documentElement);
        }
        return processDefinitions;
    }

    protected JpdlProcessDefinition instantiateNewJpdlProcessDefinition() {
        return new JpdlProcessDefinition();
    }

    protected void resolveTransitionDestinations(Parse parse, JpdlProcessDefinition processDefinition, UnresolvedTransitions unresolvedTransitions) {
        for (UnresolvedTransition unresolvedTransition : unresolvedTransitions.list) {
            unresolvedTransition.resolve(processDefinition, parse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseActivities(Element documentElement, Parse parse, CompositeElementImpl compositeElement) {
        List<Element> elements = XmlUtil.elements(documentElement);
        for (Element nestedElement : elements) {
            String tagName = nestedElement.getLocalName();
            if ("on".equals(tagName) || "timer".equals(tagName) || "swimlane".equals(tagName) || "migrate-instances".equals(tagName) || "description".equals(tagName)) continue;
            JpdlBinding activityBinding = (JpdlBinding)this.getBinding(nestedElement, CATEGORY_ACTIVITY);
            if (activityBinding == null) {
                log.debug("unrecognized activity: " + tagName);
                continue;
            }
            ActivityImpl activity = compositeElement.createActivity();
            parse.contextStackPush(activity);
            try {
                Object parseResult;
                String continuationText;
                activity.setType(activityBinding.getTagName());
                activityBinding.parseName(nestedElement, activity, parse);
                this.parseTransitions(nestedElement, activity, parse);
                this.parseVariableDefinitions(nestedElement, parse, activity);
                Element descriptionElement = XmlUtil.element(nestedElement, "description");
                if (descriptionElement != null) {
                    String description = XmlUtil.getContentText(descriptionElement);
                    activity.setDescription(description);
                }
                if ((continuationText = XmlUtil.attribute(nestedElement, "continue")) != null) {
                    if ("async".equals(continuationText)) {
                        activity.setContinuation(Continuation.ASYNCHRONOUS);
                    } else if ("exclusive".equals(continuationText)) {
                        activity.setContinuation(Continuation.EXCLUSIVE);
                    }
                }
                if ((parseResult = activityBinding.parse(nestedElement, parse, this)) instanceof ActivityBehaviour) {
                    ActivityBehaviour activityBehaviour = (ActivityBehaviour)parseResult;
                    activity.setActivityBehaviour(activityBehaviour);
                } else {
                    Descriptor activityBehaviourDescriptor = (Descriptor)parseResult;
                    activity.setActivityBehaviourDescriptor(activityBehaviourDescriptor);
                }
                this.parseOnEvents(nestedElement, parse, activity);
                String g = XmlUtil.attribute(nestedElement, "g");
                if (g == null) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(g, ",");
                ActivityCoordinatesImpl coordinates = null;
                if (stringTokenizer.countTokens() == 4) {
                    try {
                        int x = Integer.parseInt(stringTokenizer.nextToken());
                        int y = Integer.parseInt(stringTokenizer.nextToken());
                        int width = Integer.parseInt(stringTokenizer.nextToken());
                        int height = Integer.parseInt(stringTokenizer.nextToken());
                        coordinates = new ActivityCoordinatesImpl(x, y, width, height);
                    }
                    catch (NumberFormatException e) {
                        coordinates = null;
                    }
                }
                if (coordinates != null) {
                    activity.setCoordinates(coordinates);
                    continue;
                }
                parse.addProblem("invalid coordinates g=\"" + g + "\" in " + activity, nestedElement);
            }
            finally {
                parse.contextStackPop();
            }
        }
    }

    public TimerDefinitionImpl parseTimerDefinition(Element timerElement, Parse parse, ScopeElementImpl scopeElement) {
        TimerDefinitionImpl timerDefinition = scopeElement.createTimerDefinition();
        String duedate = XmlUtil.attribute(timerElement, "duedate");
        String duedatetime = XmlUtil.attribute(timerElement, "duedatetime");
        if (duedate != null) {
            timerDefinition.setDueDateDescription(duedate);
        } else if (duedatetime != null) {
            String dueDateTimeFormatText = (String)EnvironmentImpl.getFromCurrent("jbpm.duedatetime.format", false);
            if (dueDateTimeFormatText == null) {
                dueDateTimeFormatText = "HH:mm dd/MM/yyyy";
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat(dueDateTimeFormatText);
            try {
                Date duedatetimeDate = dateFormat.parse(duedatetime);
                timerDefinition.setDueDate(duedatetimeDate);
            }
            catch (ParseException e) {
                parse.addProblem("couldn't parse duedatetime " + duedatetime, e);
            }
        } else {
            parse.addProblem("either duedate or duedatetime is required in timer", timerElement);
        }
        String repeat = XmlUtil.attribute(timerElement, "repeat");
        timerDefinition.setRepeat(repeat);
        return timerDefinition;
    }

    public void parseOnEvents(Element element, Parse parse, ScopeElementImpl scopeElement) {
        List<Element> onElements = XmlUtil.elements(element, "on");
        for (Element onElement : onElements) {
            String eventName = XmlUtil.attribute(onElement, "event", parse);
            this.parseOnEvent(onElement, parse, scopeElement, eventName);
            Element timerElement = XmlUtil.element(onElement, "timer");
            if (timerElement == null) continue;
            TimerDefinitionImpl timerDefinitionImpl = this.parseTimerDefinition(timerElement, parse, scopeElement);
            timerDefinitionImpl.setEventName(eventName);
        }
    }

    public void parseOnEvent(Element element, Parse parse, ObservableElementImpl observableElement, String eventName) {
        if (eventName != null) {
            String continuationText;
            EventImpl event = observableElement.getEvent(eventName);
            if (event == null) {
                event = observableElement.createEvent(eventName);
            }
            if ((continuationText = XmlUtil.attribute(element, "continue")) != null) {
                if ("async".equals(continuationText)) {
                    event.setContinuation(Continuation.ASYNCHRONOUS);
                } else if ("exclusive".equals(continuationText)) {
                    event.setContinuation(Continuation.EXCLUSIVE);
                }
            }
            for (Element eventListenerElement : XmlUtil.elements(element)) {
                JpdlBinding eventBinding = (JpdlBinding)this.getBinding(eventListenerElement, CATEGORY_EVENT_LISTENER);
                if (eventBinding != null) {
                    TransitionImpl transition;
                    EventListenerReference eventListenerReference = null;
                    Object parseResult = eventBinding.parse(eventListenerElement, parse, this);
                    if (parseResult instanceof EventListener) {
                        EventListener eventListener = (EventListener)parseResult;
                        eventListenerReference = event.createEventListenerReference(eventListener);
                    } else {
                        Descriptor eventListenerDescriptor = (Descriptor)parseResult;
                        eventListenerReference = event.createEventListenerReference(eventListenerDescriptor);
                    }
                    Boolean propagationEnabled = XmlUtil.attributeBoolean(eventListenerElement, "propagation", parse);
                    if (propagationEnabled != null) {
                        eventListenerReference.setPropagationEnabled(propagationEnabled);
                    }
                    if ((continuationText = XmlUtil.attribute(eventListenerElement, "continue")) == null) continue;
                    if (observableElement instanceof ActivityImpl) {
                        if (observableElement.getName() == null) {
                            parse.addProblem("async continuation on event listener requires activity name", eventListenerElement);
                        }
                    } else if (observableElement instanceof TransitionImpl && (transition = (TransitionImpl)observableElement).getSource().getName() == null) {
                        parse.addProblem("async continuation on event listener requires name in the transition source activity", eventListenerElement);
                    }
                    if ("async".equals(continuationText)) {
                        eventListenerReference.setContinuation(Continuation.ASYNCHRONOUS);
                        continue;
                    }
                    if (!"exclusive".equals(continuationText)) continue;
                    eventListenerReference.setContinuation(Continuation.EXCLUSIVE);
                    continue;
                }
                String tagName = eventListenerElement.getLocalName();
                if (observableElement instanceof TransitionImpl && ("condition".equals(tagName) || "timer".equals(tagName))) continue;
                parse.addProblem("unrecognized event listener: " + tagName, null, "warning", eventListenerElement);
            }
        }
    }

    public void parseTransitions(Element element, ActivityImpl activity, Parse parse) {
        UnresolvedTransitions unresolvedTransitions = parse.contextStackFind(UnresolvedTransitions.class);
        List<Element> transitionElements = XmlUtil.elements(element, "transition");
        for (Element transitionElement : transitionElements) {
            String transitionName = XmlUtil.attribute(transitionElement, "name");
            Element timerElement = XmlUtil.element(transitionElement, "timer");
            if (timerElement != null) {
                TimerDefinitionImpl timerDefinitionImpl = this.parseTimerDefinition(timerElement, parse, activity);
                timerDefinitionImpl.setSignalName(transitionName);
            }
            TransitionImpl transition = activity.createOutgoingTransition();
            transition.setName(transitionName);
            unresolvedTransitions.add(transition, transitionElement);
            this.parseOnEvent(transitionElement, parse, transition, "take");
        }
    }

    public void parseAssignmentAttributes(Element element, AssignableDefinitionImpl assignableDefinition, Parse parse) {
        String candidateGroupsExpressionText;
        String candidateUsersExpressionText;
        String assigneeExpressionText;
        Element assignmentHandlerElement;
        Element descriptionElement = XmlUtil.element(element, "description");
        if (descriptionElement != null) {
            String descriptionText = XmlUtil.getContentText(descriptionElement);
            Expression descriptionExpression = Expression.create(descriptionText, "uel-value");
            assignableDefinition.setDescription(descriptionExpression);
        }
        if ((assignmentHandlerElement = XmlUtil.element(element, "assignment-handler")) != null) {
            UserCodeReference assignmentHandlerReference = this.parseUserCodeReference(assignmentHandlerElement, parse);
            assignableDefinition.setAssignmentHandlerReference(assignmentHandlerReference);
        }
        if ((assigneeExpressionText = XmlUtil.attribute(element, "assignee")) != null) {
            String assigneeExpressionLanguage = XmlUtil.attribute(element, "assignee-lang");
            Expression assigneeExpression = Expression.create(assigneeExpressionText, assigneeExpressionLanguage);
            assignableDefinition.setAssigneeExpression(assigneeExpression);
        }
        if ((candidateUsersExpressionText = XmlUtil.attribute(element, "candidate-users")) != null) {
            String candidateUsersExpressionLanguage = XmlUtil.attribute(element, "candidate-users-lang");
            Expression candidateUsersExpression = Expression.create(candidateUsersExpressionText, candidateUsersExpressionLanguage);
            assignableDefinition.setCandidateUsersExpression(candidateUsersExpression);
        }
        if ((candidateGroupsExpressionText = XmlUtil.attribute(element, "candidate-groups")) != null) {
            String candidateGroupsExpressionLanguage = XmlUtil.attribute(element, "candidate-groups-lang");
            Expression candidateGroupsExpression = Expression.create(candidateGroupsExpressionText, candidateGroupsExpressionLanguage);
            assignableDefinition.setCandidateGroupsExpression(candidateGroupsExpression);
        }
    }

    public TaskDefinitionImpl parseTaskDefinition(Element element, Parse parse, ScopeElementImpl scopeElement) {
        Element reminderElement;
        ProcessDefinitionImpl processDefinition;
        TaskDefinitionImpl taskDefinition = new TaskDefinitionImpl();
        String taskName = XmlUtil.attribute(element, "name");
        taskDefinition.setName(taskName);
        String form = XmlUtil.attribute(element, "form");
        taskDefinition.setFormResourceName(form);
        String duedate = XmlUtil.attribute(element, "duedate");
        taskDefinition.setDueDateDescription(duedate);
        Integer priority = XmlUtil.attributeInteger(element, "priority", parse);
        if (priority != null) {
            taskDefinition.setPriority(priority);
        }
        if ((processDefinition = parse.contextStackFind(ProcessDefinitionImpl.class)).getTaskDefinition(taskName) != null) {
            parse.addProblem("duplicate task name " + taskName, element);
        } else {
            processDefinition.addTaskDefinitionImpl(taskDefinition);
        }
        String swimlaneName = XmlUtil.attribute(element, "swimlane");
        if (swimlaneName != null) {
            JpdlProcessDefinition jpdlProcessDefinition = parse.contextStackFind(JpdlProcessDefinition.class);
            SwimlaneDefinitionImpl swimlaneDefinition = jpdlProcessDefinition.getSwimlaneDefinition(swimlaneName);
            if (swimlaneDefinition != null) {
                taskDefinition.setSwimlaneDefinition(swimlaneDefinition);
            } else {
                parse.addProblem("swimlane " + swimlaneName + " not declared", element);
            }
        }
        this.parseAssignmentAttributes(element, taskDefinition, parse);
        Element notificationElement = XmlUtil.element(element, "notification");
        if (notificationElement != null) {
            this.parseMailEvent(notificationElement, parse, scopeElement, "assign");
        }
        if ((reminderElement = XmlUtil.element(element, "reminder")) != null) {
            this.parseMailEvent(reminderElement, parse, scopeElement, "remind");
            TimerDefinitionImpl timerDefinition = this.parseTimerDefinition(reminderElement, parse, scopeElement);
            timerDefinition.setEventName("remind");
        }
        return taskDefinition;
    }

    public void parseVariableDefinitions(Element element, Parse parse, ScopeElementImpl scopeElement) {
        ArrayList<VariableDefinitionImpl> variableDefinitions = new ArrayList<VariableDefinitionImpl>();
        for (Element variableElement : XmlUtil.elements(element, "variable")) {
            Element initDescriptorElement;
            VariableDefinitionImpl variableDefinition = scopeElement.createVariableDefinition();
            String name = XmlUtil.attribute(variableElement, "name", parse);
            variableDefinition.setName(name);
            String type = XmlUtil.attribute(variableElement, "type", parse);
            variableDefinition.setTypeName(type);
            Boolean isHistoryEnabled = XmlUtil.attributeBoolean(variableElement, "history", parse);
            if (isHistoryEnabled != null) {
                variableDefinition.setHistoryEnabled(isHistoryEnabled);
            }
            int sources = 0;
            String initExpr = XmlUtil.attribute(variableElement, "init-expr");
            String initExprType = XmlUtil.attribute(variableElement, "init-expr-type");
            if (initExpr != null) {
                Expression initExpression = Expression.create(initExpr, initExprType);
                variableDefinition.setInitExpression(initExpression);
                ++sources;
            }
            if ((initDescriptorElement = XmlUtil.element(variableElement)) != null) {
                Descriptor initValueDescriptor = (Descriptor)WireParser.getInstance().parseElement(initDescriptorElement, parse);
                variableDefinition.setInitDescriptor(initValueDescriptor);
                ++sources;
            }
            if (sources > 1) {
                parse.addProblem("init attribute and init element are mutually exclusive on element variable", variableElement);
            }
            variableDefinitions.add(variableDefinition);
        }
    }

    public void parseMailEvent(Element element, Parse parse, ObservableElementImpl observableElement, String eventName) {
        EventImpl event = observableElement.getEvent(eventName);
        if (event == null) {
            event = observableElement.createEvent(eventName);
        }
        MailListener eventListener = new MailListener();
        EventListenerReference eventListenerRef = event.createEventListenerReference(eventListener);
        String continuationText = XmlUtil.attribute(element, "continue");
        if ("async".equals(continuationText)) {
            eventListenerRef.setContinuation(Continuation.ASYNCHRONOUS);
        } else if ("exclusive".equals(continuationText)) {
            eventListenerRef.setContinuation(Continuation.EXCLUSIVE);
        }
        String mailTemplateName = eventName;
        if ("assign".equals(eventName)) {
            mailTemplateName = "task-notification";
        } else if ("remind".equals(eventName)) {
            mailTemplateName = "task-reminder";
        }
        UserCodeReference mailProducer = this.parseMailProducer(element, parse, mailTemplateName);
        eventListener.setMailProducerReference(mailProducer);
    }

    public UserCodeReference parseMailProducer(Element element, Parse parse, String defaultTemplateName) {
        if (ObjectBinding.isObjectDescriptor(element)) {
            return this.parseUserCodeReference(element, parse);
        }
        MailTemplate mailTemplate = this.parseMailTemplate(element, parse, defaultTemplateName);
        ObjectDescriptor descriptor = new ObjectDescriptor(MailProducerImpl.class);
        descriptor.addPropertyInjection("template", new ProvidedObjectDescriptor(mailTemplate));
        UserCodeReference userCodeReference = new UserCodeReference();
        userCodeReference.setDescriptor(descriptor);
        return userCodeReference;
    }

    private MailTemplate parseMailTemplate(Element element, Parse parse, String defaultTemplateName) {
        if (element.hasAttribute("template")) {
            return this.findMailTemplate(element, parse, element.getAttribute("template"));
        }
        if (!XmlUtil.isTextOnly(element)) {
            return MailTemplateBinding.parseMailTemplate(element, parse);
        }
        if (defaultTemplateName != null) {
            return this.findMailTemplate(element, parse, defaultTemplateName);
        }
        parse.addProblem("mail template must be referenced in the 'template' attribute or specified inline", element);
        return null;
    }

    private MailTemplate findMailTemplate(Element element, Parse parse, String templateName) {
        MailTemplate template;
        MailTemplateRegistry templateRegistry = EnvironmentImpl.getFromCurrent(MailTemplateRegistry.class);
        if (templateRegistry != null && (template = templateRegistry.getTemplate(templateName)) != null) {
            return template;
        }
        parse.addProblem("mail template not found: " + templateName, element);
        return null;
    }

    public UserCodeReference parseUserCodeReference(Element element, Parse parse) {
        Boolean isCached;
        UserCodeReference userCodeReference = new UserCodeReference();
        ObjectDescriptor objectDescriptor = this.parseObjectDescriptor(element, parse);
        userCodeReference.setDescriptor(objectDescriptor);
        if (objectDescriptor.getExpression() != null) {
            userCodeReference.setCached(false);
        }
        if ((isCached = XmlUtil.attributeBoolean(element, "cache", parse)) != null) {
            userCodeReference.setCached(isCached);
        }
        return userCodeReference;
    }

    public ObjectDescriptor parseObjectDescriptor(Element element, Parse parse) {
        return ObjectBinding.parseObjectDescriptor(element, parse, WireParser.getInstance());
    }

    public Descriptor parseDescriptor(Element element, Parse parse) {
        return (Descriptor)WireParser.getInstance().parseElement(element, parse);
    }

    public Set<String> getActivityTagNames() {
        return this.getBindings().getTagNames(CATEGORY_ACTIVITY);
    }
}

