/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.cmd;

import org.jbpm.api.JbpmException;
import org.jbpm.api.cmd.Environment;
import org.jbpm.pvm.internal.cmd.AbstractCommand;
import org.jbpm.pvm.internal.session.DbSession;
import org.jbpm.pvm.internal.task.TaskImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompleteTaskCmd
extends AbstractCommand<Void> {
    private static final long serialVersionUID = 1L;
    protected String taskId;
    protected String outcome;
    protected boolean outcomeSpecified;

    public CompleteTaskCmd(String taskId, String outcome) {
        this.taskId = taskId;
        this.outcome = outcome;
        this.outcomeSpecified = true;
    }

    public CompleteTaskCmd(String taskId) {
        this.taskId = taskId;
        this.outcomeSpecified = false;
    }

    @Override
    public Void execute(Environment environment) throws Exception {
        DbSession dbSession = environment.get(DbSession.class);
        if (this.taskId == null || "".equals(this.taskId)) {
            throw new JbpmException("Cannot complete a task with a null or empty taskId");
        }
        TaskImpl task = dbSession.get(TaskImpl.class, Long.parseLong(this.taskId));
        if (task == null) {
            throw new JbpmException("No task with id " + this.taskId + " was found");
        }
        if (this.outcomeSpecified) {
            task.complete(this.outcome);
        } else {
            task.complete();
        }
        return null;
    }
}

