/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.cmd;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jbpm.api.JbpmException;
import org.jbpm.api.cmd.Environment;
import org.jbpm.pvm.internal.cmd.AbstractCommand;
import org.jbpm.pvm.internal.history.model.HistoryProcessInstanceImpl;
import org.jbpm.pvm.internal.history.model.HistoryVariableImpl;
import org.jbpm.pvm.internal.session.DbSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetHistoryVariablesCmd
extends AbstractCommand<Map<String, ?>> {
    private static final long serialVersionUID = 1L;
    protected String processInstanceId;
    protected Set<String> variableNames;

    public GetHistoryVariablesCmd(String processInstanceId, Set<String> variableNames) {
        if (processInstanceId == null) {
            throw new JbpmException("processInstanceId is null");
        }
        if (variableNames == null) {
            throw new JbpmException("variableNames is null");
        }
        this.processInstanceId = processInstanceId;
        this.variableNames = variableNames;
    }

    @Override
    public Map<String, ?> execute(Environment environment) throws Exception {
        HistoryProcessInstanceImpl historyProcessInstance = (HistoryProcessInstanceImpl)environment.get(DbSession.class).createHistoryProcessInstanceQuery().processInstanceId(this.processInstanceId).uniqueResult();
        if (historyProcessInstance == null) {
            throw new JbpmException("process instance not found in history: " + this.processInstanceId);
        }
        HashMap<String, String> variableMap = new HashMap<String, String>();
        for (HistoryVariableImpl historyVariable : historyProcessInstance.getHistoryVariables()) {
            if (!this.variableNames.contains(historyVariable.getVariableName())) continue;
            variableMap.put(historyVariable.getVariableName(), historyVariable.getValue());
        }
        return variableMap;
    }
}

