/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.email.impl;

import java.util.Collection;
import java.util.List;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import org.jbpm.api.JbpmException;
import org.jbpm.pvm.internal.email.impl.AddressFilter;
import org.jbpm.pvm.internal.email.impl.MailServer;
import org.jbpm.pvm.internal.email.spi.MailSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailSessionImpl
implements MailSession {
    private List<MailServer> mailServers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(Collection<Message> emails) {
        for (Message email : emails) {
            try {
                Address[] to = email.getRecipients(Message.RecipientType.TO);
                Address[] cc = email.getRecipients(Message.RecipientType.CC);
                Address[] bcc = email.getRecipients(Message.RecipientType.BCC);
                for (MailServer mailServer : this.mailServers) {
                    Address[] recipients;
                    AddressFilter addressFilter = mailServer.getAddressFilter();
                    if (addressFilter != null) {
                        email.setRecipients(Message.RecipientType.TO, addressFilter.filter(to));
                        email.setRecipients(Message.RecipientType.CC, addressFilter.filter(cc));
                        email.setRecipients(Message.RecipientType.BCC, addressFilter.filter(bcc));
                    }
                    Session mailSession = mailServer.getMailSession();
                    if (email.getFrom() == null) {
                        email.setFrom((Address)InternetAddress.getLocalAddress((Session)mailSession));
                    }
                    if ((recipients = email.getAllRecipients()).length <= 0) continue;
                    Transport transport = mailSession.getTransport(recipients[0]);
                    try {
                        transport.connect();
                        transport.sendMessage(email, recipients);
                    }
                    finally {
                        transport.close();
                    }
                }
            }
            catch (MessagingException e) {
                throw new JbpmException("could not send email: " + email, e);
            }
        }
    }

    public List<MailServer> getMailServers() {
        return this.mailServers;
    }

    protected void setMailServers(List<MailServer> mailServers) {
        this.mailServers = mailServers;
    }
}

