/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.env;

import java.io.Serializable;
import java.util.Stack;
import org.jbpm.api.JbpmException;
import org.jbpm.api.cmd.Environment;
import org.jbpm.pvm.internal.env.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EnvironmentImpl
implements Serializable,
Environment {
    private static final long serialVersionUID = 1L;
    static ThreadLocal<EnvironmentImpl> currentEnvironment = new ThreadLocal();
    static ThreadLocal<Stack<EnvironmentImpl>> currentEnvironmentStack = new ThreadLocal();

    @Override
    public abstract Object get(String var1);

    public abstract Object get(String var1, String[] var2);

    public abstract Object get(String var1, String[] var2, boolean var3) throws JbpmException;

    public abstract Object get(String var1, boolean var2) throws JbpmException;

    @Override
    public abstract <T> T get(Class<T> var1);

    public abstract <T> T get(Class<T> var1, String[] var2);

    public abstract String getAuthenticatedUserId();

    public abstract void setAuthenticatedUserId(String var1);

    public abstract void close();

    public abstract Context getContext(String var1);

    public abstract void setContext(Context var1);

    public abstract Context removeContext(Context var1);

    public abstract Context removeContext(String var1);

    public abstract ClassLoader getClassLoader();

    public abstract void setClassLoader(ClassLoader var1);

    public static EnvironmentImpl getCurrent() {
        return currentEnvironment.get();
    }

    public static <T> T getFromCurrent(Class<T> type) {
        return EnvironmentImpl.getFromCurrent(type, true);
    }

    public static <T> T getFromCurrent(Class<T> type, boolean required) {
        EnvironmentImpl environment = EnvironmentImpl.getCurrent();
        if (environment == null) {
            if (required) {
                throw new JbpmException("no environment to get " + type.getName());
            }
            return null;
        }
        T object = environment.get(type);
        if (object == null) {
            if (required) {
                throw new JbpmException("no " + type.getName() + " in current environment");
            }
            return null;
        }
        return object;
    }

    public static Object getFromCurrent(String name) {
        return EnvironmentImpl.getFromCurrent(name, true);
    }

    public static Object getFromCurrent(String name, boolean required) {
        EnvironmentImpl environment = EnvironmentImpl.getCurrent();
        if (environment == null) {
            if (required) {
                throw new JbpmException("no environment to get '" + name + "'");
            }
            return null;
        }
        Object object = environment.get(name);
        if (object == null) {
            if (required) {
                throw new JbpmException("no '" + name + "' in current environment");
            }
            return null;
        }
        return object;
    }

    static Stack<EnvironmentImpl> getStack() {
        Stack<EnvironmentImpl> stack = currentEnvironmentStack.get();
        if (stack == null) {
            stack = new Stack();
            currentEnvironmentStack.set(stack);
        }
        return stack;
    }

    public static synchronized EnvironmentImpl popEnvironment() {
        EnvironmentImpl popped = currentEnvironment.get();
        currentEnvironment.set(null);
        Stack<EnvironmentImpl> stack = currentEnvironmentStack.get();
        if (stack != null && !stack.isEmpty()) {
            currentEnvironment.set(stack.pop());
        }
        return popped;
    }

    public static synchronized void pushEnvironment(EnvironmentImpl environment) {
        EnvironmentImpl current = currentEnvironment.get();
        if (current != null) {
            EnvironmentImpl.getStack().push(current);
        }
        currentEnvironment.set(environment);
    }
}

