/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.env;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.env.Context;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringContext
implements Context {
    private static final Log LOG = Log.getLog(SpringContext.class.getName());
    private ApplicationContext applicationContext;

    public SpringContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public Object get(String key) {
        if (this.applicationContext.containsBean(key)) {
            return this.applicationContext.getBean(key);
        }
        return null;
    }

    @Override
    public <T> T get(Class<T> type) {
        String[] names = this.applicationContext.getBeanNamesForType(type);
        if (names.length > 1 && LOG.isWarnEnabled()) {
            LOG.warn("Multiple Spring beans found for type " + type + " returning the first one found");
        }
        if (names.length >= 1) {
            return (T)this.applicationContext.getBean(names[0]);
        }
        return null;
    }

    @Override
    public String getName() {
        return "spring";
    }

    @Override
    public boolean has(String key) {
        return this.applicationContext.containsBean(key);
    }

    @Override
    public Set<String> keys() {
        HashSet<String> set = new HashSet<String>(Arrays.asList(this.applicationContext.getBeanDefinitionNames()));
        return set;
    }

    @Override
    public Object set(String key, Object value) {
        throw new RuntimeException("Can't add to the spring context");
    }
}

