/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.identity.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import org.jbpm.api.JbpmException;
import org.jbpm.api.identity.Group;
import org.jbpm.pvm.internal.identity.impl.GroupImpl;
import org.jbpm.pvm.internal.identity.impl.UserImpl;
import org.jbpm.pvm.internal.identity.spi.IdentitySession;
import org.picketlink.idm.api.Attribute;
import org.picketlink.idm.api.AttributesManager;
import org.picketlink.idm.api.IdentitySearchCriteria;
import org.picketlink.idm.api.IdentityType;
import org.picketlink.idm.api.RoleManager;
import org.picketlink.idm.api.RoleType;
import org.picketlink.idm.api.User;
import org.picketlink.idm.common.exception.FeatureNotSupportedException;
import org.picketlink.idm.common.exception.IdentityException;
import org.picketlink.idm.impl.api.SimpleAttribute;
import org.picketlink.idm.impl.api.model.GroupKey;
import org.picketlink.idm.impl.api.model.SimpleGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossIdmIdentitySessionImpl
implements IdentitySession {
    protected org.picketlink.idm.api.IdentitySession identitySession;
    private static final String DEFAULT_JBPM_MEMBER_ROLE = "default_jBPM_member_role";
    private static final String DEFAULT_JBPM_GROUP_TYPE = "default_jBPM_Group_Type";

    public JBossIdmIdentitySessionImpl(org.picketlink.idm.api.IdentitySession identitySession) {
        this.identitySession = identitySession;
    }

    @Override
    public String createUser(String userName, String givenName, String familyName, String businessEmail) {
        try {
            User idUser = this.identitySession.getPersistenceManager().createUser(userName);
            ArrayList<SimpleAttribute> attrs = new ArrayList<SimpleAttribute>();
            if (givenName != null) {
                attrs.add(new SimpleAttribute("user.name.given", (Object)givenName));
            }
            if (familyName != null) {
                attrs.add(new SimpleAttribute("user.name.family", (Object)familyName));
            }
            if (businessEmail != null) {
                attrs.add(new SimpleAttribute("user.business-info.online.email", (Object)businessEmail));
            }
            this.identitySession.getAttributesManager().addAttributes((IdentityType)idUser, attrs.toArray(new Attribute[attrs.size()]));
            return idUser.getId();
        }
        catch (IdentityException e) {
            throw new JbpmException("could not create user: " + userName, e);
        }
    }

    @Override
    public List<org.jbpm.api.identity.User> findUsers() {
        try {
            Collection idUsers = this.identitySession.getPersistenceManager().findUser((IdentitySearchCriteria)null);
            ArrayList<org.jbpm.api.identity.User> users = new ArrayList<org.jbpm.api.identity.User>();
            for (User idUser : idUsers) {
                users.add(this.getUserInfo(idUser));
            }
            return users;
        }
        catch (IdentityException e) {
            throw new JbpmException("could not find users", e);
        }
    }

    @Override
    public org.jbpm.api.identity.User findUserById(String userId) {
        try {
            User idUser = this.identitySession.getPersistenceManager().findUser(userId);
            if (idUser != null) {
                return this.getUserInfo(idUser);
            }
            return null;
        }
        catch (IdentityException e) {
            throw new JbpmException("could not find user by id: " + userId, e);
        }
    }

    private org.jbpm.api.identity.User getUserInfo(User idUser) throws IdentityException {
        String name = idUser.getId();
        String givenName = this.getAttributeString(idUser, "user.name.given");
        String familyName = this.getAttributeString(idUser, "user.name.family");
        String businessEmail = this.getAttributeString(idUser, "user.business-info.online.email");
        UserImpl user = new UserImpl(name, givenName, familyName);
        user.setBusinessEmail(businessEmail);
        return user;
    }

    @Override
    public List<org.jbpm.api.identity.User> findUsersById(String ... userIds) {
        ArrayList<org.jbpm.api.identity.User> users = new ArrayList<org.jbpm.api.identity.User>();
        for (String userId : userIds) {
            org.jbpm.api.identity.User user = this.findUserById(userId);
            if (user == null) continue;
            users.add(user);
        }
        return users;
    }

    @Override
    public List<org.jbpm.api.identity.User> findUsersByGroup(String groupKey) {
        try {
            ArrayList<org.jbpm.api.identity.User> users = new ArrayList<org.jbpm.api.identity.User>();
            org.picketlink.idm.api.Group idGroup = this.findIdmGroupByKey(this.convertjbpmGroupId2IdmGroupKey(groupKey));
            if (idGroup == null) {
                return users;
            }
            Collection idusers = this.identitySession.getRoleManager().findUsersWithRelatedRole(idGroup, null);
            for (User iduser : idusers) {
                users.add(this.findUserById(iduser.getId()));
            }
            return users;
        }
        catch (IdentityException e) {
            throw new JbpmException("could not find users by group: " + groupKey, e);
        }
        catch (FeatureNotSupportedException e) {
            throw new JbpmException("could not find users by group: " + groupKey, e);
        }
    }

    @Override
    public void deleteUser(String userName) {
        try {
            this.identitySession.getPersistenceManager().removeUser(userName, true);
        }
        catch (IdentityException e) {
            throw new JbpmException("could not delete user: " + userName, e);
        }
    }

    @Override
    public String createGroup(String groupName, String groupType, String parentGroupKey) {
        try {
            if (groupType == null) {
                groupType = DEFAULT_JBPM_GROUP_TYPE;
            }
            SimpleGroup group = (SimpleGroup)this.identitySession.getPersistenceManager().createGroup(groupName, groupType);
            String groupKey = group.getKey();
            if (parentGroupKey != null) {
                org.picketlink.idm.api.Group parentGroup = this.findIdmGroupByKey(this.convertjbpmGroupId2IdmGroupKey(parentGroupKey));
                if (parentGroup == null) {
                    throw new JbpmException("parent group does not exist: " + parentGroupKey);
                }
                this.identitySession.getRelationshipManager().associateGroups(parentGroup, (org.picketlink.idm.api.Group)group);
            }
            return this.convertIdmGroupKey2jbpmGroupId(groupKey);
        }
        catch (IdentityException e) {
            throw new JbpmException("could not create group: " + groupName, e);
        }
    }

    @Override
    public Group findGroupById(String groupId) {
        try {
            SimpleGroup idGroup = (SimpleGroup)this.findIdmGroupByKey(this.convertjbpmGroupId2IdmGroupKey(groupId));
            if (idGroup == null) {
                return null;
            }
            GroupImpl group = new GroupImpl();
            group.setId(this.convertIdmGroupKey2jbpmGroupId(idGroup.getKey()));
            group.setType(idGroup.getGroupType());
            group.setName(idGroup.getName());
            Collection idParentGroups = this.identitySession.getRelationshipManager().findAssociatedGroups((org.picketlink.idm.api.Group)idGroup, null, false, false);
            if (idParentGroups.size() > 0) {
                SimpleGroup idParent = (SimpleGroup)idParentGroups.iterator().next();
                GroupImpl parentGroup = new GroupImpl();
                parentGroup.setId(this.convertIdmGroupKey2jbpmGroupId(idParent.getKey()));
                parentGroup.setType(idParent.getGroupType());
                parentGroup.setName(idParent.getName());
                group.setParent(parentGroup);
            }
            return group;
        }
        catch (IdentityException e) {
            throw new JbpmException("could not find group by id: " + groupId, e);
        }
    }

    public List<Group> findGroupsByGroupType(String groupType) {
        try {
            Collection idGroups = this.identitySession.getPersistenceManager().findGroup(groupType);
            ArrayList<Group> groups = new ArrayList<Group>();
            for (org.picketlink.idm.api.Group idGroup : idGroups) {
                SimpleGroup simpleGroup = (SimpleGroup)idGroup;
                groups.add(this.findGroupById(this.convertIdmGroupKey2jbpmGroupId(simpleGroup.getKey())));
            }
            return groups;
        }
        catch (IdentityException e) {
            throw new JbpmException("could not find groups by type: " + groupType, e);
        }
    }

    @Override
    public List<Group> findGroupsByUser(String userId) {
        try {
            Collection idGroups = this.identitySession.getRoleManager().findGroupsWithRelatedRole(userId, null);
            ArrayList<Group> groups = new ArrayList<Group>();
            for (org.picketlink.idm.api.Group idGroup : idGroups) {
                groups.add(this.findGroupById(this.convertIdmGroupKey2jbpmGroupId(idGroup.getKey())));
            }
            return groups;
        }
        catch (IdentityException e) {
            throw new JbpmException("could not find groups by user: " + userId, e);
        }
        catch (FeatureNotSupportedException e) {
            throw new JbpmException("could not find groups by user: " + userId, e);
        }
    }

    @Override
    public List<Group> findGroupsByUserAndGroupType(String userName, String groupType) {
        try {
            User idUser = this.identitySession.getPersistenceManager().findUser(userName);
            Collection idGroups = this.identitySession.getRoleManager().findGroupsWithRelatedRole(idUser, groupType, null);
            ArrayList<Group> groups = new ArrayList<Group>();
            for (org.picketlink.idm.api.Group idGroup : idGroups) {
                SimpleGroup simpleGroup = (SimpleGroup)idGroup;
                groups.add(this.findGroupById(this.convertIdmGroupKey2jbpmGroupId(simpleGroup.getKey())));
            }
            return groups;
        }
        catch (IdentityException e) {
            throw new JbpmException("could not find groups by user '" + userName + "' and type: " + groupType, e);
        }
        catch (FeatureNotSupportedException e) {
            throw new JbpmException("could not find groups by user '" + userName + "' and type: " + groupType, e);
        }
    }

    @Override
    public void deleteGroup(String groupId) {
        try {
            org.picketlink.idm.api.Group group = this.findIdmGroupByKey(this.convertjbpmGroupId2IdmGroupKey(groupId));
            if (group == null) {
                return;
            }
            this.identitySession.getPersistenceManager().removeGroup(group, true);
        }
        catch (IdentityException e) {
            throw new JbpmException("could not delete group " + groupId, e);
        }
    }

    @Override
    public void createMembership(String userId, String groupId, String role) {
        try {
            RoleManager roleManager;
            RoleType roleType;
            org.picketlink.idm.api.Group group = this.findIdmGroupByKey(this.convertjbpmGroupId2IdmGroupKey(groupId));
            if (group == null) {
                throw new JbpmException("group not found: " + groupId);
            }
            User idUser = this.identitySession.getPersistenceManager().findUser(userId);
            if (idUser == null) {
                throw new JbpmException("user not found: " + userId);
            }
            if (role == null) {
                role = DEFAULT_JBPM_MEMBER_ROLE;
            }
            if ((roleType = (roleManager = this.identitySession.getRoleManager()).getRoleType(role)) == null) {
                roleType = roleManager.createRoleType(role);
            }
            roleManager.createRole(roleType, idUser, group);
        }
        catch (IdentityException e) {
            throw new JbpmException("could not create membership for user '" + userId + "', group '" + groupId + "' and role: " + role, e);
        }
        catch (FeatureNotSupportedException e) {
            throw new JbpmException("could not create membership for user '" + userId + "', group '" + groupId + "' and role: " + role, e);
        }
    }

    @Override
    public void deleteMembership(String userId, String groupId, String role) {
        try {
            RoleManager roleManager = this.identitySession.getRoleManager();
            RoleType rtype = roleManager.getRoleType(role);
            roleManager.removeRole(rtype.getName(), userId, this.convertjbpmGroupId2IdmGroupKey(groupId));
        }
        catch (IdentityException e) {
            throw new JbpmException("could not delete membership for user '" + userId + "', group '" + groupId + "' and role: " + role, e);
        }
        catch (FeatureNotSupportedException e) {
            throw new JbpmException("could not delete membership for user '" + userId + "', group '" + groupId + "' and role: " + role, e);
        }
    }

    protected org.picketlink.idm.api.Group findIdmGroupByKey(String groupKey) {
        try {
            return this.identitySession.getPersistenceManager().findGroupByKey(groupKey);
        }
        catch (IdentityException e) {
            throw new JbpmException("could not find group by key: " + groupKey, e);
        }
    }

    protected String getAttributeString(User idUser, String attributeName) throws IdentityException {
        return this.getAttributeString(idUser, null, attributeName);
    }

    protected String getAttributeString(org.picketlink.idm.api.Group idGroup, String attributeName) throws IdentityException {
        return this.getAttributeString(null, idGroup, attributeName);
    }

    protected String getAttributeString(User idUser, org.picketlink.idm.api.Group idGroup, String attributeName) throws IdentityException {
        AttributesManager attributesManager = this.identitySession.getAttributesManager();
        Attribute attribute = idUser != null ? attributesManager.getAttribute((IdentityType)idUser, attributeName) : attributesManager.getAttribute((IdentityType)idGroup, attributeName);
        return attribute != null ? (String)attribute.getValue() : null;
    }

    private String convertIdmGroupKey2jbpmGroupId(String groupKey) {
        GroupKey theGroupKey = new GroupKey(groupKey);
        String type = theGroupKey.getType();
        if (type == null || DEFAULT_JBPM_GROUP_TYPE.equals(type)) {
            return theGroupKey.getName();
        }
        return type + "." + theGroupKey.getName();
    }

    private String convertjbpmGroupId2IdmGroupKey(String jbpmGroupId) {
        StringTokenizer st = new StringTokenizer(jbpmGroupId, ".");
        String type = DEFAULT_JBPM_GROUP_TYPE;
        if (st.countTokens() > 1) {
            type = st.nextToken();
        }
        String name = st.nextToken();
        return new GroupKey(name, type).getKey();
    }

    public org.picketlink.idm.api.IdentitySession getIdentitySession() {
        return this.identitySession;
    }

    public void setIdentitySession(org.picketlink.idm.api.IdentitySession identitySession) {
        this.identitySession = identitySession;
    }
}

