/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.job;

import java.text.ParseException;
import org.jbpm.api.ExecutionService;
import org.jbpm.api.JbpmException;
import org.jbpm.api.RepositoryService;
import org.jbpm.api.cmd.Environment;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.cal.CronExpression;
import org.jbpm.pvm.internal.cal.Duration;
import org.jbpm.pvm.internal.env.EnvironmentImpl;
import org.jbpm.pvm.internal.job.TimerImpl;
import org.jbpm.pvm.internal.model.ProcessDefinitionImpl;
import org.jbpm.pvm.internal.session.RepositorySession;
import org.jbpm.pvm.internal.util.Clock;

public class StartProcessTimer
extends TimerImpl {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = Log.getLog(StartProcessTimer.class.getName());

    public Boolean execute(Environment environment) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Periodic start process triggered at " + Clock.getTime());
        }
        if (this.processDefinitionExists(environment)) {
            this.startProcessInstance(environment);
            if (this.calculateDueDate(environment)) {
                return false;
            }
        }
        return true;
    }

    protected boolean processDefinitionExists(Environment environment) {
        boolean processExists;
        RepositoryService repositoryService = environment.get(RepositoryService.class);
        boolean bl = processExists = !repositoryService.createProcessDefinitionQuery().processDefinitionName(this.getProcessDefinitionName()).list().isEmpty();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Process definition with name " + this.getProcessDefinitionName() + " still exists: " + processExists);
        }
        return processExists;
    }

    protected void startProcessInstance(Environment environment) {
        RepositorySession repoSession;
        ExecutionService executionService = environment.get(ExecutionService.class);
        if (executionService == null) {
            throw new JbpmException("no " + ExecutionService.class.getName() + " in environment");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting a new process instance for process definition with name " + this.getProcessDefinitionName());
        }
        if ((repoSession = environment.get(RepositorySession.class)) == null) {
            throw new JbpmException("Could not find a" + RepositorySession.class.getName() + " impl in environment");
        }
        ProcessDefinitionImpl procDef = repoSession.findLatestProcessDefinitionByName(this.getProcessDefinitionName());
        executionService.startProcessInstanceById(procDef.getId());
    }

    protected boolean calculateDueDate(Environment environment) throws ParseException {
        if (this.getIntervalExpression() != null && Duration.isValidExpression(this.getIntervalExpression())) {
            this.dueDate = Duration.calculateDueDate(this.getIntervalExpression());
        } else if (this.getIntervalExpression() != null && CronExpression.isValidExpression(this.getIntervalExpression())) {
            this.dueDate = new CronExpression(this.getIntervalExpression()).getNextValidTimeAfter(Clock.getTime());
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No next duedate calculated for start process job with intervalExpression " + this.getIntervalExpression());
            }
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Next process start duedate: " + this.dueDate);
        }
        return true;
    }

    public void schedule() {
        if (this.dueDate == null && this.getIntervalExpression() != null) {
            try {
                this.calculateDueDate(EnvironmentImpl.getCurrent());
            }
            catch (ParseException e) {
                throw new JbpmException("Cannot parse intervalExpression", e);
            }
        } else if (this.dueDate == null) {
            throw new JbpmException("Cannot schedule start process timer: no duedate or intervalExpression set");
        }
        super.schedule();
    }

    public void validate() {
        if (this.getProcessDefinitionName() == null) {
            throw new JbpmException("No process definition name set for start process timer");
        }
        if (this.dueDate == null && this.getIntervalExpression() == null) {
            throw new JbpmException("No duedate or intervalExpression found for start process timer");
        }
    }

    public String getProcessDefinitionName() {
        return this.signalName;
    }

    public void setProcessDefinitionName(String processDefinitionName) {
        this.signalName = processDefinitionName;
    }

    public String getIntervalExpression() {
        return this.eventName;
    }

    public void setIntervalExpression(String intervalExpression) {
        this.eventName = intervalExpression;
    }

    public String toString() {
        StringBuilder strb = new StringBuilder();
        strb.append("PeriodicProcessStart[");
        if (this.getProcessDefinitionName() != null) {
            strb.append(this.getProcessDefinitionName());
        }
        if (this.dueDate != null) {
            strb.append("| " + this.dueDate);
        }
        if (this.getIntervalExpression() != null) {
            strb.append("| " + this.getIntervalExpression());
        }
        strb.append("]");
        return strb.toString();
    }
}

