/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.query;

import java.util.Date;
import java.util.List;
import org.hibernate.Query;
import org.jbpm.api.history.HistoryProcessInstance;
import org.jbpm.api.history.HistoryProcessInstanceQuery;
import org.jbpm.pvm.internal.history.model.HistoryProcessInstanceImpl;
import org.jbpm.pvm.internal.query.AbstractQuery;
import org.jbpm.pvm.internal.query.Page;
import org.jbpm.pvm.internal.util.CollectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoryProcessInstanceQueryImpl
extends AbstractQuery
implements HistoryProcessInstanceQuery {
    private static final long serialVersionUID = 1L;
    protected String processDefinitionId;
    protected String state;
    protected String processInstanceId;
    protected String processInstanceKey;
    protected boolean ended;
    protected Date endedBefore;
    protected Date endedAfter;

    @Override
    public String hql() {
        StringBuilder hql = new StringBuilder();
        hql.append("select ");
        if (this.count) {
            hql.append("count(hpi) ");
        } else {
            hql.append("hpi ");
        }
        hql.append("from ");
        hql.append(HistoryProcessInstanceImpl.class.getName());
        hql.append(" as hpi ");
        if (this.processInstanceId != null) {
            this.appendWhereClause(" hpi.processInstanceId = '" + this.processInstanceId + "' ", hql);
        }
        if (this.processDefinitionId != null) {
            this.appendWhereClause(" hpi.processDefinitionId = '" + this.processDefinitionId + "' ", hql);
        }
        if (this.state != null) {
            this.appendWhereClause(" hpi.state = '" + this.state + "' ", hql);
        }
        if (this.processInstanceKey != null) {
            this.appendWhereClause(" hpi.key = '" + this.processInstanceKey + "'", hql);
        }
        if (this.ended) {
            this.appendWhereClause(" hpi.endTime is not null", hql);
        }
        if (this.endedBefore != null) {
            this.appendWhereClause(" hpi.endTime < :before", hql);
        }
        if (this.endedAfter != null) {
            this.appendWhereClause(" hpi.endTime >= :after", hql);
        }
        this.appendOrderByClause(hql);
        return hql.toString();
    }

    @Override
    protected void applyParameters(Query query) {
        if (this.endedBefore != null) {
            query.setTimestamp("before", this.endedBefore);
        }
        if (this.endedAfter != null) {
            query.setTimestamp("after", this.endedAfter);
        }
    }

    @Override
    public List<HistoryProcessInstance> list() {
        return CollectionUtil.checkList(this.untypedList(), HistoryProcessInstance.class);
    }

    @Override
    public HistoryProcessInstance uniqueResult() {
        return (HistoryProcessInstance)this.untypedUniqueResult();
    }

    @Override
    public HistoryProcessInstanceQuery processInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Override
    public HistoryProcessInstanceQuery orderAsc(String property) {
        this.addOrderByClause("hpi." + property + " asc");
        return this;
    }

    @Override
    public HistoryProcessInstanceQuery orderDesc(String property) {
        this.addOrderByClause("hpi." + property + " desc");
        return this;
    }

    @Override
    public HistoryProcessInstanceQuery page(int firstResult, int maxResults) {
        this.page = new Page(firstResult, maxResults);
        return this;
    }

    @Override
    public HistoryProcessInstanceQuery processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Override
    public HistoryProcessInstanceQuery processInstanceKey(String processInstanceKey) {
        this.processInstanceKey = processInstanceKey;
        return this;
    }

    @Override
    public HistoryProcessInstanceQuery state(String state) {
        this.state = state;
        return this;
    }

    @Override
    public HistoryProcessInstanceQuery ended() {
        this.ended = true;
        this.endedAfter = null;
        this.endedBefore = null;
        return this;
    }

    @Override
    public HistoryProcessInstanceQuery endedBefore(Date threshold) {
        if (this.endedAfter != null && this.endedAfter.after(threshold)) {
            throw new IllegalArgumentException("threshold is later than endedAfter date");
        }
        this.endedBefore = threshold;
        this.ended = false;
        return this;
    }

    @Override
    public HistoryProcessInstanceQuery endedAfter(Date threshold) {
        if (this.endedBefore != null && this.endedBefore.before(threshold)) {
            throw new IllegalArgumentException("threshold is earlier than endedBefore date");
        }
        this.endedAfter = threshold;
        this.ended = false;
        return this;
    }
}

