/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.repository;

import java.util.ArrayList;
import java.util.List;
import org.jbpm.api.JbpmException;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.env.EnvironmentImpl;
import org.jbpm.pvm.internal.repository.Deployer;
import org.jbpm.pvm.internal.repository.DeploymentImpl;
import org.jbpm.pvm.internal.repository.RepositoryCache;
import org.jbpm.pvm.internal.xml.Problem;

public class DeployerManager {
    private static Log LOG = Log.getLog(DeployerManager.class.getName());
    List<Deployer> deployers;

    public void deploy(DeploymentImpl deployment) {
        deployment.setProblems(new ArrayList<Problem>());
        for (Deployer deployer : this.deployers) {
            deployer.deploy(deployment);
        }
        if (deployment.hasErrors()) {
            JbpmException jbpmException = deployment.getJbpmException();
            LOG.info("errors during deployment of " + deployment + ": " + jbpmException.getMessage());
            throw jbpmException;
        }
        RepositoryCache repositoryCache = EnvironmentImpl.getFromCurrent(RepositoryCache.class);
        if (repositoryCache != null) {
            if (deployment.getObjects() == null || deployment.getObjects().isEmpty()) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("WARNING: no objects were deployed! Check if you have configured a correct deployer in your jbpm.cfg.xml file for the type of deployment you want to do.");
                }
            } else {
                repositoryCache.set(deployment.getId(), deployment.getObjects());
            }
        }
    }

    public void updateResource(DeploymentImpl deployment, String resourceName, byte[] bytes) {
        for (Deployer deployer : this.deployers) {
            deployer.updateResource(deployment, resourceName, bytes);
        }
        RepositoryCache repositoryCache = EnvironmentImpl.getFromCurrent(RepositoryCache.class);
        repositoryCache.remove(deployment.getId());
    }
}

