/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.repository;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import org.jbpm.pvm.internal.repository.DeploymentClassLoader;
import org.jbpm.pvm.internal.util.ReflectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentObjectInputStream
extends ObjectInputStream {
    private final String deploymentId;

    public DeploymentObjectInputStream(InputStream stream, String deploymentId) throws IOException {
        super(stream);
        this.deploymentId = deploymentId;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        try {
            return ReflectUtil.classForName(desc.getName());
        }
        catch (ClassNotFoundException e) {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            DeploymentClassLoader deploymentClassLoader = new DeploymentClassLoader(contextClassLoader, this.deploymentId);
            return Class.forName(desc.getName(), false, deploymentClassLoader);
        }
    }
}

