/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.task;

import java.util.HashMap;
import java.util.Map;
import org.jbpm.api.JbpmException;
import org.jbpm.pvm.internal.id.IdComposer;
import org.jbpm.pvm.internal.model.ActivityImpl;
import org.jbpm.pvm.internal.model.ExecutionImpl;
import org.jbpm.pvm.internal.model.ProcessDefinitionImpl;
import org.jbpm.pvm.internal.task.LifeCycleParser;
import org.jbpm.pvm.internal.task.TaskImpl;

public class LifeCycle
extends ProcessDefinitionImpl {
    private static final long serialVersionUID = 1L;
    private static LifeCycleParser lifeCycleParser = new LifeCycleParser();
    private static Map<String, ProcessDefinitionImpl> lifeCycleProcesses = new HashMap<String, ProcessDefinitionImpl>();

    public static String initialise(TaskImpl task) {
        ProcessDefinitionImpl lifeCycle = LifeCycle.getLifeCycle(task);
        HashMap<String, TaskImpl> lifeCycleVariables = new HashMap<String, TaskImpl>();
        lifeCycleVariables.put("task", task);
        ExecutionImpl lifeCycleExecution = (ExecutionImpl)lifeCycle.createProcessInstance();
        lifeCycleExecution.setVariables(lifeCycleVariables);
        lifeCycleExecution.start();
        return lifeCycleExecution.getActivity().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessDefinitionImpl getLifeCycle(TaskImpl task) {
        ProcessDefinitionImpl lifeCycleProcess;
        if (task == null) {
            throw new JbpmException("task is null");
        }
        String resource = task.getLifeCycleResource();
        if (resource == null) {
            throw new JbpmException("task " + task.getClass().getName() + " did'nt return a lifecycle");
        }
        Map<String, ProcessDefinitionImpl> map = lifeCycleProcesses;
        synchronized (map) {
            lifeCycleProcess = lifeCycleProcesses.get(resource);
            if (lifeCycleProcess == null) {
                lifeCycleProcess = (ProcessDefinitionImpl)lifeCycleParser.createParse().setResource(resource).execute().checkErrors("task lifecycle").getDocumentObject();
                lifeCycleProcesses.put(resource, lifeCycleProcess);
            }
        }
        return lifeCycleProcess;
    }

    protected static void fireLifeCycleEvent(String eventName, TaskImpl task) {
        ExecutionImpl lifeCycleExecution = new ExecutionImpl();
        ProcessDefinitionImpl lifeCycleProcess = LifeCycle.getLifeCycle(task);
        lifeCycleExecution.setProcessDefinition(lifeCycleProcess);
        String state = task.getState();
        ActivityImpl activity = lifeCycleProcess.getActivity(state);
        lifeCycleExecution.setActivity(activity);
        lifeCycleExecution.signal(eventName);
        task.setState(lifeCycleExecution.getActivity().getName());
    }

    public IdComposer getIdGenerator() {
        return null;
    }
}

