/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.task;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.jbpm.api.JbpmException;
import org.jbpm.api.task.Assignable;
import org.jbpm.api.task.Participation;
import org.jbpm.api.task.Swimlane;
import org.jbpm.pvm.internal.model.ExecutionImpl;
import org.jbpm.pvm.internal.task.ParticipationImpl;
import org.jbpm.pvm.internal.task.SwimlaneDefinitionImpl;
import org.jbpm.pvm.internal.util.EqualsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwimlaneImpl
implements Serializable,
Swimlane,
Assignable {
    private static final long serialVersionUID = 1L;
    protected long dbid;
    protected int dbversion;
    protected String name = null;
    protected String assignee = null;
    protected ExecutionImpl execution = null;
    protected Set<ParticipationImpl> participations = new HashSet<ParticipationImpl>();
    protected SwimlaneDefinitionImpl swimlaneDefinition = null;

    public void initialize(SwimlaneImpl other) {
        this.assignee = other.getAssignee();
        if (other.getParticipations() != null) {
            for (ParticipationImpl otherParticipation : other.getParticipations()) {
                this.addParticipation(otherParticipation.getUserId(), otherParticipation.getGroupId(), otherParticipation.getType());
            }
        }
    }

    @Override
    public String getAssignee() {
        return this.assignee;
    }

    @Override
    public void setAssignee(String assignee) {
        this.assignee = assignee;
    }

    public Set<ParticipationImpl> getParticipations() {
        return this.participations;
    }

    @Override
    public void addCandidateGroup(String groupId) {
        this.addParticipation(null, groupId, "candidate");
    }

    @Override
    public void addCandidateUser(String userId) {
        this.addParticipation(userId, null, "candidate");
    }

    public Participation addParticipation(String userId, String groupId, String type) {
        return this.addParticipation(new ParticipationImpl(userId, groupId, type));
    }

    private Participation addParticipation(ParticipationImpl participation) {
        participation.setSwimlane(this);
        this.participations.add(participation);
        return participation;
    }

    public void removeParticipant(ParticipationImpl participant) {
        if (participant == null) {
            throw new JbpmException("participant is null");
        }
        if (this.participations.remove(participant)) {
            participant.setSwimlane(null);
        }
    }

    public boolean equals(Object o) {
        return EqualsUtil.equals(this, o);
    }

    public String toString() {
        return "Swimlane(" + this.name + ")";
    }

    @Override
    public String getId() {
        return Long.toString(this.dbid);
    }

    public long getDbid() {
        return this.dbid;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public SwimlaneDefinitionImpl getSwimlaneDefinition() {
        return this.swimlaneDefinition;
    }

    public void setSwimlaneDefinition(SwimlaneDefinitionImpl swimlaneDefinition) {
        this.swimlaneDefinition = swimlaneDefinition;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ExecutionImpl getExecution() {
        return this.execution;
    }

    public void setExecution(ExecutionImpl execution) {
        this.execution = execution;
    }

    public void setDbid(long dbid) {
        this.dbid = dbid;
    }
}

