/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.tx;

import javax.naming.InitialContext;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.jbpm.api.JbpmException;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.tx.AbstractTransaction;
import org.jbpm.pvm.internal.tx.JtaStatusHelper;

public class JtaTransaction
extends AbstractTransaction {
    private static Log log = Log.getLog(JtaTransaction.class.getName());
    public static final String JNDINAME_USERTRANSACTION_JBOSS_GLOBAL = "UserTransaction";
    public static final String JNDINAME_TRANSACTIONMANAGER_JBOSS_GLOBAL = "java:/TransactionManager";
    protected String userTransactionJndiName = "UserTransaction";
    protected String transactionManagerJndiName = "java:/TransactionManager";

    public boolean isRollbackOnly() {
        try {
            return this.lookupJeeUserTransaction().getStatus() == 1;
        }
        catch (SystemException e) {
            throw new JbpmException("couldn't get status of user transaction: " + e.getMessage(), e);
        }
    }

    public void setRollbackOnly() {
        try {
            this.lookupJeeUserTransaction().setRollbackOnly();
        }
        catch (Exception e) {
            throw new JbpmException("couldn't set user transaction to rollback only: " + e.getMessage(), e);
        }
    }

    public void registerSynchronization(Synchronization synchronization) {
        try {
            this.lookupJeeTransaction().registerSynchronization(synchronization);
        }
        catch (Exception e) {
            throw new JbpmException("couldn't register synchronization: " + e.getMessage(), e);
        }
    }

    public void begin() {
        try {
            this.lookupJeeUserTransaction().begin();
        }
        catch (Exception e) {
            throw new JbpmException("couldn't begin transaction: " + e.getMessage(), e);
        }
    }

    public void rollback() {
        try {
            this.lookupJeeUserTransaction().rollback();
        }
        catch (Exception e) {
            throw new JbpmException("couldn't rollback: " + e.getMessage(), e);
        }
    }

    public void commit() {
        try {
            this.flushDeserializedObjects();
            this.lookupJeeUserTransaction().commit();
        }
        catch (Exception e) {
            throw new JbpmException("couldn't commit: " + e.getMessage(), e);
        }
    }

    public Transaction suspend() {
        try {
            return this.lookupJeeTransactionManager().suspend();
        }
        catch (Exception e) {
            throw new JbpmException("couldn't suspend: " + e.getMessage(), e);
        }
    }

    public void resume(Transaction transaction) {
        try {
            this.lookupJeeTransactionManager().resume(transaction);
        }
        catch (Exception e) {
            throw new JbpmException("couldn't resume: " + e.getMessage(), e);
        }
    }

    public UserTransaction lookupJeeUserTransaction() {
        return (UserTransaction)JtaTransaction.lookupFromJndi(this.userTransactionJndiName);
    }

    public Transaction lookupJeeTransaction() {
        try {
            TransactionManager transactionManager = this.lookupJeeTransactionManager();
            return transactionManager.getTransaction();
        }
        catch (Exception e) {
            throw new JbpmException("couldn't get transaction from transaction manager " + this.transactionManagerJndiName + ": " + e.getMessage(), e);
        }
    }

    public TransactionManager lookupJeeTransactionManager() {
        return (TransactionManager)JtaTransaction.lookupFromJndi(this.transactionManagerJndiName);
    }

    public static Object lookupFromJndi(String jndiName) {
        try {
            InitialContext initialContext = new InitialContext();
            return initialContext.lookup(jndiName);
        }
        catch (Exception e) {
            throw new JbpmException("couldn't lookup '" + jndiName + "' from jndi: " + e.getMessage() + ": " + e.getMessage(), e);
        }
    }

    public static int getUserTransactionStatus(UserTransaction userTransaction) {
        int status = -1;
        try {
            status = userTransaction.getStatus();
        }
        catch (SystemException e) {
            throw new JbpmException("couldn't get transaction status: " + e.getMessage(), e);
        }
        log.trace("jta transaction status: " + JtaStatusHelper.toString(status));
        return status;
    }

    public String getUserTransactionJndiName() {
        return this.userTransactionJndiName;
    }

    public String getTransactionManagerJndiName() {
        return this.transactionManagerJndiName;
    }
}

