/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.util;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jbpm.api.JbpmException;
import org.jbpm.pvm.internal.xml.Parse;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlUtil {
    private XmlUtil() {
    }

    public static List<Element> elements(Element element, String tagName) {
        if (element == null || !element.hasChildNodes()) {
            return Collections.emptyList();
        }
        ArrayList<Element> elements = new ArrayList<Element>();
        for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            Element childElement;
            String childTagName;
            if (child.getNodeType() != 1 || !tagName.equals(childTagName = (childElement = (Element)child).getLocalName())) continue;
            elements.add(childElement);
        }
        return elements;
    }

    public static List<Element> elements(Element element, Set<String> allowedTagNames) {
        if (element == null || !element.hasChildNodes()) {
            return Collections.emptyList();
        }
        ArrayList<Element> elements = new ArrayList<Element>();
        for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            Element childElement = (Element)child;
            if (!allowedTagNames.contains(child.getLocalName())) continue;
            elements.add(childElement);
        }
        return elements;
    }

    public static Element element(Element element, String tagName) {
        return XmlUtil.element(element, tagName, null);
    }

    public static Element element(Element element, String tagName, Parse parse) {
        if (element != null && element.hasChildNodes()) {
            for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getNodeType() != 1 || !tagName.equals(child.getLocalName())) continue;
                return (Element)child;
            }
        }
        if (parse != null) {
            parse.addProblem("missing element " + tagName, element);
        }
        return null;
    }

    public static List<Element> elements(Element element) {
        if (element == null || !element.hasChildNodes()) {
            return Collections.emptyList();
        }
        ArrayList<Element> elements = new ArrayList<Element>();
        for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            elements.add((Element)child);
        }
        return elements;
    }

    public static List<Element> elements(Element element, String namespace, String localName) {
        if (element == null || !element.hasChildNodes()) {
            return Collections.emptyList();
        }
        ArrayList<Element> elements = new ArrayList<Element>();
        for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            String childNamespace = element.getNamespaceURI();
            if (child.getNodeType() != 1 || !(namespace != null ? namespace.equals(childNamespace) : childNamespace == null) || !localName.equals(element.getLocalName())) continue;
            elements.add((Element)child);
        }
        return elements;
    }

    public static List<Element> elementsQName(Element element, Set<QName> allowedTagNames) {
        if (element == null || !element.hasChildNodes()) {
            return Collections.emptyList();
        }
        ArrayList<Element> elements = new ArrayList<Element>();
        for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            Element childElement;
            QName childQName;
            if (child.getNodeType() != 1 || !allowedTagNames.contains(childQName = new QName((childElement = (Element)child).getNamespaceURI(), childElement.getLocalName()))) continue;
            elements.add(childElement);
        }
        return elements;
    }

    public static Element element(Element element) {
        if (element != null && element.hasChildNodes()) {
            for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getNodeType() != 1) continue;
                return (Element)child;
            }
        }
        return null;
    }

    public static String toString(Node node) {
        if (node == null) {
            return "null";
        }
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            StringWriter stringWriter = new StringWriter();
            transformer.transform(new DOMSource(node), new StreamResult(stringWriter));
            return stringWriter.toString();
        }
        catch (TransformerException e) {
            throw new JbpmException("could not transform dom node to string", e);
        }
    }

    public static String getContentText(Element element) {
        return element.getTextContent();
    }

    public static boolean isTextOnly(Element element) {
        for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            return false;
        }
        return true;
    }

    public static List<Attr> attributes(Element element) {
        NamedNodeMap attributeMap = element.getAttributes();
        if (attributeMap == null || attributeMap.getLength() == 0) {
            return Collections.emptyList();
        }
        ArrayList<Attr> attributes = new ArrayList<Attr>();
        for (int i = 0; i < attributeMap.getLength(); ++i) {
            attributes.add((Attr)attributeMap.item(i));
        }
        return attributes;
    }

    public static List<Node> contents(Element element) {
        if (element == null || !element.hasChildNodes()) {
            return Collections.emptyList();
        }
        ArrayList<Node> contents = new ArrayList<Node>();
        for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            contents.add(child);
        }
        return contents;
    }

    public static String attribute(Element element, String attributeName) {
        Attr attribute = element.getAttributeNode(attributeName);
        return attribute != null ? attribute.getValue() : null;
    }

    public static String attribute(Element element, String attributeName, String defaultValue) {
        return XmlUtil.attribute(element, attributeName, null, defaultValue);
    }

    public static String attribute(Element element, String attributeName, Parse parse) {
        return XmlUtil.attribute(element, attributeName, parse, null);
    }

    public static String attribute(Element element, String attributeName, Parse parse, String defaultValue) {
        Attr attribute = element.getAttributeNode(attributeName);
        if (attribute != null) {
            String value = attribute.getValue();
            if (value.length() == 0) {
                parse.addProblem("attribute <" + element.getLocalName() + " " + attributeName + "=\"\" is empty", element);
            }
            return value;
        }
        if (parse != null) {
            parse.addProblem("attribute <" + element.getLocalName() + " " + attributeName + "=\"...\" is required", element);
        }
        return defaultValue;
    }

    public static Integer attributeInteger(Element element, String attributeName, Parse parse) {
        Attr attribute = element.getAttributeNode(attributeName);
        if (attribute != null) {
            String attributeValue = attribute.getValue();
            try {
                return Integer.parseInt(attributeValue);
            }
            catch (NumberFormatException e) {
                parse.addProblem(XmlUtil.errorMessageAttribute(element, attributeName, attributeValue, e.getMessage()), element);
            }
        }
        return null;
    }

    public static Boolean attributeBoolean(Element element, String attributeName, Parse parse) {
        Attr attribute = element.getAttributeNode(attributeName);
        if (attribute != null) {
            String attributeValue = attribute.getValue();
            Boolean value = XmlUtil.parseBooleanValue(attributeValue);
            if (value != null) {
                return value;
            }
            String message = XmlUtil.errorMessageAttribute(element, attributeName, attributeValue, "value not in {true, enabled, on, false, disabled, off}");
            parse.addProblem(message, element);
        }
        return null;
    }

    public static Boolean parseBooleanValue(String valueText) {
        if (valueText != null) {
            if ("true".equals(valueText) || "enabled".equals(valueText) || "on".equals(valueText)) {
                return Boolean.TRUE;
            }
            if ("false".equals(valueText) || "disabled".equals(valueText) || "off".equals(valueText)) {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    public static String errorMessageAttribute(Element element, String attributeName, String attributeValue, String message) {
        return "attribute <" + element.getLocalName() + " " + attributeName + "=\"" + attributeValue + "\" " + message;
    }

    public static List<String> parseList(Element element, String singularTagName) {
        String text = XmlUtil.attribute(element, singularTagName + "s");
        if ("*".equals(text)) {
            text = null;
        }
        if (element.hasAttribute(singularTagName)) {
            String eventText = element.getAttribute(singularTagName);
            text = text == null ? eventText : text + "," + eventText;
        }
        List<String> eventNames = XmlUtil.parseCommaSeparatedList(text);
        return eventNames;
    }

    public static List<String> parseCommaSeparatedList(String commaSeparatedListText) {
        ArrayList<String> entries = null;
        if (commaSeparatedListText != null && !"*".equals(commaSeparatedListText)) {
            StringTokenizer tokenizer = new StringTokenizer(commaSeparatedListText, ", ");
            while (tokenizer.hasMoreTokens()) {
                if (entries == null) {
                    entries = new ArrayList<String>();
                }
                entries.add(tokenizer.nextToken());
            }
        }
        return entries;
    }

    public static NamespaceValue attributeNamespaceValue(Element element, String attributeName) {
        NamespaceValue namespaceValue = null;
        String text = XmlUtil.attribute(element, attributeName);
        if (text != null) {
            int colonIndex = text.indexOf(58);
            if (colonIndex == -1) {
                namespaceValue = new NamespaceValue(null, text);
            } else {
                String prefix = text.substring(0, colonIndex);
                String localPart = null;
                if (text.length() > colonIndex + 1) {
                    localPart = text.substring(colonIndex + 1);
                }
                namespaceValue = new NamespaceValue(prefix, localPart);
            }
        }
        return namespaceValue;
    }

    public static QName attributeQName(Element element, String attributeName) {
        QName qname = null;
        NamespaceValue namespaceValue = XmlUtil.attributeNamespaceValue(element, attributeName);
        String text = XmlUtil.attribute(element, attributeName);
        if (namespaceValue != null) {
            if (namespaceValue.prefix == null) {
                qname = new QName(text);
            } else {
                String uri = element.lookupNamespaceURI(namespaceValue.prefix);
                if (uri == null) {
                    throw new JbpmException("unknown prefix in qname " + text);
                }
                if (namespaceValue.localPart == null) {
                    throw new JbpmException("no local part in qname " + text);
                }
                qname = new QName(uri, namespaceValue.localPart, namespaceValue.prefix);
            }
        }
        return qname;
    }

    public static QName getQNameFromString(Element element, String qnameAsString) {
        if (qnameAsString == null || element == null) {
            return null;
        }
        int colonIndex = qnameAsString.indexOf(":");
        String prefix = qnameAsString.substring(0, colonIndex);
        String localName = qnameAsString.substring(colonIndex + 1);
        String ns = XmlUtil.getNamespaceURI(element, prefix);
        return new QName(ns, localName, prefix);
    }

    public static String getNamespaceURI(Node n, String prefix) {
        Node prefixDeclaration = n.getAttributes().getNamedItem("xmlns:" + prefix);
        if (prefixDeclaration != null) {
            return prefixDeclaration.getNodeValue();
        }
        return XmlUtil.getNamespaceURI(n.getParentNode(), prefix);
    }

    public static class NamespaceValue {
        public String prefix;
        public String localPart;

        public NamespaceValue(String prefix, String localPart) {
            this.prefix = prefix;
            this.localPart = localPart;
        }
    }
}

