/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.wire;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jbpm.pvm.internal.env.UserProvidedEnvironmentObject;
import org.jbpm.pvm.internal.wire.Descriptor;
import org.jbpm.pvm.internal.wire.descriptor.AbstractDescriptor;
import org.jbpm.pvm.internal.wire.descriptor.ProvidedObjectDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WireDefinition
implements Serializable {
    private static final long serialVersionUID = 1L;
    Map<String, Descriptor> descriptors;
    Map<Class<?>, String> descriptorNames;
    boolean useTypes = true;
    List<String> eagerInitNames;

    public WireDefinition() {
    }

    public WireDefinition(WireDefinition other, List<UserProvidedEnvironmentObject> txWireObjects) {
        if (other.descriptors != null) {
            this.descriptors = new HashMap<String, Descriptor>(other.descriptors);
        }
        if (other.descriptorNames != null) {
            this.descriptorNames = new HashMap(other.descriptorNames);
        }
        if (other.eagerInitNames != null) {
            this.eagerInitNames = new ArrayList<String>(other.eagerInitNames);
        }
        this.useTypes = other.useTypes;
        for (UserProvidedEnvironmentObject userProvidedEnvironmentObject : txWireObjects) {
            ProvidedObjectDescriptor descriptor = new ProvidedObjectDescriptor(userProvidedEnvironmentObject.getObject(), userProvidedEnvironmentObject.isTypeExposed(), userProvidedEnvironmentObject.getName());
            this.addDescriptor(descriptor);
        }
    }

    public void addDescriptor(Descriptor descriptor) {
        if (descriptor != null) {
            Class<?> type;
            String name = descriptor.getName();
            if (this.useTypes && (type = descriptor.getType(this)) != null) {
                if (name == null && descriptor instanceof AbstractDescriptor) {
                    name = type.getName();
                    ((AbstractDescriptor)descriptor).setName(type.getName());
                }
                if (!(name == null || this.descriptors != null && this.descriptors.containsKey(name))) {
                    this.addDescriptorType(type, descriptor, name);
                }
            }
            if (name != null && !this.hasDescriptor(name)) {
                this.putDescriptor(name, descriptor);
                if (descriptor.isEagerInit()) {
                    this.addEagerInitObjectName(name);
                }
            }
        }
    }

    void putDescriptor(String name, Descriptor descriptor) {
        if (this.descriptors == null) {
            this.descriptors = new HashMap<String, Descriptor>();
        }
        this.descriptors.put(name, descriptor);
    }

    void addDescriptorType(Class<?> type, Descriptor descriptor, String descriptorName) {
        if (type != null) {
            if (this.descriptorNames == null) {
                this.descriptorNames = new HashMap();
            }
            if (!this.descriptorNames.containsKey(type)) {
                this.descriptorNames.put(type, descriptorName);
            }
            this.addDescriptorType(type.getSuperclass(), descriptor, descriptorName);
            Class<?>[] interfaceTypes = type.getInterfaces();
            if (interfaceTypes != null) {
                for (Class<?> interfaceType : interfaceTypes) {
                    this.addDescriptorType(interfaceType, descriptor, descriptorName);
                }
            }
        }
    }

    public String getDescriptorName(Class<?> type) {
        return this.descriptorNames != null ? this.descriptorNames.get(type) : null;
    }

    public Descriptor getDescriptor(String objectName) {
        if (this.descriptors == null) {
            return null;
        }
        return this.descriptors.get(objectName);
    }

    public synchronized Descriptor addDescriptor(String objectName, Descriptor descriptor) {
        if (this.descriptors == null) {
            this.descriptors = new HashMap<String, Descriptor>();
        }
        return this.descriptors.put(objectName, descriptor);
    }

    public synchronized Descriptor removeDescriptor(String objectName) {
        if (this.descriptors != null) {
            return this.descriptors.remove(objectName);
        }
        return null;
    }

    public boolean hasDescriptor(String objectName) {
        return this.descriptors != null && this.descriptors.containsKey(objectName);
    }

    public void addEagerInitObjectName(String eagerInitObjectName) {
        if (eagerInitObjectName != null) {
            if (this.eagerInitNames == null) {
                this.eagerInitNames = new ArrayList<String>();
            }
            this.eagerInitNames.add(eagerInitObjectName);
        }
    }

    public void addWireDefinition(WireDefinition wireDefinition) {
        if (wireDefinition != null && wireDefinition.getDescriptors() != null) {
            for (Descriptor descriptor : wireDefinition.getDescriptors().values()) {
                this.addDescriptor(descriptor);
            }
        }
    }

    public Set<Class<?>> getDescriptorTypes() {
        return this.descriptorNames != null ? this.descriptorNames.keySet() : null;
    }

    public Map<String, Descriptor> getDescriptors() {
        return this.descriptors;
    }

    public List<String> getEagerInitNames() {
        return this.eagerInitNames;
    }

    public void setEagerInitNames(List<String> eagerInitNames) {
        this.eagerInitNames = eagerInitNames;
    }

    public void setDescriptors(Map<String, Descriptor> descriptors) {
        this.descriptors = descriptors;
    }
}

