/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tendon.convert.json;

import com.tencent.tendon.convert.json.JsonAttribute;
import com.tencent.tendon.convert.json.JsonException;
import com.tencent.tendon.convert.json.JsonRef;
import com.tencent.tendon.convert.json.JsonXAttribute;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicInteger;
import sun.misc.Unsafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsonAttributes {
    private static final boolean canunsafe;

    private JsonAttributes() {
    }

    public static <T, V> JsonAttribute<T, V> createJsonAttribute(Method method) {
        if (method == null) {
            return null;
        }
        JsonRef jsonRef = method.getAnnotation(JsonRef.class);
        Class<?> clazz = method.getDeclaringClass();
        Class clazz2 = JsonAttributes.findFieldType(method);
        JsonAttribute<T, V> jsonAttribute = null;
        if (canunsafe && (jsonRef == null || !jsonRef.indirect())) {
            try {
                Field field = null;
                Class<?> clazz3 = clazz;
                while (true) {
                    try {
                        String string = method.getName().substring(method.getName().startsWith("is") ? 2 : 3);
                        if (string.length() > 1 && (string.charAt(1) < 'A' || string.charAt(1) > 'Z')) {
                            string = Character.toLowerCase(string.charAt(0)) + string.substring(1);
                        } else if (string.length() == 1) {
                            string = "" + Character.toLowerCase(string.charAt(0));
                        }
                        field = clazz3.getDeclaredField(string);
                    }
                    catch (Exception exception) {
                        if ((clazz3 = clazz3.getSuperclass()) != Object.class) continue;
                    }
                    break;
                }
                if (field != null) {
                    return SunUnsafe.createJsonAttribute(field);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        if (jsonAttribute != null) {
            return jsonAttribute;
        }
        if (clazz2.isPrimitive() || clazz2 == String.class) {
            return new JsonReflectMethodJsonXAttribute(method);
        }
        return new JsonReflectMethodJsonAttribute(method);
    }

    public static <T, V> JsonAttribute<T, V> createJsonAttribute(Field field) {
        if (field == null) {
            return null;
        }
        if (canunsafe) {
            return SunUnsafe.createJsonAttribute(field);
        }
        Class clazz = JsonAttributes.findFieldType(field);
        if (clazz.isPrimitive() || clazz == String.class) {
            return new JsonReflectFieldJsonXAttribute(field);
        }
        return new JsonReflectFieldJsonAttribute(field);
    }

    static String findFieldName(Method method) {
        String string;
        JsonRef jsonRef = method.getAnnotation(JsonRef.class);
        if (jsonRef != null && jsonRef.alias().length() > 0) {
            return jsonRef.alias();
        }
        String string2 = string.substring((string = method.getName()).startsWith("is") ? 2 : 3);
        if (string2.length() > 1 && string2.charAt(1) >= 'A' && string2.charAt(1) <= 'Z') {
            return string2;
        }
        if (string2.length() > 0) {
            return Character.toLowerCase(string2.charAt(0)) + string2.substring(1);
        }
        return string2;
    }

    static String findFieldName(Field field) {
        JsonRef jsonRef = field.getAnnotation(JsonRef.class);
        if (jsonRef != null && jsonRef.alias().length() > 0) {
            return jsonRef.alias();
        }
        return field.getName();
    }

    static <E> Class<E> findFieldType(Method method) {
        JsonRef jsonRef = method.getAnnotation(JsonRef.class);
        if (jsonRef != null && jsonRef.type() != Void.TYPE) {
            return jsonRef.type();
        }
        return method.getName().startsWith("set") ? method.getParameterTypes()[0] : method.getReturnType();
    }

    static <E> Class<E> findFieldType(Field field) {
        JsonRef jsonRef = field.getAnnotation(JsonRef.class);
        if (jsonRef != null && jsonRef.type() != Void.TYPE) {
            return jsonRef.type();
        }
        return field.getType();
    }

    static {
        boolean bl = false;
        try {
            Class.forName("sun.misc.Unsafe");
            bl = AtomicInteger.class.getDeclaredField("unsafe") != null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        canunsafe = bl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JsonSunAttribute<T, V>
    implements JsonAttribute<T, V> {
        private static final Unsafe unsafe = SunUnsafe.access$000();
        private final String fieldname;
        protected final long offset;

        public JsonSunAttribute(String string, long l) {
            this.offset = l;
            this.fieldname = string;
        }

        @Override
        public String field() {
            return this.fieldname;
        }

        @Override
        public final V get(T t) {
            return (V)unsafe.getObject(t, this.offset);
        }

        @Override
        public final void set(T t, V v) {
            unsafe.putObject(t, this.offset, v);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JsonSunXAttribute<T>
    extends JsonXAttribute<T> {
        private static final Unsafe unsafe = SunUnsafe.access$000();
        protected final String fieldname;
        protected final long offset;

        public JsonSunXAttribute(String string, long l) {
            this.offset = l;
            this.fieldname = string;
        }

        @Override
        public String field() {
            return this.fieldname;
        }

        @Override
        public final boolean getBoolean(T t) {
            return unsafe.getBoolean(t, this.offset);
        }

        @Override
        public final void setBoolean(T t, boolean bl) {
            unsafe.putBoolean(t, this.offset, bl);
        }

        @Override
        public final byte getByte(T t) {
            return unsafe.getByte(t, this.offset);
        }

        @Override
        public final void setByte(T t, byte by) {
            unsafe.putByte(t, this.offset, by);
        }

        @Override
        public final short getShort(T t) {
            return unsafe.getShort(t, this.offset);
        }

        @Override
        public final void setShort(T t, short s) {
            unsafe.putShort(t, this.offset, s);
        }

        @Override
        public final char getChar(T t) {
            return unsafe.getChar(t, this.offset);
        }

        @Override
        public final void setChar(T t, char c) {
            unsafe.putChar(t, this.offset, c);
        }

        @Override
        public final int getInt(T t) {
            return unsafe.getInt(t, this.offset);
        }

        @Override
        public final void setInt(T t, int n) {
            unsafe.putInt(t, this.offset, n);
        }

        @Override
        public final float getFloat(T t) {
            return unsafe.getFloat(t, this.offset);
        }

        @Override
        public final void setFloat(T t, float f) {
            unsafe.putFloat(t, this.offset, f);
        }

        @Override
        public final long getLong(T t) {
            return unsafe.getLong(t, this.offset);
        }

        @Override
        public final void setLong(T t, long l) {
            unsafe.putLong(t, this.offset, l);
        }

        @Override
        public final double getDouble(T t) {
            return unsafe.getDouble(t, this.offset);
        }

        @Override
        public final void setDouble(T t, double d) {
            unsafe.putDouble(t, this.offset, d);
        }

        @Override
        public final String getString(T t) {
            return (String)unsafe.getObject(t, this.offset);
        }

        @Override
        public final void setString(T t, String string) {
            unsafe.putObject(t, this.offset, string);
        }
    }

    private static final class SunUnsafe {
        private static final Unsafe unsafe;

        private SunUnsafe() {
        }

        public static JsonAttribute createJsonAttribute(Field field) {
            long l = unsafe.objectFieldOffset(field);
            Class<?> clazz = field.getType();
            if (clazz.isPrimitive() || clazz == String.class) {
                return new JsonSunXAttribute(JsonAttributes.findFieldName(field), l);
            }
            return new JsonSunAttribute(JsonAttributes.findFieldName(field), l);
        }

        static /* synthetic */ Unsafe access$000() {
            return unsafe;
        }

        static {
            Object object = null;
            try {
                Field field = AtomicInteger.class.getDeclaredField("unsafe");
                field.setAccessible(true);
                object = field.get(null);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            unsafe = (Unsafe)object;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JsonReflectFieldJsonXAttribute<T>
    extends JsonXAttribute<T> {
        private final String fieldname;
        private final Field field;

        public JsonReflectFieldJsonXAttribute(Field field) {
            this.field = field;
            this.fieldname = JsonAttributes.findFieldName(field);
        }

        @Override
        public String field() {
            return this.fieldname;
        }

        @Override
        public final boolean getBoolean(T t) {
            try {
                return (Boolean)this.field.get(t);
            }
            catch (Exception exception) {
                throw new JsonException("get value from object(" + t + ") error for field (" + this.field + ") ", exception);
            }
        }

        @Override
        public final void setBoolean(T t, boolean bl) {
            try {
                this.field.set(t, bl);
            }
            catch (Exception exception) {
                throw new JsonException("set value to object(" + t + ") error for field (" + this.field + ") ", exception);
            }
        }

        @Override
        public final byte getByte(T t) {
            try {
                return (Byte)this.field.get(t);
            }
            catch (Exception exception) {
                throw new JsonException("get value from object(" + t + ") error for field (" + this.field + ") ", exception);
            }
        }

        @Override
        public final void setByte(T t, byte by) {
            try {
                this.field.set(t, by);
            }
            catch (Exception exception) {
                throw new JsonException("set value to object(" + t + ") error for field (" + this.field + ") ", exception);
            }
        }

        @Override
        public final short getShort(T t) {
            try {
                return (Short)this.field.get(t);
            }
            catch (Exception exception) {
                throw new JsonException("get value from object(" + t + ") error for field (" + this.field + ") ", exception);
            }
        }

        @Override
        public final void setShort(T t, short s) {
            try {
                this.field.set(t, s);
            }
            catch (Exception exception) {
                throw new JsonException("set value to object(" + t + ") error for field (" + this.field + ") ", exception);
            }
        }

        @Override
        public final char getChar(T t) {
            try {
                return ((Character)this.field.get(t)).charValue();
            }
            catch (Exception exception) {
                throw new JsonException("get value from object(" + t + ") error for field (" + this.field + ") ", exception);
            }
        }

        @Override
        public final void setChar(T t, char c) {
            try {
                this.field.set(t, Character.valueOf(c));
            }
            catch (Exception exception) {
                throw new JsonException("set value to object(" + t + ") error for field (" + this.field + ") ", exception);
            }
        }

        @Override
        public final int getInt(T t) {
            try {
                return (Integer)this.field.get(t);
            }
            catch (Exception exception) {
                throw new JsonException("get value from object(" + t + ") error for field (" + this.field + ") ", exception);
            }
        }

        @Override
        public final void setInt(T t, int n) {
            try {
                this.field.set(t, n);
            }
            catch (Exception exception) {
                throw new JsonException("set value to object(" + t + ") error for field (" + this.field + ") ", exception);
            }
        }

        @Override
        public final float getFloat(T t) {
            try {
                return ((Float)this.field.get(t)).floatValue();
            }
            catch (Exception exception) {
                throw new JsonException("get value from object(" + t + ") error for field (" + this.field + ") ", exception);
            }
        }

        @Override
        public final void setFloat(T t, float f) {
            try {
                this.field.set(t, Float.valueOf(f));
            }
            catch (Exception exception) {
                throw new JsonException("set value to object(" + t + ") error for field (" + this.field + ") ", exception);
            }
        }

        @Override
        public final long getLong(T t) {
            try {
                return (Long)this.field.get(t);
            }
            catch (Exception exception) {
                throw new JsonException("get value from object(" + t + ") error for field (" + this.field + ") ", exception);
            }
        }

        @Override
        public final void setLong(T t, long l) {
            try {
                this.field.set(t, l);
            }
            catch (Exception exception) {
                throw new JsonException("set value to object(" + t + ") error for field (" + this.field + ") ", exception);
            }
        }

        @Override
        public final double getDouble(T t) {
            try {
                return (Double)this.field.get(t);
            }
            catch (Exception exception) {
                throw new JsonException("get value from object(" + t + ") error for field (" + this.field + ") ", exception);
            }
        }

        @Override
        public final void setDouble(T t, double d) {
            try {
                this.field.set(t, d);
            }
            catch (Exception exception) {
                throw new JsonException("set value to object(" + t + ") error for field (" + this.field + ") ", exception);
            }
        }

        @Override
        public final String getString(T t) {
            try {
                return (String)this.field.get(t);
            }
            catch (Exception exception) {
                throw new JsonException("get value from object(" + t + ") error for field (" + this.field + ") ", exception);
            }
        }

        @Override
        public final void setString(T t, String string) {
            try {
                this.field.set(t, string);
            }
            catch (Exception exception) {
                throw new JsonException("set value to object(" + t + ") error for field (" + this.field + ") ", exception);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JsonReflectMethodJsonXAttribute<T>
    extends JsonXAttribute<T> {
        private final String fieldname;
        private final Method method;

        public JsonReflectMethodJsonXAttribute(Method method) {
            this.method = method;
            this.fieldname = JsonAttributes.findFieldName(method);
        }

        @Override
        public String field() {
            return this.fieldname;
        }

        @Override
        public final boolean getBoolean(T t) {
            try {
                return (Boolean)this.method.invoke(t, new Object[0]);
            }
            catch (Exception exception) {
                throw new JsonException("get value from object(" + t + ") error for method (" + this.method + ") ", exception);
            }
        }

        @Override
        public final void setBoolean(T t, boolean bl) {
            try {
                this.method.invoke(t, bl);
            }
            catch (Exception exception) {
                throw new JsonException("set value to object(" + t + ") error for method (" + this.method + ") ", exception);
            }
        }

        @Override
        public final byte getByte(T t) {
            try {
                return (Byte)this.method.invoke(t, new Object[0]);
            }
            catch (Exception exception) {
                throw new JsonException("get value from object(" + t + ") error for method (" + this.method + ") ", exception);
            }
        }

        @Override
        public final void setByte(T t, byte by) {
            try {
                this.method.invoke(t, by);
            }
            catch (Exception exception) {
                throw new JsonException("set value to object(" + t + ") error for method (" + this.method + ") ", exception);
            }
        }

        @Override
        public final short getShort(T t) {
            try {
                return (Short)this.method.invoke(t, new Object[0]);
            }
            catch (Exception exception) {
                throw new JsonException("get value from object(" + t + ") error for method (" + this.method + ") ", exception);
            }
        }

        @Override
        public final void setShort(T t, short s) {
            try {
                this.method.invoke(t, s);
            }
            catch (Exception exception) {
                throw new JsonException("set value to object(" + t + ") error for method (" + this.method + ") ", exception);
            }
        }

        @Override
        public final char getChar(T t) {
            try {
                return ((Character)this.method.invoke(t, new Object[0])).charValue();
            }
            catch (Exception exception) {
                throw new JsonException("get value from object(" + t + ") error for method (" + this.method + ") ", exception);
            }
        }

        @Override
        public final void setChar(T t, char c) {
            try {
                this.method.invoke(t, Character.valueOf(c));
            }
            catch (Exception exception) {
                throw new JsonException("set value to object(" + t + ") error for method (" + this.method + ") ", exception);
            }
        }

        @Override
        public final int getInt(T t) {
            try {
                return (Integer)this.method.invoke(t, new Object[0]);
            }
            catch (Exception exception) {
                throw new JsonException("get value from object(" + t + ") error for method (" + this.method + ") ", exception);
            }
        }

        @Override
        public final void setInt(T t, int n) {
            try {
                this.method.invoke(t, n);
            }
            catch (Exception exception) {
                throw new JsonException("set value to object(" + t + ") error for method (" + this.method + ") ", exception);
            }
        }

        @Override
        public final float getFloat(T t) {
            try {
                return ((Float)this.method.invoke(t, new Object[0])).floatValue();
            }
            catch (Exception exception) {
                throw new JsonException("get value from object(" + t + ") error for method (" + this.method + ") ", exception);
            }
        }

        @Override
        public final void setFloat(T t, float f) {
            try {
                this.method.invoke(t, Float.valueOf(f));
            }
            catch (Exception exception) {
                throw new JsonException("set value to object(" + t + ") error for method (" + this.method + ") ", exception);
            }
        }

        @Override
        public final long getLong(T t) {
            try {
                return (Long)this.method.invoke(t, new Object[0]);
            }
            catch (Exception exception) {
                throw new JsonException("get value from object(" + t + ") error for method (" + this.method + ") ", exception);
            }
        }

        @Override
        public final void setLong(T t, long l) {
            try {
                this.method.invoke(t, l);
            }
            catch (Exception exception) {
                throw new JsonException("set value to object(" + t + ") error for method (" + this.method + ") ", exception);
            }
        }

        @Override
        public final double getDouble(T t) {
            try {
                return (Double)this.method.invoke(t, new Object[0]);
            }
            catch (Exception exception) {
                throw new JsonException("get value from object(" + t + ") error for method (" + this.method + ") ", exception);
            }
        }

        @Override
        public final void setDouble(T t, double d) {
            try {
                this.method.invoke(t, d);
            }
            catch (Exception exception) {
                throw new JsonException("set value to object(" + t + ") error for method (" + this.method + ") ", exception);
            }
        }

        @Override
        public final String getString(T t) {
            try {
                return (String)this.method.invoke(t, new Object[0]);
            }
            catch (Exception exception) {
                throw new JsonException("get value from object(" + t + ") error for method (" + this.method + ") ", exception);
            }
        }

        @Override
        public final void setString(T t, String string) {
            try {
                this.method.invoke(t, string);
            }
            catch (Exception exception) {
                throw new JsonException("set value to object(" + t + ") error for method (" + this.method + ") ", exception);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JsonReflectFieldJsonAttribute<T, V>
    implements JsonAttribute<T, V> {
        private final String fieldname;
        private final Field field;

        public JsonReflectFieldJsonAttribute(Field field) {
            this.field = field;
            this.fieldname = JsonAttributes.findFieldName(field);
        }

        @Override
        public final V get(T t) {
            try {
                return (V)this.field.get(t);
            }
            catch (Exception exception) {
                throw new JsonException("get value from object(" + t + ") error for field (" + this.field + ") ", exception);
            }
        }

        @Override
        public final void set(T t, V v) {
            try {
                this.field.set(t, v);
            }
            catch (Exception exception) {
                throw new JsonException("set value to object(" + t + ") error for field (" + this.field + ") ", exception);
            }
        }

        @Override
        public String field() {
            return this.fieldname;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JsonReflectMethodJsonAttribute<T, V>
    implements JsonAttribute<T, V> {
        private final String fieldname;
        private final Method method;

        public JsonReflectMethodJsonAttribute(Method method) {
            this.method = method;
            this.fieldname = JsonAttributes.findFieldName(method);
        }

        @Override
        public final V get(T t) {
            try {
                return (V)this.method.invoke(t, new Object[0]);
            }
            catch (Exception exception) {
                throw new JsonException("get value from object(" + t + ") error for method (" + this.method + ") ", exception);
            }
        }

        @Override
        public final void set(T t, V v) {
            try {
                this.method.invoke(t, v);
            }
            catch (Exception exception) {
                throw new JsonException("set value to object(" + t + ") error for method (" + this.method + ") ", exception);
            }
        }

        @Override
        public String field() {
            return this.fieldname;
        }
    }
}

