/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tendon.convert.json;

import com.tencent.tendon.convert.json.JsonPoolable;

public final class JsonCharArray
implements JsonPoolable {
    private transient char[] data;
    private int size;

    public JsonCharArray() {
        this(64);
    }

    public JsonCharArray(int n) {
        this.data = new char[n];
    }

    public JsonCharArray(char ... cArray) {
        this.data = cArray;
        this.size = cArray.length;
    }

    private void expand(int n) {
        char[] cArray = new char[this.data.length + n];
        System.arraycopy(this.data, 0, cArray, 0, this.size);
        this.data = cArray;
    }

    public final char get(int n) {
        return this.data[n];
    }

    public final void append(char c) {
        if (this.size + 1 >= this.data.length) {
            this.expand(16);
        }
        this.data[this.size++] = c;
    }

    public final void append(char[] cArray, int n, int n2) {
        if (this.size + n2 >= this.data.length) {
            this.expand(n2 + 16);
        }
        System.arraycopy(cArray, n, this.data, this.size, n2);
        this.size += n2;
    }

    public final char[] toArray() {
        if (this.size == this.data.length) {
            return this.data;
        }
        char[] cArray = new char[this.size];
        System.arraycopy(this.data, 0, cArray, 0, this.size);
        return cArray;
    }

    public final int size() {
        return this.size;
    }

    public final String toString() {
        return new String(this.data, 0, this.size);
    }

    public final void prepare() {
        this.size = 0;
    }

    public final void release() {
        this.size = 0;
        if (this.data.length > 64) {
            this.data = new char[64];
        }
    }

    public final void clear() {
        this.size = 0;
    }
}

