/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tendon.convert.json;

import com.tencent.tendon.convert.json.JsonCharArray;
import com.tencent.tendon.convert.json.JsonDeHandle;
import com.tencent.tendon.convert.json.JsonException;
import com.tencent.tendon.convert.json.JsonListener;
import com.tencent.tendon.convert.json.JsonPool;
import com.tencent.tendon.convert.json.JsonReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsonDefaultReader
extends JsonReader {
    private char[] text;
    private int limit;

    public JsonDefaultReader(String string) {
        this.text = string.toCharArray();
    }

    public JsonDefaultReader(char[] cArray) {
        this.text = cArray;
    }

    public JsonDefaultReader(char[] cArray, int n, int n2) {
        this.text = cArray;
        this.position = n - 1;
        this.limit = n + n2 - 1;
    }

    public final void text(char[] cArray) {
        this.text = cArray;
        this.position = -1;
        this.limit = cArray.length - 1;
    }

    public final void text(char[] cArray, int n, int n2) {
        this.text = cArray;
        this.position = n - 1;
        this.limit = n + n2 - 1;
    }

    @Override
    public void prepare() {
    }

    @Override
    public void release() {
        this.limit = -1;
        this.position = -1;
        this.text = null;
        if (this.stack != null) {
            JsonPool.offer(this.stack);
        }
    }

    @Override
    public void close() {
        JsonPool.offer(this);
    }

    public final void position(int n) {
        this.position = n;
    }

    @Override
    protected char nextChar() {
        return this.text[++this.position];
    }

    @Override
    public void checkObject() {
        char c;
        if ((c = this.text[++this.position]) == '{') {
            return;
        }
        if (c <= ' ') {
            while ((c = this.text[++this.position]) <= ' ') {
            }
            if (c == '{') {
                return;
            }
        }
        throw new JsonException("a json object text must begin with '{' (position = " + this.position + ")");
    }

    @Override
    public boolean checkArray() {
        char c;
        if ((c = this.text[++this.position]) == '[') {
            return true;
        }
        if (c == '{') {
            return false;
        }
        if (c <= ' ') {
            while ((c = this.text[++this.position]) <= ' ') {
            }
            if (c == '[') {
                return true;
            }
            if (c == '{') {
                return false;
            }
        }
        throw new JsonException("a json array text must begin with '[' (position = " + this.position + ")");
    }

    @Override
    public void checkColon() {
        char c;
        if ((c = this.text[++this.position]) == ':') {
            return;
        }
        if (c <= ' ') {
            while ((c = this.text[++this.position]) <= ' ') {
            }
            if (c == ':') {
                return;
            }
        }
        throw new JsonException("expected a ':' after a key (position = " + this.position + ")");
    }

    @Override
    public boolean hasNext() {
        char c;
        if ((c = this.text[++this.position]) == ',') {
            return true;
        }
        if (c == '}' || c == ']') {
            return false;
        }
        if (c <= ' ') {
            while ((c = this.text[++this.position]) <= ' ') {
            }
            if (c == ',') {
                return true;
            }
            if (c == '}' || c == ']') {
                return false;
            }
        }
        --this.position;
        return true;
    }

    @Override
    protected void back(char c) {
        --this.position;
    }

    @Override
    public final JsonDeHandle readField(JsonDeHandle jsonDeHandle) {
        JsonDeHandle jsonDeHandle2;
        int n;
        char c;
        char[] cArray = this.text;
        char[] cArray2 = jsonDeHandle.fields;
        int n2 = this.position;
        if ((c = cArray[++n2]) <= ' ') {
            while ((c = cArray[++n2]) <= ' ') {
            }
        }
        int n3 = cArray2.length;
        int n4 = 0;
        int n5 = n2;
        if (c == '\"' || c == '\'') {
            ++n5;
            while ((n = cArray[++n2]) != c) {
                if (n4 >= n3 || n != cArray2[n4]) {
                    n4 = n3;
                }
                ++n4;
            }
            this.position = n2;
            if (n4 == n3) {
                return jsonDeHandle;
            }
        } else {
            ++n4;
            while ((n = cArray[++n2]) != 58 && n != 125 && n != 93 && n != 44 && n > 32) {
                if (n4 >= n3 || n != cArray2[n4]) {
                    n4 = n3;
                }
                ++n4;
            }
            this.position = n2 - 1;
            if (n4 == n3) {
                return jsonDeHandle;
            }
        }
        if ((jsonDeHandle2 = jsonDeHandle.find(cArray, n5, n = n2 - n5)) == null && n == 1 && cArray[n5] == '@') {
            return JsonDeHandle.REFER;
        }
        return jsonDeHandle2;
    }

    @Override
    public final char[] readValue() {
        char c;
        int n = this.limit;
        if (this.position == n) {
            return null;
        }
        char[] cArray = this.text;
        int n2 = this.position;
        if ((c = cArray[++n2]) <= ' ') {
            while ((c = cArray[++n2]) <= ' ') {
            }
        }
        if (c == '\"' || c == '\'') {
            char c2 = c;
            int n3 = n2 + 1;
            do {
                if ((c = cArray[++n2]) != '\\') continue;
                this.position = n2 - 1;
                return this.readEscapeValue(c2, n3);
            } while (c != c2);
            this.position = n2;
            char[] cArray2 = new char[n2 - n3];
            System.arraycopy(cArray, n3, cArray2, 0, cArray2.length);
            return cArray2;
        }
        int n4 = n2;
        while (n2 != n && (c = cArray[++n2]) != ',' && c != ']' && c != '}' && c > ' ' && c != ':') {
        }
        int n5 = n2 - n4;
        if (n5 < 1) {
            this.position = n2;
            return new char[]{c};
        }
        this.position = n2 - 1;
        if (n5 == 4 && cArray[n4] == 'n' && cArray[n4 + 1] == 'u' && cArray[n4 + 2] == 'l' && cArray[n4 + 3] == 'l') {
            return null;
        }
        char[] cArray3 = new char[n5];
        System.arraycopy(cArray, n4, cArray3, 0, n5);
        return cArray3;
    }

    @Override
    public <T> T readValue(JsonListener<T> jsonListener) {
        char c;
        int n = this.limit;
        if (this.position == n) {
            return jsonListener.convertFrom(null, -1, -1);
        }
        char[] cArray = this.text;
        int n2 = this.position;
        if ((c = cArray[++n2]) <= ' ') {
            while ((c = cArray[++n2]) <= ' ') {
            }
        }
        if (c == '\"' || c == '\'') {
            char c2 = c;
            int n3 = n2 + 1;
            do {
                if ((c = cArray[++n2]) != '\\') continue;
                this.position = n2 - 1;
                char[] cArray2 = this.readEscapeValue(c2, n3);
                return jsonListener.convertFrom(cArray2, 0, cArray2.length);
            } while (c != c2);
            this.position = n2;
            return jsonListener.convertFrom(cArray, n3, n2 - n3);
        }
        int n4 = n2;
        while (n2 != n && (c = cArray[++n2]) != ',' && c != ']' && c != '}' && c > ' ' && c != ':') {
        }
        int n5 = n2 - n4;
        if (n5 < 1) {
            this.position = n2;
            return jsonListener.convertFrom(new char[]{c}, 0, 1);
        }
        this.position = n2 - 1;
        if (n5 == 4 && cArray[n4] == 'n' && cArray[n4 + 1] == 'u' && cArray[n4 + 2] == 'l' && cArray[n4 + 3] == 'l') {
            return jsonListener.convertFrom(null, -1, -1);
        }
        return jsonListener.convertFrom(cArray, n4, n5);
    }

    @Override
    protected final long readLong() {
        char c;
        boolean bl;
        char c2;
        char[] cArray = this.text;
        int n = this.limit;
        int n2 = this.position;
        if ((c2 = cArray[++n2]) <= ' ') {
            while ((c2 = cArray[++n2]) <= ' ') {
            }
        }
        long l = 0L;
        boolean bl2 = bl = c2 == '-';
        if (!bl) {
            if (c2 < '0' || c2 > '9') {
                throw new NumberFormatException("illegal escape(" + c2 + ") (position = " + n2 + ")");
            }
            l = c2 - 48;
        }
        while (n2 != n && (c = cArray[++n2]) != ',' && c != '}' && c != ']' && c > ' ' && c != ':') {
            if (c < '0' || c > '9') {
                throw new NumberFormatException("illegal escape(" + c + ") (position = " + n2 + ")");
            }
            l = (l << 3) + (l << 1) + (long)(c - 48);
        }
        this.position = n2 - 1;
        return bl ? -l : l;
    }

    @Override
    protected final int readInt() {
        char c;
        boolean bl;
        char c2;
        char[] cArray = this.text;
        int n = this.limit;
        int n2 = this.position;
        if ((c2 = cArray[++n2]) <= ' ') {
            while ((c2 = cArray[++n2]) <= ' ') {
            }
        }
        int n3 = 0;
        boolean bl2 = bl = c2 == '-';
        if (!bl) {
            if (c2 < '0' || c2 > '9') {
                throw new NumberFormatException("illegal escape(" + c2 + ") (position = " + n2 + ")");
            }
            n3 = c2 - 48;
        }
        while (n2 != n && (c = cArray[++n2]) != ',' && c != '}' && c != ']' && c > ' ' && c != ':') {
            if (c < '0' || c > '9') {
                throw new NumberFormatException("illegal escape(" + c + ") (position = " + n2 + ")");
            }
            n3 = (n3 << 3) + (n3 << 1) + (c - 48);
        }
        this.position = n2 - 1;
        return bl ? -n3 : n3;
    }

    @Override
    protected String readString() {
        char c;
        char c2;
        char[] cArray = this.text;
        int n = this.position;
        if ((c2 = cArray[++n]) <= ' ') {
            while ((c2 = cArray[++n]) <= ' ') {
            }
        }
        if (c2 != '\"' && c2 != '\'') {
            if (c2 == 'n' && cArray.length > n + 3 && cArray[++n] == 'u' && cArray[++n] == 'l' && cArray[++n] == 'l') {
                this.position = n;
                if (cArray.length > n + 4) {
                    char c3 = cArray[n + 1];
                    if (c3 == ',' || c3 <= ' ' || c3 == '}' || c3 == ']' || c3 == ':') {
                        return null;
                    }
                } else {
                    return null;
                }
            }
            this.position = n;
            throw new JsonException("expected a ':' after a key but '" + cArray[this.position] + "' (position = " + this.position + ")");
        }
        int n2 = ++n;
        while ((c = cArray[n]) != c2) {
            if (c == '\\') {
                this.position = n - 1;
                return new String(this.readEscapeValue(c2, n2));
            }
            ++n;
        }
        this.position = n;
        return new String(cArray, n2, n - n2);
    }

    private char[] readEscapeValue(char c, int n) {
        JsonCharArray jsonCharArray = JsonPool.pollJsonCharArray();
        char[] cArray = this.text;
        int n2 = this.position;
        jsonCharArray.append(cArray, n, n2 + 1 - n);
        block9: while (true) {
            char c2;
            if ((c2 = cArray[++n2]) == c) {
                this.position = n2;
                char[] cArray2 = jsonCharArray.toArray();
                JsonPool.offer(jsonCharArray);
                return cArray2;
            }
            if (c2 == '\\') {
                c2 = cArray[++n2];
                switch (c2) {
                    case '\"': 
                    case '\'': 
                    case '/': 
                    case '\\': {
                        jsonCharArray.append(c2);
                        continue block9;
                    }
                    case 'n': {
                        jsonCharArray.append('\n');
                        continue block9;
                    }
                    case 'r': {
                        jsonCharArray.append('\r');
                        continue block9;
                    }
                    case 'u': {
                        jsonCharArray.append((char)Integer.parseInt(new String(new char[]{cArray[++n2], cArray[++n2], cArray[++n2], cArray[++n2]}), 16));
                        continue block9;
                    }
                    case 't': {
                        jsonCharArray.append('\t');
                        continue block9;
                    }
                    case 'b': {
                        jsonCharArray.append('\b');
                        continue block9;
                    }
                    case 'f': {
                        jsonCharArray.append('\f');
                        continue block9;
                    }
                }
                this.position = n2;
                throw new JsonException("illegal escape(" + c2 + ") (position = " + this.position + ")");
            }
            jsonCharArray.append(c2);
        }
    }
}

