/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tendon.convert.json;

import com.tencent.tendon.convert.json.JsonCreatable;
import com.tencent.tendon.convert.json.JsonDeHandle;
import com.tencent.tendon.convert.json.JsonFactory;
import com.tencent.tendon.convert.json.JsonObjectToken;
import com.tencent.tendon.convert.json.JsonReader;
import com.tencent.tendon.convert.json.JsonReferToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsonDefaultToken<T>
extends JsonObjectToken<T> {
    protected final Class<T> type;
    protected final JsonCreatable<T> creator;
    protected boolean simpled;
    protected JsonDeHandle head;

    JsonDefaultToken(Class<T> clazz) {
        this.type = clazz;
        this.creator = JsonFactory.loadJsonCreator(clazz);
        this.head = JsonDeHandle.NULL;
    }

    public JsonDefaultToken(Class<T> clazz, JsonDeHandle jsonDeHandle) {
        this.type = clazz;
        this.creator = JsonFactory.loadJsonCreator(clazz);
        this.head = jsonDeHandle;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{type:" + this.type.getSimpleName() + ", simpled:" + this.simpled + ",\r\n   next:" + this.head + "}";
    }

    @Override
    public T convertFrom(JsonReader jsonReader) {
        JsonDeHandle jsonDeHandle = this.head;
        jsonReader.checkObject();
        T t = this.creator.create();
        if (!this.simpled) {
            jsonReader.offer(t);
        }
        while (jsonReader.hasNext()) {
            if (jsonDeHandle == null) {
                jsonDeHandle = this.head;
            }
            JsonDeHandle jsonDeHandle2 = jsonReader.readField(jsonDeHandle);
            jsonReader.checkColon();
            if (jsonDeHandle2 == null) {
                jsonReader.skipValue();
                continue;
            }
            if (jsonDeHandle2 == JsonDeHandle.REFER) {
                if (!this.simpled) {
                    jsonReader.poll();
                }
                return (T)JsonReferToken.instance.convertReferFrom(jsonReader);
            }
            jsonDeHandle = jsonDeHandle2.next;
            jsonDeHandle2.set(jsonReader, t);
        }
        if (!this.simpled) {
            jsonReader.poll();
        }
        return t;
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public boolean isSimpled() {
        return this.simpled;
    }
}

