/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tendon.convert.json;

import com.tencent.tendon.convert.json.JsonPool;
import com.tencent.tendon.convert.json.JsonPoolable;
import com.tencent.tendon.convert.json.JsonWriter;

public final class JsonDefaultWriter
extends JsonWriter
implements JsonPoolable {
    private char[] content;

    public JsonDefaultWriter() {
        this(32);
    }

    public JsonDefaultWriter(int n) {
        this.content = new char[n > 32 ? n : 32];
    }

    public char[] expand(int n) {
        int n2 = this.count + n;
        if (n2 <= this.content.length) {
            return this.content;
        }
        char[] cArray = new char[Math.max(this.content.length * 3 / 2, n2)];
        System.arraycopy(this.content, 0, cArray, 0, this.count);
        this.content = cArray;
        return cArray;
    }

    public void write(char c) {
        this.expand(1);
        this.content[this.count++] = c;
    }

    public void write(char ... cArray) {
        int n = cArray.length;
        this.expand(n);
        System.arraycopy(cArray, 0, this.content, this.count, n);
        this.count += n;
    }

    public void write(char[] cArray, int n, int n2) {
        int n3 = n2 - n;
        this.expand(n3);
        System.arraycopy(cArray, n, this.content, this.count, n3);
        this.count += n3;
    }

    public boolean indirect() {
        return false;
    }

    public void write(boolean bl, String string) {
        int n = string.length();
        this.expand(n + (bl ? 2 : 0));
        if (bl) {
            this.content[this.count++] = 34;
        }
        string.getChars(0, n, this.content, this.count);
        this.count += n;
        if (bl) {
            this.content[this.count++] = 34;
        }
    }

    public void prepare() {
    }

    public void release() {
        this.count = 0;
        if (this.stack != null) {
            JsonPool.offer(this.stack);
        }
        if (this.content.length > 32) {
            this.content = new char[32];
        }
    }

    public char[] toArray() {
        if (this.count == this.content.length) {
            return this.content;
        }
        char[] cArray = new char[this.count];
        System.arraycopy(this.content, 0, cArray, 0, this.count);
        return cArray;
    }

    public byte[] toUTF8Bytes() {
        return JsonDefaultWriter.utf8Encode(this.content, 0, this.count);
    }

    public String toString() {
        return new String(this.content, 0, this.count);
    }

    private static byte[] utf8Encode(char[] cArray, int n, int n2) {
        char c;
        int n3 = 0;
        char[] cArray2 = cArray;
        int n4 = n + n2;
        for (int i = n; i < n4; ++i) {
            c = cArray2[i];
            if (c < '\u0080') {
                ++n3;
                continue;
            }
            if (c < '\u0800') {
                n3 += 2;
                continue;
            }
            n3 += 3;
        }
        byte[] byArray = new byte[n3];
        n3 = 0;
        for (int i = n; i < n4; ++i) {
            c = cArray2[i];
            if (c < '\u0080') {
                byArray[n3++] = (byte)c;
                continue;
            }
            if (c < '\u0800') {
                byArray[n3++] = (byte)(0xC0 | c >> 6);
                byArray[n3++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            byArray[n3++] = (byte)(0xE0 | c >> 12);
            byArray[n3++] = (byte)(0x80 | c >> 6 & 0x3F);
            byArray[n3++] = (byte)(0x80 | c & 0x3F);
        }
        return byArray;
    }
}

