/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tendon.convert.json;

import com.tencent.tendon.convert.json.JsonAttribute;
import com.tencent.tendon.convert.json.JsonEnHandle;
import com.tencent.tendon.convert.json.JsonException;
import com.tencent.tendon.convert.json.JsonPrintable;
import com.tencent.tendon.convert.json.JsonWriter;
import com.tencent.tendon.convert.json.JsonXAttribute;
import com.tencent.tendon.convert.json.JsonXListener;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsonEnHandles {
    private JsonEnHandles() {
    }

    public static <T, V> JsonEnHandle<T, V> createJsonEnHandle(Class clazz, JsonAttribute jsonAttribute, JsonPrintable jsonPrintable) {
        if (clazz == null) {
            return new JsonObjectEnHandle(jsonAttribute, jsonPrintable);
        }
        if (clazz == Boolean.TYPE) {
            return new JsonBoolEnHandle((JsonXAttribute)jsonAttribute);
        }
        if (clazz == Byte.TYPE) {
            return new JsonByteEnHandle((JsonXAttribute)jsonAttribute);
        }
        if (clazz == Short.TYPE) {
            return new JsonShortEnHandle((JsonXAttribute)jsonAttribute);
        }
        if (clazz == Character.TYPE) {
            return new JsonCharEnHandle((JsonXAttribute)jsonAttribute);
        }
        if (clazz == Integer.TYPE) {
            return new JsonIntEnHandle((JsonXAttribute)jsonAttribute);
        }
        if (clazz == Float.TYPE) {
            return new JsonFloatEnHandle((JsonXAttribute)jsonAttribute);
        }
        if (clazz == Long.TYPE) {
            return new JsonLongEnHandle((JsonXAttribute)jsonAttribute);
        }
        if (clazz == Double.TYPE) {
            return new JsonDoubleEnHandle((JsonXAttribute)jsonAttribute);
        }
        if (clazz == String.class) {
            return new JsonStringEnHandle((JsonXAttribute)jsonAttribute);
        }
        return new JsonObjectEnHandle(jsonAttribute, jsonPrintable);
    }

    public static <T> JsonEnHandle link(List<JsonEnHandle> list) {
        if (list.isEmpty()) {
            return JsonEnHandle.NULL;
        }
        Collections.sort(list);
        int n = list.size() - 1;
        JsonEnHandle jsonEnHandle = list.get(n);
        for (int i = n - 1; i >= 0; --i) {
            JsonEnHandle jsonEnHandle2 = list.get(i);
            if (jsonEnHandle2 instanceof JsonObjectEnHandle) {
                jsonEnHandle = new JsonObjectEnHandle((JsonObjectEnHandle)jsonEnHandle2, jsonEnHandle);
                continue;
            }
            if (jsonEnHandle2 instanceof JsonBoolEnHandle) {
                jsonEnHandle = new JsonBoolEnHandle((JsonBoolEnHandle)jsonEnHandle2, jsonEnHandle);
                continue;
            }
            if (jsonEnHandle2 instanceof JsonByteEnHandle) {
                jsonEnHandle = new JsonByteEnHandle((JsonByteEnHandle)jsonEnHandle2, jsonEnHandle);
                continue;
            }
            if (jsonEnHandle2 instanceof JsonShortEnHandle) {
                jsonEnHandle = new JsonShortEnHandle((JsonShortEnHandle)jsonEnHandle2, jsonEnHandle);
                continue;
            }
            if (jsonEnHandle2 instanceof JsonCharEnHandle) {
                jsonEnHandle = new JsonCharEnHandle((JsonCharEnHandle)jsonEnHandle2, jsonEnHandle);
                continue;
            }
            if (jsonEnHandle2 instanceof JsonIntEnHandle) {
                jsonEnHandle = new JsonIntEnHandle((JsonIntEnHandle)jsonEnHandle2, jsonEnHandle);
                continue;
            }
            if (jsonEnHandle2 instanceof JsonFloatEnHandle) {
                jsonEnHandle = new JsonFloatEnHandle((JsonFloatEnHandle)jsonEnHandle2, jsonEnHandle);
                continue;
            }
            if (jsonEnHandle2 instanceof JsonLongEnHandle) {
                jsonEnHandle = new JsonLongEnHandle((JsonLongEnHandle)jsonEnHandle2, jsonEnHandle);
                continue;
            }
            if (jsonEnHandle2 instanceof JsonDoubleEnHandle) {
                jsonEnHandle = new JsonDoubleEnHandle((JsonDoubleEnHandle)jsonEnHandle2, jsonEnHandle);
                continue;
            }
            if (jsonEnHandle2 instanceof JsonStringEnHandle) {
                jsonEnHandle = new JsonStringEnHandle((JsonStringEnHandle)jsonEnHandle2, jsonEnHandle);
                continue;
            }
            throw new JsonException("unknown JsonEnHandle " + jsonEnHandle);
        }
        return jsonEnHandle;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JsonStringEnHandle<T>
    extends JsonEnXHandle<T> {
        public JsonStringEnHandle(JsonStringEnHandle<T> jsonStringEnHandle, JsonEnHandle<T, ?> jsonEnHandle) {
            super(jsonStringEnHandle, jsonEnHandle);
        }

        public JsonStringEnHandle(JsonXAttribute<T> jsonXAttribute) {
            super(jsonXAttribute);
        }

        @Override
        public boolean writeValue(JsonWriter jsonWriter, boolean bl, T t) {
            String string = this.attribute.getString(t);
            if (string == null) {
                return bl;
            }
            jsonWriter.write(bl ? this.field4 : this.field3);
            this.listener.convertStringTo(jsonWriter, string);
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JsonDoubleEnHandle<T>
    extends JsonEnXHandle<T> {
        public JsonDoubleEnHandle(JsonDoubleEnHandle<T> jsonDoubleEnHandle, JsonEnHandle<T, ?> jsonEnHandle) {
            super(jsonDoubleEnHandle, jsonEnHandle);
        }

        public JsonDoubleEnHandle(JsonXAttribute<T> jsonXAttribute) {
            super(jsonXAttribute);
        }

        @Override
        public boolean writeValue(JsonWriter jsonWriter, boolean bl, T t) {
            jsonWriter.write(bl ? this.field4 : this.field3);
            this.listener.convertDoubleTo(jsonWriter, this.attribute.getDouble(t));
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JsonLongEnHandle<T>
    extends JsonEnXHandle<T> {
        public JsonLongEnHandle(JsonLongEnHandle<T> jsonLongEnHandle, JsonEnHandle<T, ?> jsonEnHandle) {
            super(jsonLongEnHandle, jsonEnHandle);
        }

        public JsonLongEnHandle(JsonXAttribute<T> jsonXAttribute) {
            super(jsonXAttribute);
        }

        @Override
        public boolean writeValue(JsonWriter jsonWriter, boolean bl, T t) {
            jsonWriter.write(bl ? this.field4 : this.field3);
            this.listener.convertLongTo(jsonWriter, this.attribute.getLong(t));
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JsonFloatEnHandle<T>
    extends JsonEnXHandle<T> {
        public JsonFloatEnHandle(JsonFloatEnHandle<T> jsonFloatEnHandle, JsonEnHandle<T, ?> jsonEnHandle) {
            super(jsonFloatEnHandle, jsonEnHandle);
        }

        public JsonFloatEnHandle(JsonXAttribute<T> jsonXAttribute) {
            super(jsonXAttribute);
        }

        @Override
        public boolean writeValue(JsonWriter jsonWriter, boolean bl, T t) {
            jsonWriter.write(bl ? this.field4 : this.field3);
            this.listener.convertFloatTo(jsonWriter, this.attribute.getFloat(t));
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JsonIntEnHandle<T>
    extends JsonEnXHandle<T> {
        public JsonIntEnHandle(JsonIntEnHandle<T> jsonIntEnHandle, JsonEnHandle<T, ?> jsonEnHandle) {
            super(jsonIntEnHandle, jsonEnHandle);
        }

        public JsonIntEnHandle(JsonXAttribute<T> jsonXAttribute) {
            super(jsonXAttribute);
        }

        @Override
        public boolean writeValue(JsonWriter jsonWriter, boolean bl, T t) {
            jsonWriter.write(bl ? this.field4 : this.field3);
            this.listener.convertIntTo(jsonWriter, this.attribute.getInt(t));
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JsonCharEnHandle<T>
    extends JsonEnXHandle<T> {
        public JsonCharEnHandle(JsonCharEnHandle<T> jsonCharEnHandle, JsonEnHandle<T, ?> jsonEnHandle) {
            super(jsonCharEnHandle, jsonEnHandle);
        }

        public JsonCharEnHandle(JsonXAttribute<T> jsonXAttribute) {
            super(jsonXAttribute);
        }

        @Override
        public boolean writeValue(JsonWriter jsonWriter, boolean bl, T t) {
            jsonWriter.write(bl ? this.field4 : this.field3);
            this.listener.convertCharTo(jsonWriter, this.attribute.getChar(t));
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JsonShortEnHandle<T>
    extends JsonEnXHandle<T> {
        public JsonShortEnHandle(JsonShortEnHandle<T> jsonShortEnHandle, JsonEnHandle<T, ?> jsonEnHandle) {
            super(jsonShortEnHandle, jsonEnHandle);
        }

        public JsonShortEnHandle(JsonXAttribute<T> jsonXAttribute) {
            super(jsonXAttribute);
        }

        @Override
        public boolean writeValue(JsonWriter jsonWriter, boolean bl, T t) {
            jsonWriter.write(bl ? this.field4 : this.field3);
            this.listener.convertShortTo(jsonWriter, this.attribute.getShort(t));
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JsonByteEnHandle<T>
    extends JsonEnXHandle<T> {
        public JsonByteEnHandle(JsonByteEnHandle<T> jsonByteEnHandle, JsonEnHandle<T, ?> jsonEnHandle) {
            super(jsonByteEnHandle, jsonEnHandle);
        }

        public JsonByteEnHandle(JsonXAttribute<T> jsonXAttribute) {
            super(jsonXAttribute);
        }

        @Override
        public boolean writeValue(JsonWriter jsonWriter, boolean bl, T t) {
            jsonWriter.write(bl ? this.field4 : this.field3);
            this.listener.convertByteTo(jsonWriter, this.attribute.getByte(t));
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JsonBoolEnHandle<T>
    extends JsonEnXHandle<T> {
        public JsonBoolEnHandle(JsonBoolEnHandle<T> jsonBoolEnHandle, JsonEnHandle<T, ?> jsonEnHandle) {
            super(jsonBoolEnHandle, jsonEnHandle);
        }

        public JsonBoolEnHandle(JsonXAttribute<T> jsonXAttribute) {
            super(jsonXAttribute);
        }

        @Override
        public boolean writeValue(JsonWriter jsonWriter, boolean bl, T t) {
            jsonWriter.write(bl ? this.field4 : this.field3);
            this.listener.convertBooleanTo(jsonWriter, this.attribute.getBoolean(t));
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class JsonEnXHandle<T>
    extends JsonEnHandle<T, Void> {
        protected final JsonXAttribute<T> attribute;
        protected final JsonXListener listener = JsonXListener.getInstance();

        public JsonEnXHandle(JsonEnXHandle<T> jsonEnXHandle, JsonEnHandle<T, ?> jsonEnHandle) {
            super(jsonEnXHandle, jsonEnHandle);
            this.attribute = jsonEnXHandle.attribute;
        }

        public JsonEnXHandle(JsonXAttribute<T> jsonXAttribute) {
            super(jsonXAttribute == null ? "" : jsonXAttribute.field());
            this.attribute = jsonXAttribute;
        }

        @Override
        public abstract boolean writeValue(JsonWriter var1, boolean var2, T var3);

        @Override
        public final boolean isSimpled() {
            return true;
        }

        public String toString() {
            return "{field:" + String.format("%12s", this.field) + ", token:" + String.format("%25s", this.listener.getClass().getSimpleName()) + ", attribute:" + String.format("%32s", this.attribute.getClass().getSimpleName()) + ", name:" + String.format("%20s", this.getClass().getSimpleName()) + ", \r\n   next:" + this.next + "}";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JsonObjectEnHandle<T, V>
    extends JsonEnHandle<T, V> {
        private final JsonAttribute<T, V> attribute;
        private final JsonPrintable<V> printer;

        public JsonObjectEnHandle(JsonObjectEnHandle<T, V> jsonObjectEnHandle, JsonEnHandle<T, ?> jsonEnHandle) {
            super(jsonObjectEnHandle, jsonEnHandle);
            this.attribute = jsonObjectEnHandle.attribute;
            this.printer = jsonObjectEnHandle.printer;
        }

        public JsonObjectEnHandle(JsonAttribute<T, V> jsonAttribute, JsonPrintable<V> jsonPrintable) {
            super(jsonAttribute == null ? "" : jsonAttribute.field());
            this.attribute = jsonAttribute;
            this.printer = jsonPrintable;
        }

        @Override
        public boolean writeValue(JsonWriter jsonWriter, boolean bl, T t) {
            V v = this.attribute.get(t);
            if (v == null) {
                return bl;
            }
            jsonWriter.write(bl ? this.field4 : this.field3);
            this.printer.convertTo(jsonWriter, v);
            return true;
        }

        @Override
        public final boolean isSimpled() {
            return this.printer.isSimpled();
        }

        public String toString() {
            return "{field:" + String.format("%12s", this.field) + ", printer:" + String.format("%25s", this.printer.isSimpled() ? this.printer.toString() : this.printer.getClass().getSimpleName()) + ", attribute:" + String.format("%32s", this.attribute.getClass().getSimpleName()) + ", name:" + String.format("%20s", this.getClass().getSimpleName()) + ", \r\n   next:" + this.next + "}";
        }
    }
}

