/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tendon.convert.json;

import com.tencent.tendon.convert.json.JsonEnCompiler;
import com.tencent.tendon.convert.json.JsonFactory;
import com.tencent.tendon.convert.json.JsonListener;
import com.tencent.tendon.convert.json.JsonPrintable;
import com.tencent.tendon.convert.json.JsonPrinter;
import com.tencent.tendon.convert.json.JsonWriter;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsonPrinters {
    public static final JsonMapPrinter mapPrinter = new JsonUnknownMapPrinter(Map.class);
    public static final JsonCollectionPrinter collectionPrinter = new JsonUnknownCollectionPrinter(Collection.class);

    private JsonPrinters() {
    }

    protected static void convertObjectTo(JsonWriter jsonWriter, Object object) {
        JsonWriter jsonWriter2 = jsonWriter;
        Object object2 = object;
        if (object2 == null) {
            jsonWriter2.write('n', 'u', 'l', 'l');
            return;
        }
        Class<T[]> clazz = object2.getClass();
        JsonPrinter jsonPrinter = JsonFactory.findPrinter(clazz);
        if (jsonPrinter != null) {
            jsonPrinter.convertTo(jsonWriter2, object2);
            return;
        }
        JsonListener<?> jsonListener = JsonFactory.findListener(clazz);
        if (jsonListener != null) {
            jsonListener.convertTo(jsonWriter2, object2);
            return;
        }
        if (clazz.isArray()) {
            Class<?> clazz2 = clazz.getComponentType();
            JsonListener<?> jsonListener2 = JsonFactory.findListener(clazz2);
            if (jsonListener2 != null) {
                jsonPrinter = JsonPrinters.createJsonArrayPrinter(clazz, clazz2, jsonListener2);
                return;
            }
            JsonPrinter<?> jsonPrinter2 = JsonFactory.findPrinter(clazz2);
            if (!(jsonPrinter2 != null || clazz2.isArray() || Collection.class.isAssignableFrom(clazz2) || Map.class.isAssignableFrom(clazz2) || clazz2.getName().startsWith("java.") || clazz2.getName().startsWith("javax."))) {
                JsonEnCompiler.compileJsonDefaultPrinter(clazz2);
                jsonPrinter2 = JsonFactory.findPrinter(clazz2);
            }
            jsonPrinter = JsonPrinters.createJsonArrayPrinter(clazz, clazz2, jsonPrinter2);
            JsonFactory.register0(clazz, jsonPrinter);
            jsonPrinter.convertTo(jsonWriter2, object2);
            return;
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            jsonPrinter = collectionPrinter;
            jsonPrinter.convertTo(jsonWriter2, object2);
            return;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            jsonPrinter = mapPrinter;
            jsonPrinter.convertTo(jsonWriter2, object2);
            return;
        }
        if (clazz.getName().indexOf("java.") == 0 || clazz.getName().indexOf("javax.") == 0) {
            jsonWriter2.write('\"');
            jsonWriter2.write(String.valueOf(object2).toCharArray());
            jsonWriter2.write('\"');
            return;
        }
        JsonFactory.loadJsonPrinter(clazz).convertTo(jsonWriter2, (T[])object2);
    }

    public static <K, V> JsonPrinter<Map<K, V>> createJsonMapPrinter(Class<Map<K, V>> clazz, JsonPrintable<K> jsonPrintable, JsonPrintable<V> jsonPrintable2) {
        if (jsonPrintable != null && jsonPrintable.isSimpled() && jsonPrintable2 != null && jsonPrintable2.isSimpled()) {
            return new JsonSimpleMapPrinter(clazz, jsonPrintable, jsonPrintable2);
        }
        return new JsonUnknownMapPrinter(clazz);
    }

    public static <T> JsonPrinter<Collection<T>> createJsonCollectionPrinter(Class<Collection<T>> clazz, Class<T> clazz2, JsonPrintable<T> jsonPrintable) {
        if (jsonPrintable != null && jsonPrintable.isSimpled()) {
            if (clazz == null || clazz2 == null) {
                throw new NullPointerException();
            }
            return new JsonSimpleCollectionPrinter<T>(clazz, clazz2, jsonPrintable);
        }
        if (Modifier.isFinal(clazz2.getModifiers())) {
            if (jsonPrintable == null) {
                throw new NullPointerException();
            }
            return new JsonObjectCollectionPrinter<T>(clazz, clazz2, jsonPrintable);
        }
        return new JsonUnknownCollectionPrinter<T>(clazz);
    }

    public static <T> JsonPrinter<T[]> createJsonArrayPrinter(Class<T[]> clazz, Class<T> clazz2, JsonPrintable<T> jsonPrintable) {
        if (clazz == null || clazz2 == null) {
            throw new NullPointerException();
        }
        if (jsonPrintable != null && jsonPrintable.isSimpled()) {
            return new JsonSimpleGenericArrayPrinter<T>(clazz, clazz2, jsonPrintable);
        }
        if (Modifier.isFinal(clazz2.getModifiers())) {
            if (jsonPrintable == null) {
                throw new NullPointerException();
            }
            return new JsonObjectArrayPrinter<T>(clazz, clazz2, jsonPrintable);
        }
        return new JsonUnknownArrayPrinter<T>(clazz, clazz2, jsonPrintable);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JsonSimpleGenericArrayPrinter<T>
    extends JsonArrayPrinter<T[]> {
        final Class<T[]> type;
        final Class<T> componentType;
        final JsonPrintable<T> printer;

        public JsonSimpleGenericArrayPrinter(Class<T[]> clazz, Class clazz2, JsonPrintable<T> jsonPrintable) {
            this.type = clazz;
            this.componentType = clazz2;
            this.printer = jsonPrintable;
        }

        @Override
        public void convertTo(JsonWriter jsonWriter, T[] TArray) {
            if (TArray == null) {
                jsonWriter.writeNull();
                return;
            }
            if (TArray.length == 0) {
                jsonWriter.write('[', ']');
                return;
            }
            jsonWriter.write('[');
            boolean bl = true;
            for (T t : TArray) {
                if (!bl) {
                    jsonWriter.write(',');
                }
                this.printer.convertTo(jsonWriter, t);
                if (!bl) continue;
                bl = false;
            }
            jsonWriter.write(']');
        }

        @Override
        public Class<T[]> getType() {
            return this.type;
        }

        @Override
        public boolean isSimpled() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JsonObjectArrayPrinter<T>
    extends JsonArrayPrinter<T[]> {
        final Class<T[]> type;
        final Class<T> componentType;
        final JsonPrintable<T> printer;

        public JsonObjectArrayPrinter(Class<T[]> clazz, Class clazz2, JsonPrintable<T> jsonPrintable) {
            this.type = clazz;
            this.componentType = clazz2;
            this.printer = jsonPrintable;
        }

        @Override
        public void convertTo(JsonWriter jsonWriter, T[] TArray) {
            if (TArray == null) {
                jsonWriter.writeNull();
                return;
            }
            if (TArray.length == 0) {
                jsonWriter.write('[', ']');
                return;
            }
            jsonWriter.offer(TArray);
            jsonWriter.write('[');
            boolean bl = true;
            for (T t : TArray) {
                if (!bl) {
                    jsonWriter.write(',');
                }
                this.printer.convertTo(jsonWriter, t);
                if (!bl) continue;
                bl = false;
            }
            jsonWriter.write(']');
            jsonWriter.poll();
        }

        @Override
        public Class<T[]> getType() {
            return this.type;
        }

        @Override
        public boolean isSimpled() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JsonUnknownArrayPrinter<T>
    extends JsonArrayPrinter<T[]> {
        final Class<T[]> type;
        final Class<T> componentType;
        final JsonPrintable<T> printer;

        public JsonUnknownArrayPrinter(Class<T[]> clazz, Class<T> clazz2, JsonPrintable<T> jsonPrintable) {
            this.type = clazz;
            this.printer = jsonPrintable;
            this.componentType = clazz2;
        }

        @Override
        public void convertTo(JsonWriter jsonWriter, T[] TArray) {
            if (TArray == null) {
                jsonWriter.writeNull();
                return;
            }
            if (TArray.length == 0) {
                jsonWriter.write('[', ']');
                return;
            }
            jsonWriter.offer(TArray);
            jsonWriter.write('[');
            boolean bl = true;
            JsonPrintable<T> jsonPrintable = this.printer;
            Class<T> clazz = this.componentType;
            T[] TArray2 = TArray;
            if (jsonPrintable == null) {
                for (T t : TArray2) {
                    if (!bl) {
                        jsonWriter.write(',');
                    }
                    JsonPrinters.convertObjectTo(jsonWriter, t);
                    if (!bl) continue;
                    bl = false;
                }
            } else {
                for (T t : TArray2) {
                    if (!bl) {
                        jsonWriter.write(',');
                    }
                    if (t == null) {
                        jsonWriter.writeNull();
                    } else if (t.getClass() == clazz) {
                        jsonPrintable.convertTo(jsonWriter, t);
                    } else {
                        JsonPrinters.convertObjectTo(jsonWriter, t);
                    }
                    if (!bl) continue;
                    bl = false;
                }
            }
            jsonWriter.write(']');
            jsonWriter.poll();
        }

        @Override
        public Class<T[]> getType() {
            return this.type;
        }

        @Override
        public boolean isSimpled() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JsonSimpleCollectionPrinter<T>
    extends JsonCollectionPrinter<T> {
        final Class<Collection<T>> type;
        final Class<T> componentType;
        final JsonPrintable<T> printer;

        public JsonSimpleCollectionPrinter(Class<Collection<T>> clazz, Class<T> clazz2, JsonPrintable<T> jsonPrintable) {
            this.type = clazz;
            this.componentType = clazz2;
            this.printer = jsonPrintable;
        }

        @Override
        public void convertTo(JsonWriter jsonWriter, Collection<T> collection) {
            Collection<T> collection2 = collection;
            if (collection2 == null) {
                jsonWriter.writeNull();
                return;
            }
            if (collection2.isEmpty()) {
                jsonWriter.write('[', ']');
                return;
            }
            jsonWriter.write('[');
            boolean bl = true;
            for (T t : collection2) {
                if (!bl) {
                    jsonWriter.write(',');
                }
                this.printer.convertTo(jsonWriter, t);
                if (!bl) continue;
                bl = false;
            }
            jsonWriter.write(']');
        }

        @Override
        public Class<Collection<T>> getType() {
            return this.type;
        }

        @Override
        public boolean isSimpled() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JsonObjectCollectionPrinter<T>
    extends JsonCollectionPrinter<T> {
        final Class<Collection<T>> type;
        final Class<T> componentType;
        final JsonPrintable<T> printer;

        public JsonObjectCollectionPrinter(Class<Collection<T>> clazz, Class clazz2, JsonPrintable<T> jsonPrintable) {
            this.type = clazz;
            this.componentType = clazz2;
            this.printer = jsonPrintable;
        }

        @Override
        public void convertTo(JsonWriter jsonWriter, Collection<T> collection) {
            Collection<T> collection2 = collection;
            if (collection2 == null) {
                jsonWriter.writeNull();
                return;
            }
            if (collection2.isEmpty()) {
                jsonWriter.write('[', ']');
                return;
            }
            if (jsonWriter.writeRefer(collection)) {
                return;
            }
            jsonWriter.offer(collection);
            jsonWriter.write('[');
            boolean bl = true;
            for (T t : collection) {
                if (!bl) {
                    jsonWriter.write(',');
                }
                this.printer.convertTo(jsonWriter, t);
                if (!bl) continue;
                bl = false;
            }
            jsonWriter.write(']');
            jsonWriter.poll();
        }

        @Override
        public Class<Collection<T>> getType() {
            return this.type;
        }

        @Override
        public boolean isSimpled() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JsonUnknownCollectionPrinter<T>
    extends JsonCollectionPrinter<T> {
        final Class<Collection<T>> type;

        public JsonUnknownCollectionPrinter(Class<Collection<T>> clazz) {
            this.type = clazz;
        }

        @Override
        public void convertTo(JsonWriter jsonWriter, Collection<T> collection) {
            Collection<T> collection2 = collection;
            if (collection2 == null) {
                jsonWriter.writeNull();
                return;
            }
            if (collection2.isEmpty()) {
                jsonWriter.write('[', ']');
                return;
            }
            if (jsonWriter.writeRefer(collection)) {
                return;
            }
            jsonWriter.offer(collection);
            jsonWriter.write('[');
            boolean bl = true;
            for (T t : collection2) {
                if (!bl) {
                    jsonWriter.write(',');
                }
                JsonPrinters.convertObjectTo(jsonWriter, t);
                if (!bl) continue;
                bl = false;
            }
            jsonWriter.write(']');
            jsonWriter.poll();
        }

        @Override
        public Class<Collection<T>> getType() {
            return this.type;
        }

        @Override
        public boolean isSimpled() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JsonSimpleMapPrinter<K, V>
    extends JsonMapPrinter<K, V> {
        final Class<Map<K, V>> type;
        final JsonPrintable<K> keyprinter;
        final JsonPrintable<V> valueprinter;

        private JsonSimpleMapPrinter(Class<Map<K, V>> clazz, JsonPrintable<K> jsonPrintable, JsonPrintable<V> jsonPrintable2) {
            this.type = clazz;
            this.keyprinter = jsonPrintable;
            this.valueprinter = jsonPrintable2;
        }

        @Override
        public void convertTo(JsonWriter jsonWriter, Map<K, V> map) {
            Map<K, V> map2 = map;
            if (map2 == null) {
                jsonWriter.writeNull();
                return;
            }
            if (map2.isEmpty()) {
                jsonWriter.write('{', '}');
                return;
            }
            jsonWriter.write('{');
            boolean bl = true;
            for (Map.Entry<K, V> entry : map2.entrySet()) {
                if (!bl) {
                    jsonWriter.write(',');
                }
                this.keyprinter.convertTo(jsonWriter, entry.getKey());
                jsonWriter.write(':');
                this.valueprinter.convertTo(jsonWriter, entry.getValue());
                if (!bl) continue;
                bl = false;
            }
            jsonWriter.write('}');
        }

        @Override
        public Class<Map<K, V>> getType() {
            return this.type;
        }

        @Override
        public boolean isSimpled() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JsonUnknownMapPrinter<K, V>
    extends JsonMapPrinter<K, V> {
        final Class<Map<K, V>> type;

        private JsonUnknownMapPrinter(Class<Map<K, V>> clazz) {
            this.type = clazz;
        }

        @Override
        public void convertTo(JsonWriter jsonWriter, Map<K, V> map) {
            Map<K, V> map2 = map;
            if (map2 == null) {
                jsonWriter.writeNull();
                return;
            }
            if (map2.isEmpty()) {
                jsonWriter.write('{', '}');
                return;
            }
            jsonWriter.offer(map);
            jsonWriter.write('{');
            boolean bl = true;
            for (Map.Entry<K, V> entry : map2.entrySet()) {
                if (!bl) {
                    jsonWriter.write(',');
                }
                JsonPrinters.convertObjectTo(jsonWriter, entry.getKey());
                jsonWriter.write(':');
                JsonPrinters.convertObjectTo(jsonWriter, entry.getValue());
                if (!bl) continue;
                bl = false;
            }
            jsonWriter.write('}');
            jsonWriter.poll();
        }

        @Override
        public Class<Map<K, V>> getType() {
            return this.type;
        }

        @Override
        public boolean isSimpled() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class JsonMapPrinter<K, V>
    extends JsonPrinter<Map<K, V>> {
        private JsonMapPrinter() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class JsonCollectionPrinter<T>
    extends JsonPrinter<Collection<T>> {
        private JsonCollectionPrinter() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class JsonArrayPrinter<T>
    extends JsonPrinter<T> {
        private JsonArrayPrinter() {
        }
    }
}

