/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tendon.convert.json.listeners;

import com.tencent.tendon.convert.json.JsonListener;
import com.tencent.tendon.convert.json.JsonWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsonBytesListener
extends JsonListener<byte[]> {
    private static final char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    public static final JsonBytesListener instance = new JsonBytesListener();

    private JsonBytesListener() {
    }

    @Override
    public void convertTo(JsonWriter jsonWriter, byte[] byArray) {
        if (byArray == null) {
            jsonWriter.writeNull();
            return;
        }
        jsonWriter.write('\"');
        jsonWriter.write(JsonBytesListener.hexTo(byArray));
        jsonWriter.write('\"');
    }

    @Override
    public byte[] convertFrom(char[] cArray, int n, int n2) {
        if (cArray == null) {
            return null;
        }
        return JsonBytesListener.hexFrom(cArray, n, n2);
    }

    @Override
    public Class<byte[]> getType() {
        return byte[].class;
    }

    private static byte[] hexFrom(char[] cArray, int n, int n2) {
        int n3 = (n2 + 1) / 2;
        byte[] byArray = new byte[n3];
        for (int i = 0; i < n3; ++i) {
            int n4 = 0;
            char c = Character.toLowerCase(cArray[n + i * 2]);
            char c2 = Character.toLowerCase(cArray[n + i * 2 + 1]);
            int n5 = 0;
            for (int j = 0; j < hex.length; ++j) {
                if (hex[j] == c) {
                    n4 += j * 16;
                    ++n5;
                }
                if (hex[j] == c2) {
                    n4 += j;
                    ++n5;
                }
                if (n5 == 2) break;
            }
            byArray[i] = (byte)n4;
        }
        return byArray;
    }

    private static char[] hexTo(byte[] byArray) {
        char[] cArray = new char[byArray.length * 2];
        int n = 0;
        for (byte by : byArray) {
            cArray[n++] = hex[by >> 4 & 0xF];
            cArray[n++] = hex[by & 0xF];
        }
        return cArray;
    }
}

