/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tendon.convert.json.printers;

import com.tencent.tendon.convert.json.JsonPrinter;
import com.tencent.tendon.convert.json.JsonWriter;
import com.tencent.tendon.convert.json.JsonXListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsonDoubleArrayPrinter
extends JsonPrinter<double[]> {
    public static final JsonDoubleArrayPrinter instance = new JsonDoubleArrayPrinter();
    private static final JsonXListener listener = JsonXListener.getInstance();

    private JsonDoubleArrayPrinter() {
    }

    @Override
    public final void convertTo(JsonWriter jsonWriter, double[] dArray) {
        double[] dArray2 = dArray;
        if (dArray2 == null) {
            jsonWriter.writeNull();
            return;
        }
        if (dArray2.length == 0) {
            jsonWriter.write('[', ']');
            return;
        }
        jsonWriter.write('[');
        boolean bl = true;
        for (double d : dArray2) {
            if (!bl) {
                jsonWriter.write(',');
            }
            listener.convertDoubleTo(jsonWriter, d);
            if (!bl) continue;
            bl = false;
        }
        jsonWriter.write(']');
    }

    @Override
    public Class<double[]> getType() {
        return double[].class;
    }

    @Override
    public boolean isSimpled() {
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

