/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tendon.convert.json.streams;

import com.tencent.tendon.convert.json.JsonCharArray;
import com.tencent.tendon.convert.json.JsonDeHandle;
import com.tencent.tendon.convert.json.JsonException;
import com.tencent.tendon.convert.json.JsonListener;
import com.tencent.tendon.convert.json.JsonPool;
import com.tencent.tendon.convert.json.JsonReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JsonAbstractReader
extends JsonReader {
    private char lastedchar;
    protected final JsonCharArray buf = JsonPool.pollJsonCharArray();

    protected abstract char get();

    @Override
    public void release() {
        super.release();
        JsonPool.offer(this.buf);
    }

    @Override
    protected char nextChar() {
        ++this.position;
        if (this.lastedchar != '\u0000') {
            char c = this.lastedchar;
            this.lastedchar = '\u0000';
            return c;
        }
        return this.get();
    }

    @Override
    protected void back(char c) {
        --this.position;
        this.lastedchar = c;
    }

    @Override
    public final JsonDeHandle readField(JsonDeHandle jsonDeHandle) {
        char[] cArray;
        JsonDeHandle jsonDeHandle2;
        char c;
        char[] cArray2 = jsonDeHandle.fields;
        char c2 = this.readChar();
        int n = cArray2.length;
        JsonCharArray jsonCharArray = this.buf;
        jsonCharArray.clear();
        int n2 = 0;
        if (c2 == '\"' || c2 == '\'') {
            while ((c = this.nextChar()) != c2 && c >= '\u0000') {
                if (n2 >= n || c != cArray2[n2]) {
                    n2 = n;
                }
                jsonCharArray.append(c);
                ++n2;
            }
            if (n2 == n) {
                return jsonDeHandle;
            }
        } else {
            jsonCharArray.append(c2);
            ++n2;
            while (true) {
                if ((c = this.nextChar()) == ':' || c == '}' || c == ']' || c <= ' ' || c == ',') break;
                if (n2 >= n || c != cArray2[n2]) {
                    n2 = n;
                }
                jsonCharArray.append(c);
                ++n2;
            }
            this.back(c);
            if (n2 == n) {
                return jsonDeHandle;
            }
        }
        if ((jsonDeHandle2 = jsonDeHandle.find(cArray = jsonCharArray.toArray(), 0, cArray.length)) == null && cArray.length == 1 && cArray[0] == '@') {
            return JsonDeHandle.REFER;
        }
        return jsonDeHandle2;
    }

    @Override
    public final char[] readValue() {
        char c = this.readChar();
        if (c < '\u0000') {
            return null;
        }
        if (c == '\"' || c == '\'') {
            return this.readValue(c);
        }
        JsonCharArray jsonCharArray = this.buf;
        jsonCharArray.clear();
        jsonCharArray.append(c);
        while (true) {
            if ((c = this.nextChar()) == ',' || c == '}' || c == ']' || c <= ' ' || c == ':') break;
            jsonCharArray.append(c);
        }
        this.back(c);
        char[] cArray = jsonCharArray.toArray();
        if (cArray.length == 4 && cArray[0] == 'n' && cArray[1] == 'u' && cArray[2] == 'l' && cArray[3] == 'l') {
            return null;
        }
        return cArray;
    }

    @Override
    public <T> T readValue(JsonListener<T> jsonListener) {
        char c = this.readChar();
        if (c < '\u0000') {
            return null;
        }
        if (c == '\"' || c == '\'') {
            char[] cArray = this.readValue(c);
            return jsonListener.convertFrom(cArray, 0, cArray.length);
        }
        JsonCharArray jsonCharArray = this.buf;
        jsonCharArray.clear();
        jsonCharArray.append(c);
        while (true) {
            if ((c = this.nextChar()) == ',' || c == '}' || c == ']' || c <= ' ' || c == ':') break;
            jsonCharArray.append(c);
        }
        this.back(c);
        char[] cArray = jsonCharArray.toArray();
        if (cArray.length == 4 && cArray[0] == 'n' && cArray[1] == 'u' && cArray[2] == 'l' && cArray[3] == 'l') {
            return jsonListener.convertFrom(null, -1, -1);
        }
        return jsonListener.convertFrom(cArray, 0, cArray.length);
    }

    @Override
    protected final int readInt() {
        char[] cArray = this.readValue();
        if (cArray == null || cArray.length == 0) {
            return 0;
        }
        int n = 0;
        boolean bl = cArray[0] == '-';
        int n2 = cArray.length;
        for (int i = bl ? 1 : 0; i < n2; ++i) {
            char c = cArray[i];
            if (c < '0' || c > '9') {
                throw new NumberFormatException("illegal escape(" + c + ") (position = " + this.position + ")");
            }
            n = (n << 3) + (n << 1) + (c - 48);
        }
        return bl ? -n : n;
    }

    @Override
    protected final long readLong() {
        char[] cArray = this.readValue();
        if (cArray == null || cArray.length == 0) {
            return 0L;
        }
        long l = 0L;
        boolean bl = cArray[0] == '-';
        int n = cArray.length;
        for (int i = bl ? 1 : 0; i < n; ++i) {
            char c = cArray[i];
            if (c < '0' || c > '9') {
                throw new NumberFormatException("illegal escape(" + c + ") (position = " + this.position + ")");
            }
            l = (l << 3) + (l << 1) + (long)(c - 48);
        }
        return bl ? -l : l;
    }

    @Override
    protected final String readString() {
        char[] cArray = this.readValue();
        return cArray == null ? null : new String(cArray);
    }

    private char[] readValue(char c) {
        JsonCharArray jsonCharArray = this.buf;
        jsonCharArray.clear();
        block9: while (true) {
            char c2;
            if ((c2 = this.nextChar()) == '\\') {
                c2 = this.nextChar();
                switch (c2) {
                    case '\"': 
                    case '\'': 
                    case '/': 
                    case '\\': {
                        jsonCharArray.append(c2);
                        continue block9;
                    }
                    case 'n': {
                        jsonCharArray.append('\n');
                        continue block9;
                    }
                    case 'r': {
                        jsonCharArray.append('\r');
                        continue block9;
                    }
                    case 'u': {
                        jsonCharArray.append((char)Integer.parseInt(new String(new char[]{this.nextChar(), this.nextChar(), this.nextChar(), this.nextChar()}), 16));
                        continue block9;
                    }
                    case 't': {
                        jsonCharArray.append('\t');
                        continue block9;
                    }
                    case 'b': {
                        jsonCharArray.append('\b');
                        continue block9;
                    }
                    case 'f': {
                        jsonCharArray.append('\f');
                        continue block9;
                    }
                }
                throw new JsonException("illegal escape(" + c2 + ") (position = " + this.position + ")");
            }
            if (c2 == c || c2 < '\u0000') break;
            jsonCharArray.append(c2);
        }
        return jsonCharArray.toArray();
    }
}

