/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tendon.convert.json.tokens;

import com.tencent.tendon.convert.json.JsonPoolable;
import com.tencent.tendon.convert.json.JsonReader;
import com.tencent.tendon.convert.json.JsonToken;
import com.tencent.tendon.convert.json.JsonXListener;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsonIntArrayToken
extends JsonToken<int[]> {
    public static final JsonIntArrayToken instance = new JsonIntArrayToken();
    private static final JsonXListener listener = JsonXListener.getInstance();

    @Override
    public int[] convertFrom(JsonReader jsonReader) {
        JsonIntArrayList jsonIntArrayList = JsonIntArrayList.poll();
        jsonReader.checkArray();
        while (jsonReader.hasNext()) {
            jsonIntArrayList.add(listener.convertIntFrom(jsonReader));
        }
        int[] nArray = jsonIntArrayList.toArray();
        JsonIntArrayList.offer(jsonIntArrayList);
        return nArray;
    }

    @Override
    public Class<int[]> getType() {
        return int[].class;
    }

    public Class getComponentType() {
        return Integer.TYPE;
    }

    @Override
    public boolean isSimpled() {
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static final class JsonIntArrayList
    implements JsonPoolable {
        private static final Queue<JsonIntArrayList> queue = new ArrayBlockingQueue<JsonIntArrayList>(Math.max(Runtime.getRuntime().availableProcessors(), 2) * 2);
        private int[] data;
        private int size;

        public static JsonIntArrayList poll() {
            JsonIntArrayList jsonIntArrayList = queue.poll();
            if (jsonIntArrayList == null) {
                jsonIntArrayList = new JsonIntArrayList();
            } else {
                jsonIntArrayList.prepare();
            }
            return jsonIntArrayList;
        }

        public static void offer(JsonIntArrayList jsonIntArrayList) {
            if (jsonIntArrayList != null) {
                jsonIntArrayList.release();
                queue.offer(jsonIntArrayList);
            }
        }

        public JsonIntArrayList() {
            this(8);
        }

        public JsonIntArrayList(int n) {
            this.data = new int[n];
        }

        private void grow() {
            int[] nArray = new int[this.data.length + 8];
            System.arraycopy(this.data, 0, nArray, 0, this.size);
            this.data = nArray;
        }

        public void add(int n) {
            if (this.size == this.data.length) {
                this.grow();
            }
            this.data[this.size++] = n;
        }

        public int[] toArray() {
            if (this.size == this.data.length) {
                return this.data;
            }
            int[] nArray = new int[this.size];
            System.arraycopy(this.data, 0, nArray, 0, this.size);
            return nArray;
        }

        public void prepare() {
        }

        public void release() {
            this.size = 0;
            this.data = new int[8];
        }

        public void clear() {
            this.release();
        }
    }
}

