/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.teradata.visitor;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.dialect.teradata.ast.expr.TeradataAnalytic;
import com.alibaba.druid.sql.dialect.teradata.ast.expr.TeradataAnalyticWindowing;
import com.alibaba.druid.sql.dialect.teradata.ast.expr.TeradataIntervalExpr;
import com.alibaba.druid.sql.dialect.teradata.ast.stmt.TeradataSelectQueryBlock;
import com.alibaba.druid.sql.dialect.teradata.visitor.TeradataASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;

public class TeradataOutputVisitor
extends SQLASTOutputVisitor
implements TeradataASTVisitor {
    public TeradataOutputVisitor(Appendable appender) {
        super(appender);
    }

    @Override
    public boolean visit(TeradataAnalytic x) {
        this.print0(this.ucase ? "OVER (" : "over (");
        boolean space = false;
        if (x.getPartitionBy().size() > 0) {
            this.print0(this.ucase ? "PARTITION BY " : "partition by ");
            this.printAndAccept(x.getPartitionBy(), ", ");
            space = true;
        }
        if (x.getOrderBy() != null) {
            if (space) {
                this.print(' ');
            }
            x.getOrderBy().accept(this);
            space = true;
        }
        if (x.getWindowing() != null) {
            if (space) {
                this.print(' ');
            }
            x.getWindowing().accept(this);
        }
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(TeradataAnalyticWindowing x) {
        this.print0(x.getType().name().toUpperCase());
        this.print(' ');
        x.getExpr().accept(this);
        return false;
    }

    @Override
    public void endVisit(TeradataAnalyticWindowing x) {
    }

    @Override
    public boolean visit(SQLSelectQueryBlock select) {
        if (select instanceof TeradataSelectQueryBlock) {
            return this.visit((TeradataSelectQueryBlock)select);
        }
        return super.visit(select);
    }

    public boolean visit(TeradataSelectQueryBlock x) {
        if (x.getOrderBy() != null) {
            x.getOrderBy().setParent(x);
        }
        this.print0(this.ucase ? "SELECT " : "select ");
        if (1 == x.getDistionOption()) {
            this.print0(this.ucase ? "ALL " : "all ");
        } else if (2 == x.getDistionOption()) {
            this.print0(this.ucase ? "DISTINCT " : "distinct ");
        } else if (3 == x.getDistionOption()) {
            this.print0(this.ucase ? "UNIQUE " : "unique ");
        }
        this.printSelectList(x.getSelectList());
        if (x.getInto() != null) {
            this.println();
            this.print0(this.ucase ? "INTO " : "into ");
            x.getInto().accept(this);
        }
        this.println();
        this.print0(this.ucase ? "FROM " : "from ");
        if (x.getFrom() == null) {
            this.print0(this.ucase ? "DUAL" : "dual");
        } else {
            x.getFrom().setParent(x);
            x.getFrom().accept(this);
        }
        if (x.getWhere() != null) {
            this.println();
            this.print0(this.ucase ? "WHERE " : "where ");
            x.getWhere().setParent(x);
            x.getWhere().accept(this);
        }
        if (x.getGroupBy() != null) {
            this.println();
            x.getGroupBy().accept(this);
        }
        if (x.getOrderBy() != null) {
            this.println();
            x.getOrderBy().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLSelect x) {
        return super.visit(x);
    }

    @Override
    protected void visitAggreateRest(SQLAggregateExpr aggregateExpr) {
        Object value = (SQLOrderBy)aggregateExpr.getAttribute("ORDER BY");
        if (value != null) {
            this.print(' ');
            value.accept(this);
        }
        if ((value = aggregateExpr.getAttribute("SEPARATOR")) != null) {
            this.print0(this.ucase ? " SEPARATOR " : " separator ");
            ((SQLObject)value).accept(this);
        }
    }

    @Override
    public boolean visit(TeradataIntervalExpr x) {
        this.print0(this.ucase ? "INTERVAL " : "interval ");
        x.getValue().accept(this);
        this.print(' ');
        this.print0(this.ucase ? x.getUnit().name() : x.getUnit().name_lcase);
        return false;
    }

    @Override
    public void endVisit(TeradataIntervalExpr x) {
    }

    @Override
    public void endVisit(SQLMethodInvokeExpr x) {
    }

    @Override
    public boolean visit(SQLMethodInvokeExpr x) {
        if ("trim".equalsIgnoreCase(x.getMethodName())) {
            SQLExpr trim_character = (SQLExpr)x.getAttribute("trim_character");
            this.print0(x.getMethodName());
            this.print('(');
            String trim_option = (String)x.getAttribute("trim_option");
            if (trim_option != null && trim_option.length() != 0) {
                this.print0(trim_option);
                this.print(' ');
            }
            if (trim_character != null) {
                trim_character.accept(this);
            }
            if (x.getParameters().size() > 0) {
                this.print0(this.ucase ? " FROM " : " from ");
                x.getParameters().get(0).accept(this);
            }
            this.print(')');
            return false;
        }
        return super.visit(x);
    }
}

