/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.examples.eventlistener;

import java.util.ArrayList;
import java.util.List;
import org.jbpm.api.Execution;
import org.jbpm.api.ProcessInstance;
import org.jbpm.test.JbpmTestCase;

public class EventListenerTest
extends JbpmTestCase {
    String deploymentId;

    protected void setUp() throws Exception {
        super.setUp();
        this.deploymentId = this.repositoryService.createDeployment().addResourceFromClasspath("org/jbpm/examples/eventlistener/process.jpdl.xml").deploy();
    }

    protected void tearDown() throws Exception {
        this.repositoryService.deleteDeploymentCascade(this.deploymentId);
        super.tearDown();
    }

    public void testEventListener() {
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("EventListener");
        Execution execution = processInstance.findActiveExecutionIn("wait");
        this.executionService.signalExecutionById(execution.getId());
        ArrayList<String> expectedLogs = new ArrayList<String>();
        expectedLogs.add("start on process definition");
        expectedLogs.add("start on activity wait");
        expectedLogs.add("end on activity wait");
        expectedLogs.add("take transition");
        List logs = (List)this.executionService.getVariable(processInstance.getId(), "logs");
        EventListenerTest.assertEquals(expectedLogs, (Object)logs);
    }
}

