/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.activities;

import java.util.List;
import org.jbpm.api.Execution;
import org.jbpm.api.ProcessInstance;
import org.jbpm.api.job.Timer;
import org.jbpm.test.JbpmTestCase;

public class GroupTimersTest
extends JbpmTestCase {
    public void testGroupWithTimer() {
        this.deployJpdlXmlString("<process name='Group'>  <start>    <transition to='group' />  </start>  <group name='group'>    <start>      <transition to='a' />    </start>    <state name='a'>      <transition to='done' />    </state>    <end name='done' />    <transition to='end' />    <transition name='timeout' to='escalate'>      <timer duedate='2 hours' />    </transition>  </group>  <state name='end' />  <state name='escalate' /></process>");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("Group");
        GroupTimersTest.assertEquals((String)"inactive-scope", (String)processInstance.getState());
        GroupTimersTest.assertEquals((int)1, (int)processInstance.getExecutions().size());
        Execution groupExecution = (Execution)processInstance.getExecutions().iterator().next();
        GroupTimersTest.assertEquals((String)"active-root", (String)groupExecution.getState());
        GroupTimersTest.assertTrue((boolean)groupExecution.isActive("a"));
        processInstance = this.executionService.signalExecutionById(groupExecution.getId());
        GroupTimersTest.assertEquals((String)"active-root", (String)processInstance.getState());
        GroupTimersTest.assertEquals((int)0, (int)processInstance.getExecutions().size());
        processInstance = this.executionService.startProcessInstanceByKey("Group");
        List jobs = this.managementService.createJobQuery().processInstanceId(processInstance.getId()).list();
        GroupTimersTest.assertEquals((int)1, (int)jobs.size());
        Timer timer = (Timer)jobs.get(0);
        GroupTimersTest.assertEquals((String)"timeout", (String)timer.getSignalName());
        this.managementService.executeJob(timer.getId());
        processInstance = this.executionService.findProcessInstanceById(processInstance.getId());
        GroupTimersTest.assertEquals((String)"active-root", (String)processInstance.getState());
        GroupTimersTest.assertTrue((boolean)processInstance.isActive("escalate"));
        GroupTimersTest.assertEquals((int)0, (int)processInstance.getExecutions().size());
    }
}

