/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.activity.task;

import java.util.HashMap;
import org.jbpm.api.JbpmException;
import org.jbpm.api.history.HistoryTask;
import org.jbpm.test.JbpmTestCase;

public class TaskCompletionTest
extends JbpmTestCase {
    private static final String PROCESS = "<process name='taskCompletion'>  <start>    <transition to='theTask' />  </start>  <task name='theTask' assignee='johndoe'>    <transition name='one' to='stateOne' />    <transition name='two' to='stateTwo' />  </task>  <state name='stateOne'>    <transition to='theEnd' />  </state>  <state name='stateTwo'>    <transition to='theEnd' />  </state>  <end name='theEnd' /></process>";

    public void testCompletionWithNullOrEmptyId() {
        try {
            this.taskService.completeTask(null);
            TaskCompletionTest.fail();
        }
        catch (JbpmException e) {
            // empty catch block
        }
        try {
            this.taskService.completeTask("");
            TaskCompletionTest.fail();
        }
        catch (JbpmException jbpmException) {
            // empty catch block
        }
    }

    public void testCompletionWithInvalidTaskId() {
        try {
            this.taskService.completeTask(Long.toString(-123456789L));
            TaskCompletionTest.fail();
        }
        catch (JbpmException jbpmException) {
            // empty catch block
        }
    }

    public void testCompletionWithOutcome() {
        Ids ids = this.deployAndStartProcessInstance();
        this.taskService.completeTask(ids.taskId, "one");
        this.assertActivityActive(ids.processInstanceId, "stateOne");
        this.assertNotActivityActive(ids.processInstanceId, "stateTwo");
        this.assertNoOpenTasks(ids.processInstanceId);
        this.assertHistoryTaskCreated(ids.processInstanceId, "one");
    }

    public void testCompletionWithInvalidOutcome() {
        Ids ids = this.deployAndStartProcessInstance();
        try {
            this.taskService.completeTask(ids.taskId, "doesn't exist");
            TaskCompletionTest.fail();
        }
        catch (JbpmException jbpmException) {
            // empty catch block
        }
        TaskCompletionTest.assertNotNull((String)"After completion with an invalid outcome, the task should remain unchanged", (Object)this.taskService.createTaskQuery().processInstanceId(ids.processInstanceId).uniqueResult());
    }

    public void testCompletionWithVariables() {
        Ids ids = this.deployAndStartProcessInstance();
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("testVar", "testValue");
        this.taskService.completeTask(ids.taskId, "one", vars);
        TaskCompletionTest.assertEquals((Object)"testValue", (Object)this.executionService.getVariable(ids.processInstanceId, "testVar"));
        this.assertNoOpenTasks(ids.processInstanceId);
        this.assertHistoryTaskCreated(ids.processInstanceId, null);
    }

    public void testCompletionWithOutcomeAndVariables() {
        Ids ids = this.deployAndStartProcessInstance();
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("testVar", "testValue");
        this.taskService.completeTask(ids.taskId, "two", vars);
        TaskCompletionTest.assertEquals((Object)"testValue", (Object)this.executionService.getVariable(ids.processInstanceId, "testVar"));
        this.assertActivityActive(ids.processInstanceId, "stateTwo");
        this.assertNoOpenTasks(ids.processInstanceId);
        this.assertHistoryTaskCreated(ids.processInstanceId, "two");
    }

    private Ids deployAndStartProcessInstance() {
        this.deployJpdlXmlString(PROCESS);
        Ids result = new Ids();
        result.processInstanceId = this.executionService.startProcessInstanceByKey("taskCompletion").getId();
        result.taskId = this.taskService.createTaskQuery().processInstanceId(result.processInstanceId).uniqueResult().getId();
        return result;
    }

    private void assertHistoryTaskCreated(String executionId, String historicalOutcome) {
        HistoryTask historyTask = this.historyService.createHistoryTaskQuery().executionId(executionId).uniqueResult();
        TaskCompletionTest.assertNotNull((Object)historyTask);
        if (historicalOutcome != null) {
            TaskCompletionTest.assertEquals((String)historicalOutcome, (String)historyTask.getOutcome());
        }
    }

    private class Ids {
        private String processInstanceId;
        private String taskId;

        private Ids() {
        }
    }
}

