/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.jbpm.api.ProcessDefinition;
import org.jbpm.api.ProcessInstance;
import org.jbpm.api.history.HistoryActivityInstance;
import org.jbpm.api.task.Task;
import org.jbpm.pvm.internal.util.Clock;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.assertion.QueryAssertions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoryActivityInstanceQueryTest
extends JbpmTestCase {
    protected void tearDown() throws Exception {
        Clock.setExplicitTime(null);
        super.tearDown();
    }

    public void testSimpleQuery() {
        this.deployStartAndSignalTestProcesses();
        List histActInsts = this.historyService.createHistoryActivityInstanceQuery().activityName("a").list();
        HistoryActivityInstanceQueryTest.assertEquals((int)4, (int)histActInsts.size());
        histActInsts = this.historyService.createHistoryActivityInstanceQuery().activityName("b").list();
        HistoryActivityInstanceQueryTest.assertEquals((int)3, (int)histActInsts.size());
        histActInsts = this.historyService.createHistoryActivityInstanceQuery().activityName("c").list();
        HistoryActivityInstanceQueryTest.assertEquals((int)2, (int)histActInsts.size());
    }

    public void testQueryByProcessDefinitionId() {
        String procDefId = this.deployTestProcess();
        this.generateHistoryForTestProcess();
        ProcessDefinition procDef = this.repositoryService.createProcessDefinitionQuery().deploymentId(procDefId).uniqueResult();
        List hacs = this.historyService.createHistoryActivityInstanceQuery().processDefinitionId(procDef.getId()).list();
        HistoryActivityInstanceQueryTest.assertEquals((int)9, (int)hacs.size());
        HashMap<String, Integer> activityCounts = new HashMap<String, Integer>();
        for (HistoryActivityInstance hac : hacs) {
            String name;
            Integer current = (Integer)activityCounts.get(name = hac.getActivityName());
            activityCounts.put(name, (current == null ? 0 : current) + 1);
        }
        HistoryActivityInstanceQueryTest.assertEquals((Object)new Integer(4), activityCounts.get("a"));
        HistoryActivityInstanceQueryTest.assertEquals((Object)new Integer(3), activityCounts.get("b"));
        HistoryActivityInstanceQueryTest.assertEquals((Object)new Integer(2), activityCounts.get("c"));
    }

    public void testQueryByExecutionId() {
        List<String> ids = this.deployStartAndSignalTestProcesses();
        HistoryActivityInstanceQueryTest.assertEquals((int)3, (int)this.historyService.createHistoryActivityInstanceQuery().executionId(ids.get(0)).list().size());
        HistoryActivityInstanceQueryTest.assertEquals((int)3, (int)this.historyService.createHistoryActivityInstanceQuery().executionId(ids.get(1)).list().size());
        HistoryActivityInstanceQueryTest.assertEquals((int)2, (int)this.historyService.createHistoryActivityInstanceQuery().executionId(ids.get(2)).list().size());
        HistoryActivityInstanceQueryTest.assertEquals((int)1, (int)this.historyService.createHistoryActivityInstanceQuery().executionId(ids.get(3)).list().size());
    }

    public void testQueryByStartedAfter() {
        this.deployTestProcess();
        Clock.setExplicitTime((Date)new Date(3000000L));
        this.generateHistoryForTestProcess();
        this.generateHistoryForTestProcess();
        Clock.setExplicitTime((Date)new Date(3005000L));
        this.generateHistoryForTestProcess();
        Date timeStamp = new Date(3003000L);
        HistoryActivityInstanceQueryTest.assertEquals((int)9, (int)this.historyService.createHistoryActivityInstanceQuery().startedAfter(timeStamp).list().size());
    }

    public void testQueryByStartedBefore() {
        this.deployTestProcess();
        Clock.setExplicitTime((Date)new Date(3000000L));
        this.generateHistoryForTestProcess();
        Clock.setExplicitTime((Date)new Date(3002000L));
        this.generateHistoryForTestProcess();
        this.generateHistoryForTestProcess();
        Date timeStamp = new Date(3001000L);
        HistoryActivityInstanceQueryTest.assertEquals((int)9, (int)this.historyService.createHistoryActivityInstanceQuery().startedBefore(timeStamp).list().size());
    }

    public void testQueryByActivityName() {
        this.deployStartAndSignalTestProcesses();
        HistoryActivityInstanceQueryTest.assertEquals((int)4, (int)this.historyService.createHistoryActivityInstanceQuery().activityName("a").list().size());
        HistoryActivityInstanceQueryTest.assertEquals((int)3, (int)this.historyService.createHistoryActivityInstanceQuery().activityName("b").list().size());
        HistoryActivityInstanceQueryTest.assertEquals((int)2, (int)this.historyService.createHistoryActivityInstanceQuery().activityName("c").list().size());
    }

    public void testQueryByTookLessThen() {
        this.deployStartAndSignalTestProcesses();
        HistoryActivityInstanceQueryTest.assertEquals((int)9, (int)this.historyService.createHistoryActivityInstanceQuery().tookLessThen(3600000L).list().size());
    }

    public void testOrderByActivityName() {
        this.testOrderBy("activityName", Arrays.asList("a", "a", "a", "a", "b", "b", "b", "c", "c"));
    }

    public void testOrderByStartTime() {
        this.testOrderByNaturalOrdening("startTime", 9);
    }

    public void testOrderByEndTime() {
        this.testOrderByNaturalOrdening("endTime", 9);
    }

    public void testOrderByDuration() {
        this.testOrderByNaturalOrdening("duration", 9);
    }

    public void testOrderByExecutionId() {
        this.testOrderByNaturalOrdening("executionId", 9);
    }

    public void testCount() {
        List<String> procInstIds = this.deployStartAndSignalTestProcesses();
        HistoryActivityInstanceQueryTest.assertEquals((long)9L, (long)this.historyService.createHistoryActivityInstanceQuery().count());
        HistoryActivityInstanceQueryTest.assertEquals((long)4L, (long)this.historyService.createHistoryActivityInstanceQuery().activityName("a").count());
        HistoryActivityInstanceQueryTest.assertEquals((long)3L, (long)this.historyService.createHistoryActivityInstanceQuery().activityName("b").count());
        HistoryActivityInstanceQueryTest.assertEquals((long)2L, (long)this.historyService.createHistoryActivityInstanceQuery().activityName("c").count());
        HistoryActivityInstanceQueryTest.assertEquals((long)0L, (long)this.historyService.createHistoryActivityInstanceQuery().activityName("d").count());
        HistoryActivityInstanceQueryTest.assertEquals((long)3L, (long)this.historyService.createHistoryActivityInstanceQuery().executionId(procInstIds.get(0)).count());
        HistoryActivityInstanceQueryTest.assertEquals((long)3L, (long)this.historyService.createHistoryActivityInstanceQuery().executionId(procInstIds.get(1)).count());
        HistoryActivityInstanceQueryTest.assertEquals((long)2L, (long)this.historyService.createHistoryActivityInstanceQuery().executionId(procInstIds.get(2)).count());
        HistoryActivityInstanceQueryTest.assertEquals((long)1L, (long)this.historyService.createHistoryActivityInstanceQuery().executionId(procInstIds.get(3)).count());
        HistoryActivityInstanceQueryTest.assertEquals((long)1L, (long)this.historyService.createHistoryActivityInstanceQuery().executionId(procInstIds.get(0)).activityName("a").count());
        HistoryActivityInstanceQueryTest.assertEquals((long)1L, (long)this.historyService.createHistoryActivityInstanceQuery().executionId(procInstIds.get(0)).activityName("b").count());
        HistoryActivityInstanceQueryTest.assertEquals((long)1L, (long)this.historyService.createHistoryActivityInstanceQuery().executionId(procInstIds.get(0)).activityName("c").count());
    }

    private List<String> deployStartAndSignalTestProcesses() {
        this.deployTestProcess();
        return this.generateHistoryForTestProcess();
    }

    private String deployTestProcess() {
        return this.deployJpdlXmlString("<process name='abc'>  <start>    <transition to='a' />  </start>  <state name='a'>    <transition to ='b' />  </state>  <state name='b'>    <transition to ='c' />  </state>  <state name='c'>    <transition to ='end' />  </state>  <end name='end' /></process>");
    }

    private List<String> generateHistoryForTestProcess() {
        ArrayList<String> ids = new ArrayList<String>();
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("abc");
        this.executionService.signalExecutionById(processInstance.getId());
        this.executionService.signalExecutionById(processInstance.getId());
        this.executionService.signalExecutionById(processInstance.getId());
        ids.add(processInstance.getId());
        processInstance = this.executionService.startProcessInstanceByKey("abc");
        this.executionService.signalExecutionById(processInstance.getId());
        this.executionService.signalExecutionById(processInstance.getId());
        ids.add(processInstance.getId());
        processInstance = this.executionService.startProcessInstanceByKey("abc");
        this.executionService.signalExecutionById(processInstance.getId());
        ids.add(processInstance.getId());
        processInstance = this.executionService.startProcessInstanceByKey("abc");
        ids.add(processInstance.getId());
        return ids;
    }

    private void testOrderBy(String property, List<?> expectedValues) {
        this.testOrderBy(property, expectedValues, null, false);
    }

    private void testOrderByNaturalOrdening(String property, int expectedNrOfResults) {
        this.testOrderBy(property, null, expectedNrOfResults, true);
    }

    private void testOrderBy(String property, List<?> expectedValues, Integer expectedNrOfResults, boolean naturalOrderCheck) {
        this.deployStartAndSignalTestProcesses();
        List listAsc = this.historyService.createHistoryActivityInstanceQuery().orderAsc(property).list();
        List listDesc = this.historyService.createHistoryActivityInstanceQuery().orderDesc(property).list();
        if (naturalOrderCheck) {
            QueryAssertions.assertOrderIsNatural(HistoryActivityInstance.class, (String)property, (List)listAsc, (List)listDesc, (int)expectedNrOfResults);
        } else {
            QueryAssertions.assertOrderOnProperty(HistoryActivityInstance.class, (String)property, (List)listAsc, (List)listDesc, expectedValues);
        }
    }

    private String deployTestProcessWithTask() {
        return this.deployJpdlXmlString("<process name='abcd'>  <start>    <transition to='a' />  </start>  <state name='a'>    <transition to ='b' />  </state>  <task assignee='alex' name='b'>    <on event='start'>       <timer duedate='2 minutes' />    </on>    <transition to ='c' />  </task>  <state name='c'>    <transition to ='end' />  </state>  <end name='end' /></process>");
    }

    private List<String> generateHistoryForTestProcessWithTask() {
        ArrayList<String> ids = new ArrayList<String>();
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("abcd");
        this.executionService.signalExecutionById(processInstance.getId());
        this.taskService.completeTask(((Task)this.taskService.findPersonalTasks("alex").get(0)).getId());
        this.executionService.signalExecutionById(processInstance.getId());
        ids.add(processInstance.getId());
        return ids;
    }

    public void testQueryByProcessInstanceId() {
        this.deployTestProcessWithTask();
        List<String> ids = this.generateHistoryForTestProcessWithTask();
        List history = this.historyService.createHistoryActivityInstanceQuery().processInstanceId(ids.get(0)).orderAsc("id").list();
        HistoryActivityInstanceQueryTest.assertEquals((int)3, (int)history.size());
        HistoryActivityInstanceQueryTest.assertEquals((String)"a", (String)((HistoryActivityInstance)history.get(0)).getActivityName());
        HistoryActivityInstanceQueryTest.assertEquals((String)"b", (String)((HistoryActivityInstance)history.get(1)).getActivityName());
        HistoryActivityInstanceQueryTest.assertEquals((String)"c", (String)((HistoryActivityInstance)history.get(2)).getActivityName());
        HistoryActivityInstanceQueryTest.assertEquals((String)ids.get(0), (String)((HistoryActivityInstance)history.get(0)).getExecutionId());
        HistoryActivityInstanceQueryTest.assertTrue((boolean)((HistoryActivityInstance)history.get(1)).getExecutionId().startsWith(ids.get(0) + ".b."));
        HistoryActivityInstanceQueryTest.assertEquals((String)ids.get(0), (String)((HistoryActivityInstance)history.get(2)).getExecutionId());
    }

    public void testQueryByExecutionIdMissingTask() {
        this.deployTestProcessWithTask();
        List<String> ids = this.generateHistoryForTestProcessWithTask();
        List history = this.historyService.createHistoryActivityInstanceQuery().executionId(ids.get(0)).orderAsc("id").list();
        HistoryActivityInstanceQueryTest.assertEquals((int)2, (int)history.size());
        HistoryActivityInstanceQueryTest.assertEquals((String)"a", (String)((HistoryActivityInstance)history.get(0)).getActivityName());
        HistoryActivityInstanceQueryTest.assertEquals((String)"c", (String)((HistoryActivityInstance)history.get(1)).getActivityName());
    }
}

