/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.variables;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.jbpm.api.ProcessInstance;
import org.jbpm.api.activity.ActivityBehaviour;
import org.jbpm.api.activity.ActivityExecution;
import org.jbpm.test.JbpmTestCase;

public class SerializedVariableUpdateTest
extends JbpmTestCase {
    public void testSerializableVariableUpdate() {
        this.deployJpdlXmlString("<process name='SerializedVariableUpdate'>  <start>    <transition to='wait before' />  </start>  <state name='wait before'>    <transition to='update' />  </state>  <custom name='update' class='" + UpdateAndReplace.class.getName() + "'>" + "    <transition to='wait after' />" + "  </custom>" + "  <state name='wait after'/>" + "</process>");
        Set<String> messages = new HashSet<String>();
        messages.add("serialize");
        messages.add("me");
        HashMap<String, HashSet<String>> variables = new HashMap<String, HashSet<String>>();
        variables.put("messages", (HashSet<String>)messages);
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("SerializedVariableUpdate", variables);
        String pid = processInstance.getId();
        this.executionService.signalExecutionById(pid);
        HashSet<String> expectedMessages = new HashSet<String>();
        expectedMessages.add("completely");
        expectedMessages.add("new");
        expectedMessages.add("object");
        messages = (Set)this.executionService.getVariable(pid, "messages");
        SerializedVariableUpdateTest.assertEquals(expectedMessages, messages);
    }

    public void testReadOnly() {
        this.deployJpdlXmlString("<process name='SerializedVariableUpdate'>  <start>    <transition to='wait before' />  </start>  <state name='wait before'>    <transition to='update' />  </state>  <custom name='update' class='" + ReadOnly.class.getName() + "'>" + "    <transition to='wait after' />" + "  </custom>" + "  <state name='wait after'/>" + "</process>");
        Set<String> messages = new HashSet<String>();
        messages.add("serialize");
        messages.add("me");
        HashMap<String, HashSet<String>> variables = new HashMap<String, HashSet<String>>();
        variables.put("messages", (HashSet<String>)messages);
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("SerializedVariableUpdate", variables);
        String pid = processInstance.getId();
        this.executionService.signalExecutionById(pid);
        HashSet<String> expectedMessages = new HashSet<String>();
        expectedMessages.add("serialize");
        expectedMessages.add("me");
        messages = (Set)this.executionService.getVariable(pid, "messages");
        SerializedVariableUpdateTest.assertEquals(expectedMessages, messages);
    }

    public static class ReadOnly
    implements ActivityBehaviour {
        private static final long serialVersionUID = 1L;

        public void execute(ActivityExecution execution) throws Exception {
            execution.getVariable("messages");
            execution.getVariable("messages");
        }
    }

    public static class UpdateAndReplace
    implements ActivityBehaviour {
        private static final long serialVersionUID = 1L;

        public void execute(ActivityExecution execution) throws Exception {
            Set messages = (Set)execution.getVariable("messages");
            messages.clear();
            messages.add("i");
            messages.add("was");
            messages.add("updated");
            HashSet<String> newMessagesObject = new HashSet<String>();
            newMessagesObject.add("completely");
            newMessagesObject.add("new");
            newMessagesObject.add("object");
            execution.setVariable("messages", newMessagesObject);
        }
    }
}

