/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tendon.convert.json;

import com.tencent.tendon.convert.json.JsonAttribute;
import com.tencent.tendon.convert.json.JsonAttributes;
import com.tencent.tendon.convert.json.JsonDeHandle;
import com.tencent.tendon.convert.json.JsonDeHandles;
import com.tencent.tendon.convert.json.JsonDefaultToken;
import com.tencent.tendon.convert.json.JsonException;
import com.tencent.tendon.convert.json.JsonFactory;
import com.tencent.tendon.convert.json.JsonListener;
import com.tencent.tendon.convert.json.JsonRef;
import com.tencent.tendon.convert.json.JsonTokens;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;

class JsonDeCompiler {
    JsonDeCompiler() {
    }

    public static void compileJsonDefaultToken(Class clazz) {
        Method[] methodArray = clazz.getMethods();
        JsonDefaultToken jsonDefaultToken = new JsonDefaultToken(clazz);
        JsonFactory.register0(clazz, jsonDefaultToken);
        ArrayList<JsonDeHandle> arrayList = new ArrayList<JsonDeHandle>();
        for (Method method : methodArray) {
            Object object;
            Object object2;
            JsonListener<?> jsonListener;
            Class<Object> clazz2;
            if (method.getName().length() < 4 || !method.getName().startsWith("set") || method.getParameterTypes().length != 1 || Modifier.isStatic(method.getModifiers()) || Modifier.isAbstract(method.getModifiers())) continue;
            Class clazz3 = JsonAttributes.findFieldType(method);
            JsonAttribute jsonAttribute = JsonAttributes.createJsonAttribute(method);
            JsonRef jsonRef = method.getAnnotation(JsonRef.class);
            JsonListener jsonListener2 = JsonFactory.findListener(clazz3);
            if (jsonRef != null && jsonRef.listener() != JsonListener.class) {
                try {
                    jsonListener2 = jsonRef.listener().newInstance();
                }
                catch (Exception exception) {
                    System.err.println(method + "have iIllegal JsonListener");
                    exception.printStackTrace();
                }
            }
            if (jsonListener2 != null) {
                arrayList.add(JsonDeHandles.createJsonDeHandle(clazz3, jsonAttribute, jsonListener2));
                continue;
            }
            if (JsonFactory.findJsonToken(clazz3) != null) {
                arrayList.add(JsonDeHandles.createJsonDeHandle(clazz3, jsonAttribute, JsonFactory.findJsonToken(clazz3)));
                continue;
            }
            if (clazz3.isArray()) {
                clazz2 = jsonRef == null || jsonRef.component() == Void.TYPE ? clazz3.getComponentType() : jsonRef.component();
                jsonListener = JsonFactory.findListener(clazz2);
                if (jsonListener != null) {
                    arrayList.add(JsonDeHandles.createJsonDeHandle(clazz3, jsonAttribute, JsonTokens.createJsonArrayToken(jsonListener)));
                    continue;
                }
                if (JsonFactory.findJsonToken(clazz2) != null) {
                    arrayList.add(JsonDeHandles.createJsonDeHandle(clazz3, jsonAttribute, JsonTokens.createJsonArrayToken(JsonFactory.findJsonToken(clazz2))));
                    continue;
                }
                if (clazz2.isArray() || Collection.class.isAssignableFrom(clazz2) || Map.class.isAssignableFrom(clazz2) || clazz2.getName().startsWith("java.") || clazz2.getName().startsWith("javax.")) {
                    throw new JsonException("not support the type (" + clazz2 + ") of the method (" + method + ")");
                }
                JsonDeCompiler.compileJsonDefaultToken(clazz2);
                arrayList.add(JsonDeHandles.createJsonDeHandle(clazz3, jsonAttribute, JsonTokens.createJsonArrayToken(JsonFactory.findJsonToken(clazz2))));
                continue;
            }
            if (Collection.class.isAssignableFrom(clazz3)) {
                Class<Object> clazz4 = clazz2 = jsonRef == null || jsonRef.type() == Void.TYPE ? clazz3 : jsonRef.type();
                if (clazz2.isAssignableFrom(ArrayList.class)) {
                    clazz2 = ArrayList.class;
                } else if (clazz2.isAssignableFrom(HashSet.class)) {
                    clazz2 = HashSet.class;
                } else if (clazz2.isAssignableFrom(LinkedList.class)) {
                    clazz2 = LinkedList.class;
                }
                if (!Collection.class.isAssignableFrom(clazz2)) {
                    throw new JsonException("unknown Collection.class to the type (" + clazz2 + ") of the method (" + method + ")");
                }
                JsonListener<?> jsonListener3 = jsonListener = jsonRef == null || jsonRef.component() == Void.TYPE ? null : jsonRef.component();
                if (jsonListener == null) {
                    object2 = method.getGenericParameterTypes();
                    if (((Type[])object2).length != 1 || !(object2[0] instanceof ParameterizedType)) {
                        throw new JsonException("not support the method (" + method + ")");
                    }
                    object = ((ParameterizedType)object2[0]).getActualTypeArguments()[0];
                    if (!(object instanceof Class)) {
                        throw new JsonException("not support the method (" + method + ")");
                    }
                    jsonListener = (Class)object;
                }
                if (JsonFactory.findListener(jsonListener) != null) {
                    arrayList.add(JsonDeHandles.createJsonDeHandle(clazz3, jsonAttribute, JsonTokens.createJsonCollectionToken(clazz2, JsonFactory.findListener(jsonListener))));
                    continue;
                }
                if (JsonFactory.findJsonToken(jsonListener) != null) {
                    arrayList.add(JsonDeHandles.createJsonDeHandle(clazz3, jsonAttribute, JsonTokens.createJsonCollectionToken(clazz2, JsonFactory.findJsonToken(jsonListener))));
                    continue;
                }
                if (((Class)((Object)jsonListener)).isArray() || Collection.class.isAssignableFrom((Class<?>)((Object)jsonListener)) || Map.class.isAssignableFrom((Class<?>)((Object)jsonListener)) || ((Class)((Object)jsonListener)).getName().startsWith("java.") || ((Class)((Object)jsonListener)).getName().startsWith("javax.")) {
                    throw new JsonException("not support the type (" + jsonListener + ") of the method (" + method + ")");
                }
                JsonDeCompiler.compileJsonDefaultToken((Class)((Object)jsonListener));
                arrayList.add(JsonDeHandles.createJsonDeHandle(clazz3, jsonAttribute, JsonTokens.createJsonCollectionToken(clazz2, JsonFactory.findJsonToken(jsonListener))));
                continue;
            }
            if (Map.class.isAssignableFrom(clazz3)) {
                Type[] typeArray;
                Class<Object> clazz5 = clazz2 = jsonRef == null || jsonRef.type() == Void.TYPE ? clazz3 : jsonRef.type();
                if (clazz2.isAssignableFrom(HashMap.class)) {
                    clazz2 = HashMap.class;
                }
                if (!Map.class.isAssignableFrom(clazz2)) {
                    throw new JsonException("unknown Map.class to the type (" + clazz2 + ") of the method (" + method + ")");
                }
                jsonListener = jsonRef == null || jsonRef.comptypes().length < 1 ? null : jsonRef.comptypes()[0];
                Object object3 = object2 = jsonRef == null || jsonRef.comptypes().length < 2 ? null : jsonRef.comptypes()[1];
                if (jsonListener == null) {
                    object = method.getGenericParameterTypes();
                    if (((Type[])object).length != 1 || !(object[0] instanceof ParameterizedType)) {
                        throw new JsonException("not support the method (" + method + ")");
                    }
                    typeArray = ((ParameterizedType)object[0]).getActualTypeArguments();
                    if (!(typeArray[0] instanceof Class)) {
                        throw new JsonException("not support the method (" + method + ")");
                    }
                    jsonListener = (Class)typeArray[0];
                }
                if ((object = JsonFactory.findListener(jsonListener)) == null) {
                    throw new JsonException("not support the method (" + method + ")");
                }
                if (object2 == null) {
                    typeArray = method.getGenericParameterTypes();
                    if (typeArray.length != 1 || !(typeArray[0] instanceof ParameterizedType)) {
                        throw new JsonException("not support the method (" + method + ")");
                    }
                    Type[] typeArray2 = ((ParameterizedType)typeArray[0]).getActualTypeArguments();
                    Type type = typeArray2[1];
                    if (!(type instanceof Class)) {
                        throw new JsonException("not support the method (" + method + ")");
                    }
                    object2 = (Class)type;
                }
                if (JsonFactory.findListener(object2) != null) {
                    arrayList.add(JsonDeHandles.createJsonDeHandle(clazz3, jsonAttribute, JsonTokens.createJsonMapToken(clazz2, object, JsonFactory.findListener(object2))));
                    continue;
                }
                if (JsonFactory.findJsonToken(object2) != null) {
                    arrayList.add(JsonDeHandles.createJsonDeHandle(clazz3, jsonAttribute, JsonTokens.createJsonMapToken(clazz2, object, JsonFactory.findJsonToken(object2))));
                    continue;
                }
                if (object2.isArray() || Collection.class.isAssignableFrom((Class<?>)object2) || Map.class.isAssignableFrom((Class<?>)object2) || object2.getName().startsWith("java.") || object2.getName().startsWith("javax.")) {
                    throw new JsonException("not support the type (" + object2 + ") of the method (" + method + ")");
                }
                JsonDeCompiler.compileJsonDefaultToken((Class)object2);
                arrayList.add(JsonDeHandles.createJsonDeHandle(clazz3, jsonAttribute, JsonTokens.createJsonMapToken(clazz2, object, JsonFactory.findJsonToken(object2))));
                continue;
            }
            if (clazz3.getName().startsWith("java.") || clazz3.getName().startsWith("javax.")) {
                throw new JsonException("not support the type (" + clazz3 + ") of the method (" + method + ")");
            }
            JsonDeCompiler.compileJsonDefaultToken(clazz3);
            arrayList.add(JsonDeHandles.createJsonDeHandle(clazz3, jsonAttribute, JsonFactory.findJsonToken(clazz3)));
        }
        jsonDefaultToken.head = JsonDeHandles.link(arrayList);
        Object object = jsonDefaultToken.head;
        int n = 1;
        do {
            int n2 = n = n != 0 && object.isSimpled() ? 1 : 0;
        } while ((object = ((JsonDeHandle)object).next) != null);
        jsonDefaultToken.simpled = n;
    }
}

