/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tendon.convert.json;

import com.tencent.tendon.convert.json.JsonAttribute;
import com.tencent.tendon.convert.json.JsonDeHandle;
import com.tencent.tendon.convert.json.JsonException;
import com.tencent.tendon.convert.json.JsonReadable;
import com.tencent.tendon.convert.json.JsonReader;
import com.tencent.tendon.convert.json.JsonXAttribute;
import com.tencent.tendon.convert.json.JsonXListener;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsonDeHandles {
    private JsonDeHandles() {
    }

    public static <T, V> JsonDeHandle<T, V> createJsonDeHandle(Class clazz, JsonAttribute jsonAttribute, JsonReadable jsonReadable) {
        if (clazz == null) {
            return new JsonObjectDeHandle(jsonAttribute, jsonReadable);
        }
        if (clazz == Boolean.TYPE) {
            return new JsonBoolDeHandle((JsonXAttribute)jsonAttribute);
        }
        if (clazz == Byte.TYPE) {
            return new JsonByteDeHandle((JsonXAttribute)jsonAttribute);
        }
        if (clazz == Short.TYPE) {
            return new JsonShortDeHandle((JsonXAttribute)jsonAttribute);
        }
        if (clazz == Character.TYPE) {
            return new JsonCharDeHandle((JsonXAttribute)jsonAttribute);
        }
        if (clazz == Integer.TYPE) {
            return new JsonIntDeHandle((JsonXAttribute)jsonAttribute);
        }
        if (clazz == Float.TYPE) {
            return new JsonFloatDeHandle((JsonXAttribute)jsonAttribute);
        }
        if (clazz == Long.TYPE) {
            return new JsonLongDeHandle((JsonXAttribute)jsonAttribute);
        }
        if (clazz == Double.TYPE) {
            return new JsonDoubleDeHandle((JsonXAttribute)jsonAttribute);
        }
        if (clazz == String.class) {
            return new JsonStringDeHandle((JsonXAttribute)jsonAttribute);
        }
        return new JsonObjectDeHandle(jsonAttribute, jsonReadable);
    }

    public static <T> JsonDeHandle link(List<JsonDeHandle> list) {
        JsonDeHandle jsonDeHandle;
        if (list.isEmpty()) {
            return JsonDeHandle.NULL;
        }
        Collections.sort(list);
        int n = list.size() - 1;
        JsonDeHandle jsonDeHandle2 = null;
        for (int i = n; i >= 0; --i) {
            jsonDeHandle = list.get(i);
            if (jsonDeHandle instanceof JsonObjectDeHandle) {
                jsonDeHandle2 = new JsonObjectDeHandle((JsonObjectDeHandle)jsonDeHandle, jsonDeHandle2);
                continue;
            }
            if (jsonDeHandle instanceof JsonBoolDeHandle) {
                jsonDeHandle2 = new JsonBoolDeHandle((JsonBoolDeHandle)jsonDeHandle, jsonDeHandle2);
                continue;
            }
            if (jsonDeHandle instanceof JsonByteDeHandle) {
                jsonDeHandle2 = new JsonByteDeHandle((JsonByteDeHandle)jsonDeHandle, jsonDeHandle2);
                continue;
            }
            if (jsonDeHandle instanceof JsonShortDeHandle) {
                jsonDeHandle2 = new JsonShortDeHandle((JsonShortDeHandle)jsonDeHandle, jsonDeHandle2);
                continue;
            }
            if (jsonDeHandle instanceof JsonCharDeHandle) {
                jsonDeHandle2 = new JsonCharDeHandle((JsonCharDeHandle)jsonDeHandle, jsonDeHandle2);
                continue;
            }
            if (jsonDeHandle instanceof JsonIntDeHandle) {
                jsonDeHandle2 = new JsonIntDeHandle((JsonIntDeHandle)jsonDeHandle, jsonDeHandle2);
                continue;
            }
            if (jsonDeHandle instanceof JsonFloatDeHandle) {
                jsonDeHandle2 = new JsonFloatDeHandle((JsonFloatDeHandle)jsonDeHandle, jsonDeHandle2);
                continue;
            }
            if (jsonDeHandle instanceof JsonLongDeHandle) {
                jsonDeHandle2 = new JsonLongDeHandle((JsonLongDeHandle)jsonDeHandle, jsonDeHandle2);
                continue;
            }
            if (jsonDeHandle instanceof JsonDoubleDeHandle) {
                jsonDeHandle2 = new JsonDoubleDeHandle((JsonDoubleDeHandle)jsonDeHandle, jsonDeHandle2);
                continue;
            }
            if (jsonDeHandle instanceof JsonStringDeHandle) {
                jsonDeHandle2 = new JsonStringDeHandle((JsonStringDeHandle)jsonDeHandle, jsonDeHandle2);
                continue;
            }
            throw new JsonException("unknown JsonDeHandle " + jsonDeHandle2);
        }
        JsonDeHandle jsonDeHandle3 = jsonDeHandle2;
        jsonDeHandle = null;
        do {
            jsonDeHandle2.parent = jsonDeHandle;
            jsonDeHandle = jsonDeHandle2;
        } while ((jsonDeHandle2 = jsonDeHandle2.next) != null);
        return jsonDeHandle3;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JsonStringDeHandle<T>
    extends JsonDeXHandle<T> {
        public JsonStringDeHandle(JsonStringDeHandle<T> jsonStringDeHandle, JsonDeHandle<T, ?> jsonDeHandle) {
            super(jsonStringDeHandle, jsonDeHandle);
        }

        public JsonStringDeHandle(JsonXAttribute<T> jsonXAttribute) {
            super(jsonXAttribute);
        }

        @Override
        public void set(JsonReader jsonReader, T t) {
            this.attribute.setString(t, this.listener.convertStringFrom(jsonReader));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JsonDoubleDeHandle<T>
    extends JsonDeXHandle<T> {
        public JsonDoubleDeHandle(JsonDoubleDeHandle<T> jsonDoubleDeHandle, JsonDeHandle<T, ?> jsonDeHandle) {
            super(jsonDoubleDeHandle, jsonDeHandle);
        }

        public JsonDoubleDeHandle(JsonXAttribute<T> jsonXAttribute) {
            super(jsonXAttribute);
        }

        @Override
        public void set(JsonReader jsonReader, T t) {
            this.attribute.setDouble(t, this.listener.convertDoubleFrom(jsonReader));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JsonLongDeHandle<T>
    extends JsonDeXHandle<T> {
        public JsonLongDeHandle(JsonLongDeHandle<T> jsonLongDeHandle, JsonDeHandle<T, ?> jsonDeHandle) {
            super(jsonLongDeHandle, jsonDeHandle);
        }

        public JsonLongDeHandle(JsonXAttribute<T> jsonXAttribute) {
            super(jsonXAttribute);
        }

        @Override
        public void set(JsonReader jsonReader, T t) {
            this.attribute.setLong(t, this.listener.convertLongFrom(jsonReader));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JsonFloatDeHandle<T>
    extends JsonDeXHandle<T> {
        public JsonFloatDeHandle(JsonFloatDeHandle<T> jsonFloatDeHandle, JsonDeHandle<T, ?> jsonDeHandle) {
            super(jsonFloatDeHandle, jsonDeHandle);
        }

        public JsonFloatDeHandle(JsonXAttribute<T> jsonXAttribute) {
            super(jsonXAttribute);
        }

        @Override
        public void set(JsonReader jsonReader, T t) {
            this.attribute.setFloat(t, this.listener.convertFloatFrom(jsonReader));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JsonIntDeHandle<T>
    extends JsonDeXHandle<T> {
        public JsonIntDeHandle(JsonIntDeHandle<T> jsonIntDeHandle, JsonDeHandle<T, ?> jsonDeHandle) {
            super(jsonIntDeHandle, jsonDeHandle);
        }

        public JsonIntDeHandle(JsonXAttribute<T> jsonXAttribute) {
            super(jsonXAttribute);
        }

        @Override
        public void set(JsonReader jsonReader, T t) {
            this.attribute.setInt(t, this.listener.convertIntFrom(jsonReader));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JsonCharDeHandle<T>
    extends JsonDeXHandle<T> {
        public JsonCharDeHandle(JsonCharDeHandle<T> jsonCharDeHandle, JsonDeHandle<T, ?> jsonDeHandle) {
            super(jsonCharDeHandle, jsonDeHandle);
        }

        public JsonCharDeHandle(JsonXAttribute<T> jsonXAttribute) {
            super(jsonXAttribute);
        }

        @Override
        public void set(JsonReader jsonReader, T t) {
            this.attribute.setChar(t, this.listener.convertCharFrom(jsonReader));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JsonShortDeHandle<T>
    extends JsonDeXHandle<T> {
        public JsonShortDeHandle(JsonShortDeHandle<T> jsonShortDeHandle, JsonDeHandle<T, ?> jsonDeHandle) {
            super(jsonShortDeHandle, jsonDeHandle);
        }

        public JsonShortDeHandle(JsonXAttribute<T> jsonXAttribute) {
            super(jsonXAttribute);
        }

        @Override
        public void set(JsonReader jsonReader, T t) {
            this.attribute.setShort(t, this.listener.convertShortFrom(jsonReader));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JsonByteDeHandle<T>
    extends JsonDeXHandle<T> {
        public JsonByteDeHandle(JsonByteDeHandle<T> jsonByteDeHandle, JsonDeHandle<T, ?> jsonDeHandle) {
            super(jsonByteDeHandle, jsonDeHandle);
        }

        public JsonByteDeHandle(JsonXAttribute<T> jsonXAttribute) {
            super(jsonXAttribute);
        }

        @Override
        public void set(JsonReader jsonReader, T t) {
            this.attribute.setByte(t, this.listener.convertByteFrom(jsonReader));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JsonBoolDeHandle<T>
    extends JsonDeXHandle<T> {
        public JsonBoolDeHandle(JsonBoolDeHandle<T> jsonBoolDeHandle, JsonDeHandle<T, ?> jsonDeHandle) {
            super(jsonBoolDeHandle, jsonDeHandle);
        }

        public JsonBoolDeHandle(JsonXAttribute<T> jsonXAttribute) {
            super(jsonXAttribute);
        }

        @Override
        public void set(JsonReader jsonReader, T t) {
            this.attribute.setBoolean(t, this.listener.convertBooleanFrom(jsonReader));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class JsonDeXHandle<T>
    extends JsonDeHandle<T, Void> {
        protected final JsonXAttribute<T> attribute;
        protected final JsonXListener listener = JsonXListener.getInstance();

        public JsonDeXHandle(JsonDeXHandle<T> jsonDeXHandle, JsonDeHandle<T, ?> jsonDeHandle) {
            super(jsonDeXHandle, jsonDeHandle);
            this.attribute = jsonDeXHandle.attribute;
        }

        public JsonDeXHandle(JsonXAttribute<T> jsonXAttribute) {
            super(jsonXAttribute == null ? "" : jsonXAttribute.field());
            this.attribute = jsonXAttribute;
        }

        @Override
        public abstract void set(JsonReader var1, T var2);

        @Override
        public final boolean isSimpled() {
            return true;
        }

        public String toString() {
            return "{field:" + String.format("%12s", this.field) + ", token:" + String.format("%25s", this.listener.getClass().getSimpleName()) + ", attribute:" + String.format("%32s", this.attribute.getClass().getSimpleName()) + ", name:" + String.format("%20s", this.getClass().getSimpleName()) + ", \r\n   next:" + this.next + "}";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JsonObjectDeHandle<T, V>
    extends JsonDeHandle<T, V> {
        private final JsonAttribute<T, V> attribute;
        private final JsonReadable<V> token;

        public JsonObjectDeHandle(JsonObjectDeHandle<T, V> jsonObjectDeHandle, JsonDeHandle<T, ?> jsonDeHandle) {
            super(jsonObjectDeHandle, jsonDeHandle);
            this.attribute = jsonObjectDeHandle.attribute;
            this.token = jsonObjectDeHandle.token;
        }

        public JsonObjectDeHandle(JsonAttribute<T, V> jsonAttribute, JsonReadable<V> jsonReadable) {
            super(jsonAttribute == null ? "" : jsonAttribute.field());
            this.attribute = jsonAttribute;
            this.token = jsonReadable;
        }

        @Override
        public final void set(JsonReader jsonReader, T t) {
            this.attribute.set(t, this.token.convertFrom(jsonReader));
        }

        @Override
        public final boolean isSimpled() {
            return this.token.isSimpled();
        }

        public String toString() {
            return "{field:" + String.format("%12s", this.field) + ", token:" + String.format("%25s", this.token.isSimpled() ? this.token.toString() : this.token.getClass().getSimpleName()) + ", attribute:" + String.format("%32s", this.attribute.getClass().getSimpleName()) + ", name:" + String.format("%20s", this.getClass().getSimpleName()) + ", \r\n   next:" + this.next + "}";
        }
    }
}

