/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tendon.convert.json;

import com.tencent.tendon.convert.json.JsonDeHandle;
import com.tencent.tendon.convert.json.JsonException;
import com.tencent.tendon.convert.json.JsonListener;
import com.tencent.tendon.convert.json.JsonPool;
import com.tencent.tendon.convert.json.JsonPoolable;
import com.tencent.tendon.convert.json.JsonStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JsonReader
implements JsonPoolable {
    protected int position = -1;
    protected JsonStack stack;

    public final void offer(Object object) {
        if (this.stack == null) {
            this.stack = JsonPool.pollJsonStack();
        }
        this.stack.offer(object);
    }

    public final <T> T stackOf(int n) {
        if (this.stack == null) {
            return null;
        }
        return this.stack.stackOf(n);
    }

    public final void poll() {
        if (this.stack != null) {
            this.stack.poll();
        }
    }

    public final int position() {
        return this.position;
    }

    @Override
    public void prepare() {
    }

    @Override
    public void release() {
        this.position = -1;
        if (this.stack != null) {
            JsonPool.offer(this.stack);
            this.stack = null;
        }
    }

    public void close() {
        this.release();
    }

    public final void skipValue() {
        char c = this.readChar();
        if (c == '\"' || c == '\'') {
            this.back(c);
            this.readString();
            return;
        }
        if (c == '{') {
            while (this.hasNext()) {
                this.readField(JsonDeHandle.NULL);
                this.checkColon();
                this.skipValue();
            }
        } else if (c == '[') {
            while (this.hasNext()) {
                this.skipValue();
            }
        } else {
            char c2;
            do {
                if ((c2 = this.nextChar()) > ' ') continue;
                return;
            } while (c2 != '}' && c2 != ']' && c2 != ',' && c2 != ':');
            this.back(c2);
            return;
        }
    }

    protected abstract char nextChar();

    protected char readChar() {
        char c = this.nextChar();
        if (c > ' ') {
            return c;
        }
        while ((c = this.nextChar()) <= ' ') {
        }
        return c;
    }

    protected abstract void back(char var1);

    public void checkObject() {
        if (this.readChar() != '{') {
            throw new JsonException("a json object text must begin with '{' (position = " + this.position + ")");
        }
    }

    public boolean checkArray() {
        char c = this.readChar();
        if (c == '[') {
            return true;
        }
        if (c == '{') {
            return false;
        }
        throw new JsonException("a json array text must begin with '[' (position = " + this.position + ")");
    }

    public void checkColon() {
        if (this.readChar() != ':') {
            throw new JsonException("expected a ':' after a key (position = " + this.position + ")");
        }
    }

    public boolean hasNext() {
        char c = this.readChar();
        if (c == ',') {
            return true;
        }
        if (c == '}' || c == ']') {
            return false;
        }
        this.back(c);
        return true;
    }

    public abstract JsonDeHandle readField(JsonDeHandle var1);

    public abstract char[] readValue();

    public abstract <T> T readValue(JsonListener<T> var1);

    protected abstract int readInt();

    protected abstract long readLong();

    protected abstract String readString();
}

