/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tendon.convert.json.printers;

import com.tencent.tendon.convert.json.JsonPrinter;
import com.tencent.tendon.convert.json.JsonWriter;
import com.tencent.tendon.convert.json.JsonXListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsonFloatArrayPrinter
extends JsonPrinter<float[]> {
    public static final JsonFloatArrayPrinter instance = new JsonFloatArrayPrinter();
    private static final JsonXListener listener = JsonXListener.getInstance();

    private JsonFloatArrayPrinter() {
    }

    @Override
    public final void convertTo(JsonWriter jsonWriter, float[] fArray) {
        float[] fArray2 = fArray;
        if (fArray2 == null) {
            jsonWriter.writeNull();
            return;
        }
        if (fArray2.length == 0) {
            jsonWriter.write('[', ']');
            return;
        }
        jsonWriter.write('[');
        boolean bl = true;
        for (float f : fArray2) {
            if (!bl) {
                jsonWriter.write(',');
            }
            listener.convertFloatTo(jsonWriter, f);
            if (!bl) continue;
            bl = false;
        }
        jsonWriter.write(']');
    }

    @Override
    public Class<float[]> getType() {
        return float[].class;
    }

    @Override
    public boolean isSimpled() {
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

